/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.math.DoubleArray;
import jhplot.math.LinearAlgebra;
import jhplot.math.StatisticSample;
import jhplot.stat.Statistics;

public class PCA {
    private double[][] X;
    private double[] meanX;
    private double[] stdevX;
    private double[][] Z;
    private double[][] cov;
    private double[][] U;
    private double[] info;

    public PCA(double[][] xy) {
        this.X = xy;
        this.eval();
    }

    public void eval() {
        this.stdevX = StatisticSample.stddeviation(this.X);
        this.meanX = StatisticSample.mean(this.X);
        this.Z = this.center_reduce(this.X);
        this.cov = Statistics.covariance(this.Z);
        EigenvalueDecomposition e = LinearAlgebra.eigen(this.cov);
        Matrix m = e.getV();
        this.U = LinearAlgebra.transpose(m.getArray());
        this.info = e.getRealEigenvalues();
    }

    public PCA(P1D p1d) {
        int size = p1d.size();
        this.X = new double[size][2];
        for (int i = 0; i < size; ++i) {
            this.X[i][0] = p1d.getX(i);
            this.X[i][1] = p1d.getY(i);
        }
        this.eval();
    }

    public double[][] center_reduce(double[][] x) {
        double[][] y = new double[x.length][x[0].length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < y[i].length; ++j) {
                y[i][j] = (x[i][j] - this.meanX[j]) / this.stdevX[j];
            }
        }
        return y;
    }

    public double[] inv_center_reduce(double[] y) {
        return this.inv_center_reduce(new double[][]{y})[0];
    }

    public double[][] inv_center_reduce(double[][] y) {
        double[][] x = new double[y.length][y[0].length];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                x[i][j] = y[i][j] * this.stdevX[j] + this.meanX[j];
            }
        }
        return x;
    }

    private void view() {
    }

    public String getSummary() {
        String tmp = "";
        tmp = tmp + "projection vectors: \n" + DoubleArray.toString(LinearAlgebra.transpose(this.U)) + "\n";
        tmp = tmp + "\ninformation per projection vector: " + DoubleArray.toString(new double[][]{this.info}) + "\n";
        return tmp;
    }

    public double getEigenvalue(int k) {
        return this.info[k];
    }

    public double getEigenvalueTot(int k) {
        return Math.rint(this.info[k] * 100.0 / LinearAlgebra.sum(this.info));
    }

    public double getCoordinate(int k, int i) {
        return this.inv_center_reduce(this.U[k])[i];
    }

    public double[][] getCovariance() {
        return this.cov;
    }

    public double[] getD() {
        double[] x = new double[this.info.length];
        for (int i = 0; i < this.info.length; ++i) {
            x[i] = Math.rint(this.info[0] * 100.0 / LinearAlgebra.sum(this.info));
        }
        return x;
    }

    public double getMean(int k) {
        return this.meanX[k];
    }

    public double getStd(int k) {
        return this.stdevX[k];
    }

    public static void main(String[] args) {
        double[][] xinit = LinearAlgebra.random(1000, 2, 0.0, 10.0);
        double[][] x = new double[xinit.length][];
        for (int i = 0; i < x.length; ++i) {
            x[i] = new double[]{xinit[i][0] + xinit[i][1], xinit[i][1]};
        }
        PCA pca = new PCA(x);
        System.out.println(pca.toString());
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

