/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.stat.JointProbabilityState;
import jhplot.stat.ProbabilityState;

public abstract class Entropy {
    public static double LOG_BASE = 2.0;

    private Entropy() {
    }

    public static double calculateEntropy(double[] dataVector) {
        ProbabilityState state = new ProbabilityState(dataVector);
        double entropy = 0.0;
        for (Double prob : state.probMap.values()) {
            if (!(prob > 0.0)) continue;
            entropy -= prob * Math.log(prob);
        }
        return entropy /= Math.log(LOG_BASE);
    }

    public static strictfp double calculateConditionalEntropy(double[] dataVector, double[] conditionVector) {
        JointProbabilityState state = new JointProbabilityState(dataVector, conditionVector);
        int numFirstStates = state.firstMaxVal;
        double condEntropy = 0.0;
        for (Integer key : state.jointProbMap.keySet()) {
            double jointValue = state.jointProbMap.get(key);
            double condValue = state.secondProbMap.get(key / numFirstStates);
            if (!(jointValue > 0.0) || !(condValue > 0.0)) continue;
            condEntropy -= jointValue * Math.log(jointValue / condValue);
        }
        return condEntropy /= Math.log(LOG_BASE);
    }

    public static double calculateJointEntropy(double[] firstVector, double[] secondVector) {
        JointProbabilityState state = new JointProbabilityState(firstVector, secondVector);
        double entropy = 0.0;
        for (Double prob : state.jointProbMap.values()) {
            if (!(prob > 0.0)) continue;
            entropy -= prob * Math.log(prob);
        }
        return entropy /= Math.log(LOG_BASE);
    }
}

