/*
 * Decompiled with CFR 0.152.
 */
package jhplot.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.io.Serializable;
import jplot.XMLRead;
import jplot.XMLWrite;

public class HShape
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double width = 5.0;
    protected double length = 10.0;
    protected Font f = new Font("sansserif", 1, 16);
    protected double rotate = 0.0;
    protected String text = "not set";
    public static final int LINE = 1;
    public static final int ARROW = 2;
    public static final int TEXT = 3;
    public static final int IMAGE = 4;
    public static final int CIRCLE = 5;
    public static final int ELLIPSE = 6;
    public static final int RECTAN = 7;
    public static final int POLYGON = 8;
    protected static final Stroke DFS = new BasicStroke(2.0f);
    protected Stroke strock = new BasicStroke();
    protected Color color;
    protected double X1;
    protected double Y1;
    protected double X2;
    protected double Y2;
    protected float transp;
    protected int whoAm = 0;
    protected boolean fill = false;
    protected double[] XX;
    protected double[] YY;
    protected int usePosition = 2;

    public HShape(double X1, double Y1, double X2, double Y2, Stroke stroke, Color color) {
        this.strock = stroke;
        this.color = color;
        this.X1 = X1;
        this.Y1 = Y1;
        this.X2 = X2;
        this.Y2 = Y2;
        this.transp = 1.0f;
    }

    public HShape() {
        this.strock = DFS;
        this.color = Color.black;
        this.X1 = 0.0;
        this.Y1 = 0.0;
        this.X2 = 0.0;
        this.Y2 = 0.0;
        this.transp = 1.0f;
    }

    public HShape(double X1, double Y1, double X2, double Y2) {
        this.X1 = X1;
        this.Y1 = Y1;
        this.X2 = X2;
        this.Y2 = Y2;
        this.strock = new BasicStroke(2.0f);
        this.color = Color.black;
        this.transp = 1.0f;
    }

    public HShape(double[] XX, double[] YY, Stroke strock, Color color) {
        this.strock = strock;
        this.color = color;
        this.XX = XX;
        this.YY = YY;
        this.transp = 1.0f;
    }

    public double[] getPosition() {
        double[] pos = new double[]{this.X1, this.Y1, this.X2, this.Y2};
        return pos;
    }

    public void setRotation(double theta) {
        this.rotate = theta;
    }

    public double getRotation() {
        return this.rotate;
    }

    public double[] getScaledPosition(double Xscale, double Yscale) {
        double[] pos = new double[]{this.X1 * Xscale, this.Y1 * Yscale, this.X2 * Xscale, this.Y2 * Yscale};
        return pos;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.strock;
    }

    public void setStroke(Stroke stroke) {
        this.strock = stroke;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public boolean getFill() {
        return this.fill;
    }

    public boolean contains(double Xm, double Ym) {
        return true;
    }

    public Float getTransparency() {
        return Float.valueOf(this.transp);
    }

    public void setTransparency(double trans) {
        this.transp = (float)trans;
    }

    public int getPositionCoordinate() {
        return this.usePosition;
    }

    public void setPositionCoordinate(int usePosition) {
        this.usePosition = usePosition;
    }

    public void setPosCoord(String howToSet) {
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            if (this.X1 > 1.0) {
                this.X1 = 1.0;
            }
            if (this.Y1 > 1.0) {
                this.Y1 = 1.0;
            }
            if (this.X1 < 0.0) {
                this.X1 = 0.0;
            }
            if (this.Y1 < 0.0) {
                this.Y1 = 0.0;
            }
            if (this.X2 > 1.0) {
                this.X2 = 1.0;
            }
            if (this.Y2 > 1.0) {
                this.Y2 = 1.0;
            }
            if (this.X2 < 0.0) {
                this.X2 = 0.0;
            }
            if (this.Y2 < 0.0) {
                this.Y2 = 0.0;
            }
        }
    }

    public void setDashed(double thikness) {
        float thikne = (float)thikness;
        float miterLimit = 10.0f;
        float[] dashPattern = new float[]{10.0f};
        float dashPhase = 5.0f;
        this.strock = new BasicStroke(thikne, 0, 0, miterLimit, dashPattern, dashPhase);
    }

    public void setDotted(double thikness) {
        float thikne = (float)thikness;
        float miterLimit = 10.0f;
        float[] dashPattern = new float[]{1.0f};
        float dashPhase = 0.0f;
        this.strock = new BasicStroke(thikne, 0, 0, miterLimit, dashPattern, dashPhase);
    }

    public void getSettings(XMLWrite xw) {
        xw.add("name", String.valueOf(this.text));
        xw.add("type", String.valueOf(this.whoAm));
        xw.open("primitive");
        xw.set("color", this.getColor());
        xw.set("font", this.f);
        xw.set("stroke", (BasicStroke)this.strock);
        xw.add("rotate", String.valueOf(this.rotate));
        xw.add("fill", String.valueOf(this.fill));
        xw.add("transp", String.valueOf(this.transp));
        xw.add("usePosition", String.valueOf(this.usePosition));
        xw.set("show");
        xw.add("x1", String.valueOf(this.X1));
        xw.add("y1", String.valueOf(this.Y1));
        xw.add("x2", String.valueOf(this.X2));
        xw.add("y2", String.valueOf(this.Y2));
        xw.set("position");
        xw.add("width", String.valueOf(this.width));
        xw.add("length", String.valueOf(this.length));
        xw.open("arrow");
        xw.close();
    }

    public void updateSettings(XMLRead xr) {
        this.whoAm = xr.getInt("primitive/type", 1);
        this.text = xr.getString("primitive/text", this.text);
        this.f = xr.getFont("color", this.f);
        this.color = xr.getColor("color", this.color);
        this.strock = xr.getStroke("show/fill", (BasicStroke)this.strock);
        this.X1 = xr.getDouble("position/x1", this.X1);
        this.X2 = xr.getDouble("position/x2", this.X2);
        this.Y1 = xr.getDouble("position/y1", this.Y1);
        this.Y2 = xr.getDouble("position/y2", this.Y2);
        this.rotate = xr.getDouble("show/rotate", this.rotate);
        this.fill = xr.getBoolean("show/fill", this.fill);
        this.transp = xr.getFloat("show/transp", this.transp);
        this.usePosition = xr.getInt("show/usePosition", this.usePosition);
        this.width = xr.getDouble("arrow/width", this.width);
        this.length = xr.getDouble("arrow/length", this.length);
    }

    public void setWhoAm(int whoAm) {
        this.whoAm = whoAm;
    }

    public int getWhoAm() {
        return this.whoAm;
    }
}

