/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca.covmatrixevd;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import jhplot.math.pca.covmatrixevd.PermutationResult;
import jhplot.math.pca.covmatrixevd.ValuePlace;

public class EVD
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Matrix d;
    public final Matrix v;

    public EVD(Matrix m) {
        EigenvalueDecomposition evd = m.eig();
        double[] diagonal = EVD.getDiagonal(evd.getD());
        PermutationResult result = EVD.calculateNondecreasingPermutation(diagonal);
        int[] permutation = result.permutation;
        double[] newDiagonal = result.values;
        this.v = EVD.permutateColumns(evd.getV(), permutation);
        this.d = EVD.createDiagonalMatrix(newDiagonal);
        assert (EVD.eigenvaluesAreNonIncreasing(this.d));
    }

    private static Matrix createDiagonalMatrix(double[] diagonal) {
        Matrix m = new Matrix(diagonal.length, diagonal.length);
        for (int i = 0; i < diagonal.length; ++i) {
            m.set(i, i, diagonal[i]);
        }
        return m;
    }

    private static double[] getDiagonal(Matrix m) {
        assert (m.getRowDimension() == m.getColumnDimension());
        double[] diag = new double[m.getRowDimension()];
        for (int i = 0; i < m.getRowDimension(); ++i) {
            diag[i] = m.get(i, i);
        }
        return diag;
    }

    private static PermutationResult calculateNondecreasingPermutation(double[] vals) {
        ArrayList<ValuePlace> list = new ArrayList<ValuePlace>();
        for (int i = 0; i < vals.length; ++i) {
            list.add(new ValuePlace(vals[i], i));
        }
        Collections.sort(list);
        double[] newVals = new double[vals.length];
        int[] permutation = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            newVals[i] = ((ValuePlace)list.get((int)i)).value;
            permutation[i] = ((ValuePlace)list.get((int)i)).place;
        }
        return new PermutationResult(permutation, newVals);
    }

    private static Matrix permutateColumns(Matrix m, int[] permutation) {
        assert (m.getColumnDimension() == permutation.length);
        Matrix newM = new Matrix(m.getRowDimension(), m.getColumnDimension());
        for (int c = 0; c < newM.getColumnDimension(); ++c) {
            int copyFrom = permutation[c];
            for (int r = 0; r < newM.getRowDimension(); ++r) {
                newM.set(r, c, m.get(r, copyFrom));
            }
        }
        return newM;
    }

    private static boolean eigenvaluesAreNonIncreasing(Matrix d) {
        for (int i = 0; i < d.getRowDimension() - 1; ++i) {
            if (!(d.get(i, i) < d.get(i + 1, i + 1))) continue;
            return false;
        }
        return true;
    }
}

