/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.root;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.Function;
import jhplot.math.num.IterativeMethod;
import jhplot.math.num.NumericException;

public class SecantRootFinder
extends IterativeMethod {
    private Function function;

    public SecantRootFinder(Function f) {
        this(f, 100, 1.0E-15);
    }

    public SecantRootFinder(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public double findRoot(double x0, double x1) throws NumericException {
        double error;
        double f0 = this.function.evaluate(x0);
        double f1 = this.function.evaluate(x1);
        int n = 0;
        do {
            double delta = f1 * (x1 - x0) / (f1 - f0);
            double x = x1 - delta;
            double f = this.function.evaluate(x);
            error = Math.max(Math.abs(f), Math.abs(delta / x1));
            x0 = x1;
            f0 = f1;
            x1 = x;
            f1 = f;
        } while (++n < this.getMaximumIterations() && error > this.getMaximumRelativeError());
        if (n >= this.getMaximumIterations()) {
            throw new ConvergenceException("Secant method failed to converge.");
        }
        return x1;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

