/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.root;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.Function;
import jhplot.math.num.IterativeMethod;
import jhplot.math.num.NumericException;

public class BrentRootFinder
extends IterativeMethod {
    private Function function;

    public BrentRootFinder(Function f) {
        this(f, 100, 1.0E-15);
    }

    public BrentRootFinder(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public double findRoot(double min, double max) throws NumericException {
        double ret = Double.NaN;
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            double error;
            double a = min;
            double b = max;
            double fa = this.function.evaluate(a);
            double fb = this.function.evaluate(b);
            if (Math.abs(fa) < Math.abs(fb)) {
                double t = a;
                a = b;
                b = t;
                t = fa;
                fa = fb;
                fb = t;
            }
            int n = 0;
            double c = a;
            double fc = fa;
            double d = a;
            boolean flag = true;
            do {
                ++n;
                double s = fa != fc && fb != fc ? a * fb * fc / ((fa - fb) * (fa - fc)) + b * fa * fc / ((fb - fa) * (fb - fc)) + c * fa * fb / ((fc - fa) * (fc - fb)) : b - fb * (b - a) / (fb - fa);
                double x = (3.0 * a + b) / 4.0;
                double lb = Math.min(x, b);
                double ub = Math.max(x, b);
                if (s < lb || s > ub || flag && Math.abs(s - b) >= Math.abs(b - c) / 2.0 || !flag && Math.abs(s - b) >= Math.abs(c - d) / 2.0) {
                    s = (a + b) / 2.0;
                    flag = true;
                } else {
                    flag = false;
                }
                double fs = this.getFunction().evaluate(s);
                d = c;
                c = b;
                fc = b;
                if (fa * fs < 0.0) {
                    b = s;
                    fb = fs;
                } else {
                    a = s;
                    fa = fs;
                }
                if (Math.abs(fa) < Math.abs(fb)) {
                    double t = a;
                    a = b;
                    b = t;
                    t = fa;
                    fa = fb;
                    fb = t;
                }
                error = Math.max(Math.abs(fb), Math.abs(b / c - 1.0));
            } while (n < this.getMaximumIterations() && error > this.getMaximumRelativeError());
            if (n >= this.getMaximumIterations()) {
                throw new ConvergenceException("Brent's method failed to converge.");
            }
            ret = b;
        }
        return ret;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

