/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.NumericException;
import jhplot.math.num.pdf.DiscreteDistribution;
import jhplot.math.num.pdf.SaddlePoint;

public class Geometric
extends DiscreteDistribution {
    private double probabilityOfSuccess;

    public Geometric() {
        this(0.5);
    }

    public Geometric(double p) {
        this.setProbabilityOfSuccess(p);
    }

    @Override
    public double cumulativeProbability(int x) throws NumericException {
        double ret = x < 0 ? 0.0 : this.simpleCumulativeProbability(0, x);
        return ret;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws NumericException {
        int ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Integer.MIN_VALUE : (p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : this.findInverseCumulativeProbability(p, 0, (int)(1.0 / this.probabilityOfSuccess - 0.5), Integer.MAX_VALUE)));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret;
        if (x < 0) {
            ret = 0.0;
        } else {
            ret = Math.exp(SaddlePoint.logBinomialProbability(1, x + 1, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
            ret /= (double)x + 1.0;
        }
        return ret;
    }

    public void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

