/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.Function;
import jhplot.math.num.NumericException;
import jhplot.math.num.pdf.Distribution;
import jhplot.math.num.root.BisectionRootFinder;
import jhplot.math.num.root.Bracket;

public abstract class ContinuousDistribution
implements Distribution {
    public abstract double cumulativeProbability(double var1) throws NumericException;

    public abstract double inverseCumulativeProbability(double var1) throws NumericException;

    protected double findInverseCumulativeProbability(final double p, double lower, double initial, double upper) throws NumericException {
        Function f = new Function(){

            @Override
            public double evaluate(double x) throws NumericException {
                return ContinuousDistribution.this.cumulativeProbability(x) - p;
            }
        };
        Bracket b = new Bracket(f);
        double[] bracket = b.bracketOut(lower, initial, upper);
        BisectionRootFinder bisection = new BisectionRootFinder(f);
        return bisection.findRoot(bracket[0], bracket[1]);
    }
}

