/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.io;

import java.util.StringTokenizer;
import java.util.Vector;

public class ArrayString {
    private static String defaultWordDelimiter = " ";
    private static String defaultSentenceDelimiter = "\n";

    public static String printDoubleArray(double[][] m) {
        return ArrayString.printDoubleArray(m, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static String printDoubleArray(double[] m) {
        return ArrayString.printDoubleArray(new double[][]{m});
    }

    public static String printIntArray(int[][] m) {
        return ArrayString.printIntArray(m, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static String printIntArray(int[] m) {
        return ArrayString.printIntArray(new int[][]{m});
    }

    public static String printDoubleArray(double[][] m, String wordDelimiter, String sentenceDelimiter) {
        StringBuffer str = new StringBuffer(25 * m.length * m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                str = str.append(wordDelimiter);
                str = str.append(Double.toString(m[i][j]));
            }
            if (i >= m.length - 1) continue;
            str = str.append(sentenceDelimiter);
        }
        return str.toString();
    }

    public static String printIntArray(int[][] m, String wordDelimiter, String sentenceDelimiter) {
        StringBuffer str = new StringBuffer(25 * m.length * m[0].length);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                str = str.append(wordDelimiter);
                str = str.append(m[i][j]);
            }
            if (i >= m.length - 1) continue;
            str = str.append(sentenceDelimiter);
        }
        return str.toString();
    }

    public static double[][] readStringDouble(String s) {
        return ArrayString.readStringDouble(s, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static double[] readString1DDouble(String s) {
        return ArrayString.readString1DDouble(s, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static double[] readString1DDouble(String s, String wordDelimiter, String sentenceDelimiter) {
        double[][] d = ArrayString.readStringDouble(s, wordDelimiter, sentenceDelimiter);
        double[] d1D = null;
        if (d.length > 1) {
            d1D = new double[d.length];
            for (int i = 0; i < d1D.length; ++i) {
                d1D[i] = d[i][0];
            }
        } else {
            d1D = d[0];
        }
        return d1D;
    }

    public static double[][] readStringDouble(String s, String wordDelimiter, String sentenceDelimiter) {
        String delimiterString = wordDelimiter;
        String newlineString = sentenceDelimiter;
        StringTokenizer linesTokenizer = new StringTokenizer(s, newlineString);
        Vector<double[]> lines = new Vector<double[]>();
        int linereadFailed = 0;
        do {
            Vector<Double> words = new Vector<Double>();
            String line = linesTokenizer.nextToken();
            StringTokenizer wordsTokenizer = new StringTokenizer(line, delimiterString);
            int readFailed = 0;
            do {
                try {
                    words.addElement(Double.valueOf(wordsTokenizer.nextToken()));
                }
                catch (NumberFormatException ex) {
                    ++readFailed;
                }
            } while (wordsTokenizer.hasMoreElements());
            if (readFailed == 0) {
                double[] line_i = new double[words.size()];
                for (int i = 0; i < line_i.length; ++i) {
                    line_i[i] = (Double)words.get(i);
                }
                lines.add(line_i);
                continue;
            }
            ++linereadFailed;
        } while (linesTokenizer.hasMoreElements());
        if (linereadFailed != 0) {
            System.out.println("warning : " + linereadFailed + " lines ignored!");
        }
        double[][] array = new double[lines.size()][];
        lines.copyInto((Object[])array);
        return array;
    }

    public static int[][] readStringInt(String s) {
        return ArrayString.readStringInt(s, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static int[] readString1DInt(String s) {
        return ArrayString.readString1DInt(s, defaultWordDelimiter, defaultSentenceDelimiter);
    }

    public static int[] readString1DInt(String s, String wordDelimiter, String sentenceDelimiter) {
        int[][] d = ArrayString.readStringInt(s, wordDelimiter, sentenceDelimiter);
        int[] d1D = null;
        if (d.length > 1) {
            d1D = new int[d.length];
            for (int i = 0; i < d1D.length; ++i) {
                d1D[i] = d[i][0];
            }
        } else {
            d1D = d[0];
        }
        return d1D;
    }

    public static int[][] readStringInt(String s, String wordDelimiter, String sentenceDelimiter) {
        String delimiterString = wordDelimiter;
        String newlineString = sentenceDelimiter;
        StringTokenizer linesTokenizer = new StringTokenizer(s, newlineString);
        Vector<int[]> lines = new Vector<int[]>();
        int linereadFailed = 0;
        do {
            Vector<Integer> words = new Vector<Integer>();
            StringTokenizer wordsTokenizer = new StringTokenizer(linesTokenizer.nextToken(), delimiterString);
            int readFailed = 0;
            do {
                try {
                    words.addElement(Integer.valueOf(wordsTokenizer.nextToken()));
                }
                catch (NumberFormatException ex) {
                    ++readFailed;
                }
            } while (wordsTokenizer.hasMoreElements());
            if (readFailed == 0) {
                int[] line_i = new int[words.size()];
                for (int i = 0; i < line_i.length; ++i) {
                    line_i[i] = (Integer)words.get(i);
                }
                lines.add(line_i);
                continue;
            }
            ++linereadFailed;
        } while (linesTokenizer.hasMoreElements());
        if (linereadFailed != 0) {
            System.out.println("warning : " + linereadFailed + " lines ignored!");
        }
        int[][] array = new int[lines.size()][];
        lines.copyInto((Object[])array);
        return array;
    }
}

