/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

public class Vec {
    private static int dim = 3;

    public static void setDimension(int dimension) {
        dim = dimension;
    }

    public static double[] randomVector(double c) {
        double[] temp = new double[dim];
        for (int i = 0; i < dim; ++i) {
            temp[i] = c * (Math.random() - 0.5);
        }
        return temp;
    }

    public static double[] multiplay(double c, double[] a) {
        double[] temp = new double[dim];
        for (int i = 0; i < dim; ++i) {
            temp[i] = c * a[i];
        }
        return temp;
    }

    public static double[] add(double[] a, double[] b) {
        double[] temp = new double[dim];
        for (int i = 0; i < dim; ++i) {
            temp[i] = a[i] + b[i];
        }
        return temp;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] temp = new double[dim];
        for (int i = 0; i < dim; ++i) {
            temp[i] = a[i] - b[i];
        }
        return temp;
    }

    public static double dotProduct(double[] a, double[] b) {
        double temp = 0.0;
        for (int i = 0; i < dim; ++i) {
            temp += a[i] * b[i];
        }
        return temp;
    }

    public static double magnitude(double[] a) {
        return Math.sqrt(Vec.dotProduct(a, a));
    }

    public static double[] unitVector(double[] a) {
        double c = Vec.magnitude(a);
        if (c < 1.0E-15) {
            c = 1.0E-15;
        }
        c = 1.0 / c;
        a = Vec.multiplay(c, a);
        return a;
    }

    public static double[] reflect(double[] rVector, double[] draVector, int s) {
        double rq = Vec.dotProduct(rVector, rVector);
        if (rq < 1.0E-15) {
            rq = 1.0E-15;
        }
        double r = Math.sqrt(rq);
        double scalar = Vec.dotProduct(draVector, rVector);
        double radi = (rq / (double)(s * s) - 1.0) * (1.0 - scalar * scalar / rq);
        if (radi < 0.0) {
            radi = 0.0;
        }
        double x = -scalar / r + Math.sqrt(radi);
        double[] xVector = Vec.multiplay(x / r, rVector);
        double[] yVector = Vec.add(draVector, xVector);
        double[] drbVector = Vec.unitVector(yVector);
        return drbVector;
    }

    public static double[] drCharge(double[] rVector, double pull, int qa, int qb) {
        double[] c = Vec.unitVector(rVector);
        c = Vec.multiplay(pull * (double)qa * (double)qb * -1.0, c);
        return c;
    }
}

