/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;

public class PReader
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static BufferedReader readGZip(File sfile) {
        try {
            FileInputStream fin = new FileInputStream(sfile);
            GZIPInputStream gzis = new GZIPInputStream(fin);
            InputStreamReader xover = new InputStreamReader(gzis);
            BufferedReader is = new BufferedReader(xover);
            return is;
        }
        catch (FileNotFoundException e) {
            PReader.ErrorMessage(e.toString());
        }
        catch (IOException e) {
            PReader.ErrorMessage(e.toString());
        }
        return null;
    }

    public static BufferedReader read(URL url) {
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            return in;
        }
        catch (IOException e) {
            PReader.ErrorMessage(e.toString());
            return null;
        }
    }

    public static BufferedReader read(File sfile) {
        try {
            FileReader inF = new FileReader(sfile);
            BufferedReader br = new BufferedReader(inF);
            return br;
        }
        catch (FileNotFoundException e) {
            PReader.ErrorMessage(e.toString());
            return null;
        }
    }

    public static BufferedReader read(String sfile) {
        if ((sfile = sfile.trim()).startsWith("http:") || sfile.startsWith("ftp:") || sfile.startsWith("https:")) {
            try {
                return PReader.read(new URL(sfile));
            }
            catch (MalformedURLException e1) {
                PReader.ErrorMessage(e1.toString());
            }
        } else {
            return PReader.read(new File(sfile));
        }
        return null;
    }

    public static BufferedReader readGZip(URL url) {
        try {
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            GZIPInputStream gzis = new GZIPInputStream(urlConn.getInputStream());
            InputStreamReader xover = new InputStreamReader(gzis);
            return new BufferedReader(xover);
        }
        catch (IOException e) {
            e.toString();
            return null;
        }
    }

    public static BufferedReader readGZip(String sfile) {
        if ((sfile = sfile.trim()).startsWith("http") || sfile.startsWith("ftp")) {
            try {
                return PReader.readGZip(new URL(sfile));
            }
            catch (MalformedURLException e) {
                PReader.ErrorMessage(e.toString());
            }
        } else {
            return PReader.readGZip(new File(sfile));
        }
        return null;
    }

    private static void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

