/*
 * Decompiled with CFR 0.152.
 */
package jhplot.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhplot.gui.CommonGUI;
import kcl.waterloo.actions.ActionManager;
import kcl.waterloo.deploy.pde.PDEGraphics2D;
import kcl.waterloo.export.ExportFactory;
import kcl.waterloo.gui.file.FileUtil;
import kcl.waterloo.swing.FrameManager;
import kcl.waterloo.swing.GCFrameInterface;
import kcl.waterloo.swing.GCGridContainer;
import kcl.waterloo.swing.GCGridContainerInterface;
import kcl.waterloo.swing.GCTabbedGridContainer;

public class WPlotFrame
extends JFrame
implements GCFrameInterface,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private GCGridContainerInterface graphicsContainer = new GCGridContainer();

    public WPlotFrame() {
        this("");
        this.setContentPane((Container)this.graphicsContainer);
    }

    public WPlotFrame(String titleText) {
        int frameCount = FrameManager.getLowestAvailable();
        this.setTitle("Frame " + frameCount + ": " + titleText);
        this.setName("Frame" + frameCount);
        this.init(frameCount);
        this.setSize(500, 500);
        this.setBackground(Color.WHITE);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public WPlotFrame(String titleText, int xsize, int ysize, boolean isshown) {
        int frameCount = FrameManager.getLowestAvailable();
        this.setTitle("Frame " + frameCount + ": " + titleText);
        this.setName("Frame" + frameCount);
        this.init(frameCount);
        this.setSize(xsize, ysize);
        this.setBackground(Color.WHITE);
        this.setVisible(isshown);
        this.setDefaultCloseOperation(2);
    }

    private void init(int frameCount) {
        this.graphicsContainer = new GCGridContainer();
        this.setContentPane((Container)this.graphicsContainer);
        FrameManager.getList().put(Double.valueOf(frameCount), this);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem export = new JMenuItem("Export As");
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WPlotFrame.this.exportImage();
            }
        });
        menu.add(export);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WPlotFrame.this.setVisible(false);
                WPlotFrame.this.dispose();
            }
        });
        menu.add(exit);
        this.setJMenuBar(menuBar);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener((WindowListener)FrameManager.getInstance());
    }

    public GCGridContainerInterface getGraphicsContainer() {
        return this.graphicsContainer;
    }

    public final void setGraphicsContainer(GCGridContainerInterface c) {
        this.setContentPane((Container)c);
        this.graphicsContainer = c;
    }

    @Override
    public Component add(Component c) {
        return this.add(c, 0.0, 0.0, 0);
    }

    public final Component add(Component c, double row, double column, int tab) throws UnsupportedOperationException {
        return this.add(c, row, column, 1.0, 1.0, tab);
    }

    public final Component add(Component c, double row, double column, double width, double height, int tab) throws UnsupportedOperationException {
        GCGridContainerInterface contents = this.getGraphicsContainer();
        if (contents instanceof GCTabbedGridContainer) {
            GCGridContainerInterface thisTab = (GCGridContainerInterface)contents.getComponentAt(tab);
            return thisTab.add(c, row, column, width, height);
        }
        if (contents instanceof GCGridContainer && tab == 0) {
            return contents.add(c, row, column, width, height);
        }
        return null;
    }

    public void makeTabbed(String title) {
        if (this.getGraphicsContainer() instanceof GCGridContainer) {
            Component contents = (Component)this.getGraphicsContainer();
            GCTabbedGridContainer tabbedPanel = new GCTabbedGridContainer();
            tabbedPanel.addChangeListener(this);
            this.setContentPane((Container)tabbedPanel);
            this.setGraphicsContainer((GCGridContainerInterface)tabbedPanel);
            tabbedPanel.insertTab(title, null, contents, "", 0);
        }
    }

    public Component addTab(String s, Component c) throws UnsupportedOperationException {
        if (this.graphicsContainer instanceof JTabbedPane) {
            ((JTabbedPane)this.getGraphicsContainer()).addTab(s, c);
            return c;
        }
        return null;
    }

    public void actionPerformed(ActionEvent ae) {
        this.toFront();
        ActionManager.processAction((ActionEvent)ae, (Component)((Component)this.getGraphicsContainer()));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
    }

    protected void exportImage() {
        JFileChooser fileChooser = CommonGUI.openImageFileChooser(this);
        if (fileChooser.showDialog(this, "Save As") == 0) {
            int res;
            final File scriptFile = fileChooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            Thread t = new Thread("saving image"){

                @Override
                public void run() {
                    WPlotFrame.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    public void export(String f) {
        GCGridContainer graphContainer = (GCGridContainer)this.graphicsContainer;
        if (graphContainer == null) {
            return;
        }
        File file = null;
        try {
            file = new File(f);
            String ext = FileUtil.getExtension((File)file);
            if (ext.equalsIgnoreCase("pdf")) {
                ExportFactory.saveAsPDF((Component)graphContainer, (File)file);
            } else if (ext.equalsIgnoreCase("eps")) {
                ExportFactory.saveAsEPS((Component)graphContainer, (File)file);
            } else if (ext.equalsIgnoreCase("svg")) {
                ExportFactory.saveAsSVG((Component)graphContainer, (File)file);
            } else if (ext.equalsIgnoreCase("gz")) {
                ExportFactory.saveAsCompressedSVG((Component)graphContainer, (File)file);
            } else if (ext.equalsIgnoreCase("pde")) {
                PDEGraphics2D g2 = new PDEGraphics2D((Graphics2D)graphContainer.getGraphics(), graphContainer.getSize());
                graphContainer.paint((Graphics)g2);
                g2.write(file.getPath(), false, "");
            } else {
                BufferedImage buffer = graphContainer.getGraphicsConfiguration().createCompatibleImage(graphContainer.getWidth(), graphContainer.getHeight());
                Graphics2D g2 = (Graphics2D)buffer.getGraphics();
                graphContainer.paint((Graphics)g2);
                if (ext.isEmpty()) {
                    ext = "png";
                    file = new File(file.getPath().concat(".png"));
                }
                ImageIO.write((RenderedImage)buffer, ext, file);
            }
        }
        catch (IOException ex) {
            System.out.println(String.format("IOException saving file: %s", file.getPath()));
        }
    }
}

