/*
 * Decompiled with CFR 0.152.
 */
package jhplot.fit;

import hep.aida.ref.function.AbstractIFunction;
import jhplot.math.num.pdf.SaddlePoint;

public class NegativeBinomial
extends AbstractIFunction {
    public NegativeBinomial() {
        this("NegativeBinomial");
    }

    public NegativeBinomial(String title) {
        super(title, 1, 3);
    }

    public NegativeBinomial(String[] variableNames, String[] parameterNames) {
        super(variableNames, parameterNames);
    }

    public double value(double[] v) {
        double ret;
        int numberOfSuccesses = (int)this.p[1];
        double probabilityOfSuccess = this.p[2];
        int x = (int)v[0];
        if (x < 0) {
            ret = 0.0;
        } else {
            ret = Math.exp(SaddlePoint.logBinomialProbability(numberOfSuccesses, x + numberOfSuccesses, probabilityOfSuccess, 1.0 - probabilityOfSuccess));
            ret = (double)numberOfSuccesses * ret / (double)(x + numberOfSuccesses);
        }
        return this.p[0] * ret;
    }

    protected void init(String title) {
        this.parameterNames[0] = "norm";
        this.parameterNames[1] = "numbertrials";
        this.parameterNames[2] = "probsuccess";
        super.init(title);
    }
}

