/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import jhplot.bsom.Matrix;

class Visible2DPointArray
extends Matrix {
    int radius;
    double scale;
    int dxo;
    int dyo;
    private int diameter;
    final double xo = 0.0;
    final double yo = 0.0;

    public Visible2DPointArray(int n, double scale, int radius, int x, int y) {
        super(n, 2);
        this.radius = radius;
        this.scale = scale;
        radius = 2;
        this.diameter = radius > 0 ? radius * 2 : 1;
        this.dxo = x;
        this.dyo = y;
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.row; ++i) {
            int x = (int)(this.scale * (this.value[i][0] - 0.0)) + this.dxo - this.radius;
            int y = (int)(-this.scale * (this.value[i][1] - 0.0)) + this.dyo - this.radius;
            Graphics2D g2 = (Graphics2D)g;
            g2.draw(new Ellipse2D.Float(x, y, this.diameter, this.diameter));
            g2.fill(new Ellipse2D.Float(x, y, this.diameter, this.diameter));
        }
    }

    public void drawCurve(Graphics g) {
        int xp = (int)(this.scale * (this.value[0][0] - 0.0)) + this.dxo;
        int yp = (int)(-this.scale * (this.value[0][1] - 0.0)) + this.dyo;
        for (int i = 1; i < this.row; ++i) {
            int x = (int)(this.scale * (this.value[i][0] - 0.0)) + this.dxo;
            int y = (int)(-this.scale * (this.value[i][1] - 0.0)) + this.dyo;
            g.drawLine(xp, yp, x, y);
            xp = x;
            yp = y;
        }
    }

    int index(int x, int y) {
        for (int i = 0; i < this.row; ++i) {
            if (Math.abs(x - (int)(this.scale * (this.value[i][0] - 0.0)) - this.dxo) > this.radius || Math.abs(y - (int)(-this.scale * (this.value[i][1] - 0.0)) - this.dyo) > this.radius) continue;
            return i;
        }
        return -1;
    }

    void move(int id, int ix, int iy) {
        this.value[id][0] = (double)(ix - this.dxo) / this.scale + 0.0;
        this.value[id][1] = (double)(-(iy - this.dyo)) / this.scale + 0.0;
    }
}

