/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhplot.bsom.DrawArea;

class HpSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    static final double LOG10 = Math.log(10.0);
    protected DrawArea drawArea;
    protected double min_power;
    protected double max_power;
    protected boolean stored_mode;
    protected boolean dragged = false;
    private int value;
    private double range;

    HpSlider(DrawArea p, double min_power, double max_power) {
        this.setMajorTickSpacing(20);
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(20), new JLabel("1"));
        labelTable.put(new Integer(40), new JLabel("2"));
        labelTable.put(new Integer(60), new JLabel("3"));
        labelTable.put(new Integer(80), new JLabel("4"));
        labelTable.put(new Integer(100), new JLabel("5"));
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
        this.drawArea = p;
        this.min_power = min_power;
        this.max_power = max_power;
        this.range = max_power - min_power;
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                if (!slider.getValueIsAdjusting()) {
                    HpSlider.this.value = slider.getValue();
                    HpSlider.this.stored_mode = HpSlider.this.drawArea.auto_learn;
                    HpSlider.this.drawArea.auto_learn = false;
                    HpSlider.this.dragged = true;
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                HpSlider.this.stored_mode = HpSlider.this.drawArea.auto_learn;
                HpSlider.this.drawArea.auto_learn = false;
                HpSlider.this.dragged = true;
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                HpSlider.this.value = HpSlider.this.getValue();
                HpSlider.this.drawArea.auto_learn = HpSlider.this.stored_mode;
                HpSlider.this.dragged = false;
                HpSlider.this.setValueBySlider();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
    }

    public void Motion() {
        if (!this.dragged) {
            this.stored_mode = this.drawArea.auto_learn;
            this.drawArea.auto_learn = false;
        }
        this.dragged = true;
        this.setValueBySlider();
    }

    public void Release() {
        this.setValueBySlider();
        this.drawArea.auto_learn = this.stored_mode;
        this.dragged = false;
    }

    public void setValueBySlider() {
    }

    double getValueFromSlider() {
        double power = (double)this.value / 100.0 * this.range + this.min_power;
        double v = Math.pow(10.0, power);
        return v;
    }

    public double setValueOfSlider(double x) {
        int v = (int)((Math.log(x) / LOG10 - this.min_power) / this.range * 100.0);
        if (v < 1) {
            v = 1;
            x = Math.pow(10.0, 0.01 * this.range + this.min_power);
        } else if (v > 100) {
            v = 100;
            x = Math.pow(10.0, 1.0 * this.range + this.min_power);
        }
        this.setValue(v);
        return x;
    }
}

