/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.gui.WPlotFrame;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.GJGraph;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.plots2D.BarExtra;
import kcl.waterloo.graphics.plots2D.GJBar;
import kcl.waterloo.graphics.plots2D.GJContour;
import kcl.waterloo.graphics.plots2D.GJErrorBar;
import kcl.waterloo.graphics.plots2D.GJLine;
import kcl.waterloo.graphics.plots2D.GJPie;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJPolarBar;
import kcl.waterloo.graphics.plots2D.GJPolarLine;
import kcl.waterloo.graphics.plots2D.GJPolarScatter;
import kcl.waterloo.graphics.plots2D.GJPolarStem;
import kcl.waterloo.graphics.plots2D.GJScatter;
import kcl.waterloo.graphics.plots2D.contour.ContourExtra;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.plotmodel2D.GJCyclicArrayList;

public class WPlot {
    private boolean isSetRange = false;
    private WPlotFrame frame;
    private GJGraphContainer graphContainer;
    private GJGraph graph;
    private GJPlotInterface pjplot;
    private boolean antialiasing = true;
    private Rectangle2D range = new Rectangle2D.Double(0.0, 1.0, 0.0, 1.0);

    public WPlot() {
        this("WPlot", 600, 400);
    }

    public WPlot(String title) {
        this(title, 600, 400);
    }

    public WPlot(int width, int height) {
        this("WPlot", width, height);
    }

    public WPlot(String title, int width, int height) {
        this.frame = new WPlotFrame(title, width, height, false);
        this.graph = GJGraph.createInstance();
        this.graphContainer = GJGraphContainer.createInstance((GJAbstractGraph)this.graph);
        this.frame.add((Component)this.graphContainer);
        this.range = new Rectangle2D.Double(0.0, 1.0, 0.0, 1.0);
        this.isSetRange = false;
        this.graphContainer.setFont(new Font("Arial", 1, 14));
        int lsize = 16;
        GJAxisPanel left = this.graph.getLeftAxisPanel();
        left.setLabelFont(new Font("Arial", 1, lsize));
        GJAxisPanel right = this.graph.getRightAxisPanel();
        right.setLabelFont(new Font("Arial", 1, lsize));
        GJAxisPanel top = this.graph.getTopAxisPanel();
        top.setLabelFont(new Font("Arial", 1, lsize));
        GJAxisPanel botton = this.graph.getBottomAxisPanel();
        botton.setLabelFont(new Font("Arial", 1, lsize));
    }

    public void setAntiAlias(boolean setit) {
        this.antialiasing = setit;
    }

    public boolean getAntiAlias() {
        return this.antialiasing;
    }

    public void setFontAxis(Font f) {
        this.graphContainer.setFont(f);
    }

    public void setBackground(Color c) {
        this.frame.setBackground(c);
    }

    public void setGTitle(String title) {
        this.graphContainer.setTitleText(title);
    }

    public void addLegend(int dataset, String legend) {
    }

    public synchronized void addXTick(String label, double position) {
    }

    public synchronized void clear() {
    }

    public synchronized void clearLegends() {
    }

    public void setForeground(Color foreground) {
        this.frame.setForeground(foreground);
    }

    public void setLabelFont(Font name) {
        GJAxisPanel left = this.graph.getLeftAxisPanel();
        left.setLabelFont(name);
        GJAxisPanel right = this.graph.getRightAxisPanel();
        right.setLabelFont(name);
        GJAxisPanel top = this.graph.getTopAxisPanel();
        top.setLabelFont(name);
        GJAxisPanel button = this.graph.getBottomAxisPanel();
        button.setLabelFont(name);
    }

    public void setTitleFont(String name) {
    }

    public void setNameX(String label) {
        this.graph.setXLabel(label);
    }

    public void setXLog(boolean xlog) {
    }

    public void setRange(double minX, double maxX, double minY, double maxY) {
        this.setAutoRange(false);
        this.range = new Rectangle2D.Double(minX, minY, maxX, maxY);
    }

    public void setRange(int axis, double min, double max) {
        this.setAutoRange(false);
        Rectangle2D rc = this.graph.getDataRange();
        if (axis == 0) {
            this.range = new Rectangle2D.Double(min, rc.getY(), max, rc.getHeight());
        }
        if (axis == 1) {
            this.range = new Rectangle2D.Double(rc.getX(), min, rc.getWidth(), max);
        }
    }

    public void setNameY(String label) {
        this.graph.setYLabel(label);
    }

    public void setName(String label) {
        this.graphContainer.setSubTitleText(label);
    }

    public void setYLog(boolean ylog) {
    }

    public void setYRange(double min, double max) {
        this.setRange(1, min, max);
    }

    public void draw(double[] x, double[] y) {
        this.draw(x, y, "none");
    }

    public void clear(int dataset) {
    }

    public void setAutoRange() {
        this.isSetRange = false;
        this.graph.autoScale();
    }

    public void setAutoRange(boolean auto) {
        if (auto) {
            this.isSetRange = false;
            this.graph.autoScale();
        }
        if (!auto) {
            this.isSetRange = true;
        }
    }

    public void update() {
        this.frame.validate();
        this.frame.repaint();
    }

    public void setGrid(boolean b) {
        if (b) {
            this.graph.paintGrid();
        }
    }

    public void draw(H1D h1) {
        double binwidth = h1.getBinSize();
        IAxis axis = h1.get().axis();
        double[] xx = new double[axis.bins()];
        double[] yy = new double[axis.bins()];
        double[] ye = new double[axis.bins()];
        double[] xcenter = new double[axis.bins()];
        for (int i = 0; i < axis.bins(); ++i) {
            double x = h1.binLowerEdge(i);
            double y = h1.binHeight(i);
            double y1 = h1.binError(i);
            double y2 = h1.binError(i);
            xx[i] = x;
            yy[i] = y;
            ye[i] = y1;
            xcenter[i] = h1.binCenter(i);
        }
        this.pjplot = GJBar.createInstance();
        if (h1.isFilled()) {
            this.pjplot.setFill((Object)h1.getFillColor());
        } else {
            new Color(0);
            this.pjplot.setFill((Object)Color.white);
        }
        this.pjplot.setXData(xx);
        this.pjplot.setYData(yy);
        String styleLine = "-";
        float width = h1.getPenWidth();
        this.pjplot.setLineColor((Object)h1.getColor());
        this.pjplot.setLineStroke((Object)GJUtilities.makeStroke((float)width, (String)styleLine));
        ((BarExtra)this.pjplot.getDataModel().getExtraObject()).setMode(BarExtra.MODE.HISTC);
        this.graph.add(this.pjplot);
        if (h1.isErrY() || h1.isErrX()) {
            this.pjplot = GJErrorBar.createInstance();
            this.pjplot.setXData(xcenter);
            this.pjplot.setYData(yy);
            this.pjplot.setExtraData1(ye);
            this.pjplot.setExtraData3(ye);
            this.graph.add(this.pjplot);
        }
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void draw(P0D p0d) {
        this.pjplot = GJPie.createInstance();
        this.pjplot.setXData(p0d.getArray());
        this.graph.add(this.pjplot);
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void draw(P0I p0d) {
        this.pjplot = GJPie.createInstance();
        this.pjplot.setXData(p0d.getArray());
        this.graph.add(this.pjplot);
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void draw(P1D p1d) {
        if (p1d.isBars()) {
            this.draw(p1d, "Bar");
        } else if (p1d.getLineParm().drawLine()) {
            this.draw(p1d, "Line");
        } else {
            this.draw(p1d, "none");
        }
    }

    public void draw(double[] x, double[] y, String opt) {
        this.pjplot = (opt = opt.trim()).equalsIgnoreCase("PolarBar") ? GJPolarBar.createInstance() : (opt.equalsIgnoreCase("PolarLine") ? GJPolarLine.createInstance() : (opt.equalsIgnoreCase("PolarScatter") ? GJPolarScatter.createInstance() : (opt.equalsIgnoreCase("PolarStem") ? GJPolarStem.createInstance() : (opt.equalsIgnoreCase("Bar") ? GJBar.createInstance() : (opt.equalsIgnoreCase("Line") ? GJLine.createInstance() : GJScatter.createInstance())))));
        this.pjplot.setXData(x);
        this.pjplot.setYData(y);
        this.graph.add(this.pjplot);
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void draw(F1D f1d, String opt) {
        this.pjplot = (opt = opt.trim()).equalsIgnoreCase("PolarBar") ? GJPolarBar.createInstance() : (opt.equalsIgnoreCase("PolarLine") ? GJPolarLine.createInstance() : (opt.equalsIgnoreCase("PolarScatter") ? GJPolarScatter.createInstance() : (opt.equalsIgnoreCase("PolarStem") ? GJPolarStem.createInstance() : (opt.equalsIgnoreCase("Bar") ? GJBar.createInstance() : (opt.equalsIgnoreCase("Scatter") ? GJScatter.createInstance() : GJLine.createInstance())))));
        Rectangle2D rc = this.graph.getDataRange();
        if (f1d.getMin() == f1d.getMax()) {
            double min = rc.getMinX();
            double max = rc.getMaxX();
            f1d.eval(min, max, f1d.getPoints());
        } else {
            f1d.eval(f1d.getMin(), f1d.getMax(), f1d.getPoints());
        }
        this.pjplot.setXData(f1d.getArrayX());
        this.pjplot.setYData(f1d.getArrayY());
        String styleLine = "-";
        float width = f1d.getPenWidth();
        this.pjplot.setLineColor((Object)f1d.getColor());
        this.pjplot.setLineStroke((Object)GJUtilities.makeStroke((float)width, (String)styleLine));
        this.graph.add(this.pjplot);
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void draw(F1D f1d) {
        this.draw(f1d, "none");
    }

    public void draw(P1D p1d, String opt) {
        opt = opt.trim();
        boolean sc = false;
        if (p1d.getDimension() == 2) {
            if (opt.equalsIgnoreCase("PolarBar")) {
                this.pjplot = GJPolarBar.createInstance();
            } else if (opt.equalsIgnoreCase("PolarLine")) {
                this.pjplot = GJPolarLine.createInstance();
            } else if (opt.equalsIgnoreCase("PolarScatter")) {
                this.pjplot = GJPolarScatter.createInstance();
            } else if (opt.equalsIgnoreCase("PolarStem")) {
                this.pjplot = GJPolarStem.createInstance();
            } else if (opt.equalsIgnoreCase("Bar")) {
                this.pjplot = GJBar.createInstance();
            } else if (opt.equalsIgnoreCase("Line")) {
                this.pjplot = GJLine.createInstance();
            } else {
                sc = true;
                this.pjplot = GJScatter.createInstance();
            }
            this.pjplot.setXData(p1d.getArrayX());
            this.pjplot.setYData(p1d.getArrayY());
        } else if (p1d.getDimension() == 3) {
            if (opt.equalsIgnoreCase("PolarBar")) {
                this.pjplot = GJPolarBar.createInstance();
            } else if (opt.equalsIgnoreCase("PolarLine")) {
                this.pjplot = GJPolarLine.createInstance();
            } else if (opt.equalsIgnoreCase("PolarScatter")) {
                this.pjplot = GJPolarScatter.createInstance();
            } else if (opt.equalsIgnoreCase("PolarStem")) {
                this.pjplot = GJPolarStem.createInstance();
            } else if (opt.equalsIgnoreCase("Bar")) {
                this.pjplot = GJBar.createInstance();
            } else if (opt.equalsIgnoreCase("Line")) {
                this.pjplot = GJLine.createInstance();
            } else {
                sc = true;
                this.pjplot = GJErrorBar.createInstance();
            }
            this.pjplot.setXData(p1d.getArrayX());
            this.pjplot.setYData(p1d.getArrayY());
            this.pjplot.setExtraData1(p1d.getArrayYupper());
            this.pjplot.setExtraData3(p1d.getArrayYupper());
        } else if (p1d.getDimension() == 4) {
            if (opt.equalsIgnoreCase("PolarBar")) {
                this.pjplot = GJPolarBar.createInstance();
            } else if (opt.equalsIgnoreCase("PolarLine")) {
                this.pjplot = GJPolarLine.createInstance();
            } else if (opt.equalsIgnoreCase("PolarScatter")) {
                this.pjplot = GJPolarScatter.createInstance();
            } else if (opt.equalsIgnoreCase("PolarStem")) {
                this.pjplot = GJPolarStem.createInstance();
            } else if (opt.equalsIgnoreCase("Bar")) {
                this.pjplot = GJBar.createInstance();
            } else if (opt.equalsIgnoreCase("Line")) {
                this.pjplot = GJLine.createInstance();
            } else {
                sc = true;
                this.pjplot = GJErrorBar.createInstance();
            }
            this.pjplot.setXData(p1d.getArrayX());
            this.pjplot.setYData(p1d.getArrayY());
            this.pjplot.setExtraData1(p1d.getArrayYupper());
            this.pjplot.setExtraData3(p1d.getArrayYlower());
        } else {
            if (opt.equalsIgnoreCase("PolarBar")) {
                this.pjplot = GJPolarBar.createInstance();
            } else if (opt.equalsIgnoreCase("PolarLine")) {
                this.pjplot = GJPolarLine.createInstance();
            } else if (opt.equalsIgnoreCase("PolarScatter")) {
                this.pjplot = GJPolarScatter.createInstance();
            } else if (opt.equalsIgnoreCase("PolarStem")) {
                this.pjplot = GJPolarStem.createInstance();
            } else if (opt.equalsIgnoreCase("Bar")) {
                this.pjplot = GJBar.createInstance();
            } else if (opt.equalsIgnoreCase("Line")) {
                this.pjplot = GJLine.createInstance();
            } else {
                sc = true;
                this.pjplot = GJErrorBar.createInstance();
            }
            this.pjplot.setXData(p1d.getArrayX());
            this.pjplot.setYData(p1d.getArrayY());
            this.pjplot.setExtraData1(p1d.getArrayYupper());
            this.pjplot.setExtraData3(p1d.getArrayYlower());
            this.pjplot.setExtraData2(p1d.getArrayXleft());
            this.pjplot.setExtraData0(p1d.getArrayXright());
        }
        this.pjplot.setEdgeColor((Object)p1d.getColor());
        this.pjplot.setFill((Object)p1d.getColor());
        this.pjplot.setLineColor((Object)p1d.getColor());
        String symbol = (String)GJDefaults.getMap().get("GJAbstractPlot.markerSymbol");
        symbol = p1d.getSymbolShape();
        double markerSize = p1d.getSymbolSize();
        this.pjplot.getVisualModel().setMarkerArray(new GJCyclicArrayList((Object)GJMarker.getMarker((String)symbol, (double)markerSize)));
        this.pjplot.getVisualModel().setDynamicMarkerSize(new GJCyclicArrayList());
        if (p1d.getDimension() > 2) {
            if (p1d.isErrX() && p1d.isErrY()) {
                this.graph.add(this.pjplot);
            }
        } else {
            this.graph.add(this.pjplot);
        }
        if (sc && p1d.getDimension() > 2) {
            this.pjplot = GJScatter.createInstance();
            this.pjplot.setXData(p1d.getArrayX());
            this.pjplot.setYData(p1d.getArrayY());
            this.pjplot.setEdgeColor((Object)p1d.getColor());
            this.pjplot.setFill((Object)p1d.getColor());
            this.pjplot.setLineColor((Object)p1d.getColor());
            symbol = p1d.getSymbolShape();
            markerSize = p1d.getSymbolSize();
            this.pjplot.getVisualModel().setMarkerArray(new GJCyclicArrayList((Object)GJMarker.getMarker((String)symbol, (double)markerSize)));
            this.pjplot.getVisualModel().setDynamicMarkerSize(new GJCyclicArrayList());
            this.graph.add(this.pjplot);
        }
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public WPlotFrame getFrame() {
        return this.frame;
    }

    public GJPlotInterface getPlotInterface() {
        return this.pjplot;
    }

    public GJGraph getGraph() {
        return this.graph;
    }

    public GJGraphContainer getContainer() {
        return this.graphContainer;
    }

    public void visible(boolean showIt) {
        if (showIt) {
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(false);
        }
    }

    public void visible() {
        this.frame.setVisible(true);
    }

    public void drawContour(P1D p1d) {
        this.pjplot = GJContour.createInstance();
        ContourExtra contourObject = ContourExtra.createInstance();
        this.pjplot.setXData(p1d.getArrayX());
        this.pjplot.setYData(p1d.getArrayY());
        this.pjplot.setExtraData0(p1d.getArrayY());
        contourObject.generateContours((GJContour)this.pjplot);
        contourObject.setNegativeLineColor((Paint)Color.BLUE.darker());
        contourObject.setPositiveLineColor((Paint)Color.ORANGE.darker());
        contourObject.setZeroStroke(new BasicStroke(2.0f));
        ((GJContour)this.pjplot).getDataModel().setExtraObject((Object)contourObject);
        ((GJContour)this.pjplot).setLabelled(true);
        this.graph.add(this.pjplot);
        if (this.isSetRange) {
            this.graph.setAxesBounds(this.range);
        }
        if (this.antialiasing) {
            this.graph.setAntialiasing(true);
        } else {
            this.graph.setAntialiasing(false);
        }
        this.update();
    }

    public void export(String f) {
        this.frame.export(f);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            // empty if block
        }
    }
}

