/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jhplot.gui.HelpBrowser;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;

public class IViewSVG {
    protected JButton button = new JButton("Load...");
    protected JLabel label = new JLabel();
    protected JSVGCanvas svgCanvas = new JSVGCanvas();

    public IViewSVG(String sfile) {
        this.showImage(sfile);
    }

    public IViewSVG() {
        this.showImage(null);
    }

    private void showImage(String sfile) {
        JFrame f = new JFrame("IViewSVG");
        f.getContentPane().add(this.createComponents());
        f.setDefaultCloseOperation(2);
        f.setSize(600, 400);
        f.setVisible(true);
        this.load(sfile);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void load(String sfile) {
        if (sfile != null) {
            String extension = "";
            int i = sfile.lastIndexOf(46);
            if (i >= 0) {
                extension = sfile.substring(i + 1);
            }
            if (extension.equalsIgnoreCase("svg")) {
                try {
                    System.out.println("Open file=" + sfile);
                    File ff = new File(sfile);
                    this.svgCanvas.setURI(ff.toURL().toString());
                }
                catch (Exception fileEx) {
                    System.out.println(fileEx.toString());
                }
            } else {
                System.err.println("Not SVG file!");
            }
        }
    }

    private JComponent createComponents() {
        final JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(this.button);
        p.add(this.label);
        panel.add("North", p);
        panel.add("Center", (Component)this.svgCanvas);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = new JFileChooser(".");
                int choice = fc.showOpenDialog(panel);
                if (choice == 0) {
                    File f = fc.getSelectedFile();
                    try {
                        IViewSVG.this.svgCanvas.setURI(f.toURL().toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                IViewSVG.this.label.setText("Document Loading...");
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                IViewSVG.this.label.setText("Document Loaded.");
            }
        });
        this.svgCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                IViewSVG.this.label.setText("Build Started...");
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                IViewSVG.this.label.setText("Build Done.");
            }
        });
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                IViewSVG.this.label.setText("Rendering Started...");
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                IViewSVG.this.label.setText("");
            }
        });
        return panel;
    }
}

