/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.P3D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.VHolder;
import jhplot.gui.HelpBrowser;
import jminhep.cluster.DataHolder;

public class HTable
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton filter;
    private JPanel control;
    private DefaultTableModel model;
    private JTable jTable;
    private TableRowSorter<TableModel> rowSorter;
    private JTextField jtfFilter;
    private JButton jbtFilter;

    public HTable(String explanation, String[] colNames, Double[][] fillnames) {
        this.buildTable(explanation, colNames, fillnames);
    }

    public HTable() {
    }

    public HTable(double[] a) {
        VHolder vh = new VHolder();
        vh.setData(a);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(double[][] a) {
        VHolder vh = new VHolder();
        vh.setData(a);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(H1D histogram) {
        VHolder vh = new VHolder(histogram);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(H1D histogram) {
        VHolder vh = new VHolder(histogram);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(F1D function) {
        VHolder vh = new VHolder(function);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(P0I data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(P0D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(PND data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(PNI data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(P1D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(P2D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(P2D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(P3D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public void show(P3D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(F1D function) {
        VHolder vh = new VHolder(function);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(DataHolder dh) {
        VHolder vh = new VHolder(dh);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(P1D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    public HTable(P0D data) {
        VHolder vh = new VHolder(data);
        this.buildTable(vh.getTitle(), vh.getNames(), vh.getData());
    }

    private void buildTable(String explanation, String[] colNames, Double[][] fillnames) {
        this.setTitle(explanation);
        this.model = new DefaultTableModel(fillnames, colNames);
        this.jTable = new JTable(this.model);
        this.rowSorter = new TableRowSorter<TableModel>(this.jTable.getModel());
        this.jtfFilter = new JTextField();
        this.jbtFilter = new JButton("Filter");
        this.jTable.setRowSorter(this.rowSorter);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Word to match:"), "West");
        panel.add((Component)this.jtfFilter, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        this.add((Component)new JScrollPane(this.jTable), "Center");
        this.jtfFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = HTable.this.jtfFilter.getText();
                if (text.trim().length() == 0) {
                    HTable.this.rowSorter.setRowFilter(null);
                } else {
                    HTable.this.rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = HTable.this.jtfFilter.getText();
                if (text.trim().length() == 0) {
                    HTable.this.rowSorter.setRowFilter(null);
                } else {
                    HTable.this.rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(explanation);
        this.setSize(400, 500);
        this.setLocation(200, 200);
        this.setVisible(true);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

