/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Profile2D;
import hep.aida.ref.histogram.VariableAxis;
import java.io.Serializable;
import jhplot.H2D;
import jhplot.gui.HelpBrowser;

public class HProf2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Profile2D h1;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private int binsX;
    private int binsY;
    private IAxis xAx;
    private IAxis yAy;
    private int region = 0;
    private String title;

    public HProf2D(String title, int binsX, double minX, double maxX, int binsY, double minY, double maxY) {
        this.title = title;
        this.binsX = binsX;
        this.minX = minX;
        this.maxX = maxX;
        this.binsY = binsY;
        this.minY = minY;
        this.maxY = maxY;
        this.xAx = new FixedAxis(this.binsX, this.minX, this.maxX);
        this.yAy = new FixedAxis(this.binsY, this.minY, this.maxY);
        this.h1 = new Profile2D(this.title, this.title, this.xAx, this.yAy);
    }

    public HProf2D(String title, double[] edgesX, double[] edgesY) {
        this.title = title;
        this.binsX = edgesX.length - 1;
        this.minX = edgesX[0];
        this.maxX = edgesX[edgesX.length - 1];
        this.binsY = edgesY.length - 1;
        this.minY = edgesY[0];
        this.maxY = edgesX[edgesY.length - 1];
        this.xAx = new VariableAxis(edgesX);
        this.yAy = new VariableAxis(edgesY);
        this.h1 = new Profile2D(this.title, this.title, this.xAx, this.yAy);
    }

    public HProf2D(Profile2D h1) {
        this.h1 = h1;
        this.setTitle(h1.title());
        this.xAx = h1.xAxis();
        this.yAy = h1.yAxis();
        this.minX = this.xAx.lowerEdge();
        this.maxX = this.xAx.upperEdge();
        this.minY = this.yAy.lowerEdge();
        this.maxY = this.yAy.upperEdge();
        this.binsX = this.xAx.bins();
        this.binsY = this.yAy.bins();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Profile2D get() {
        return this.h1;
    }

    public H2D getH2D(String newtitle) {
        return this.getH2D(newtitle, "mean");
    }

    public H2D getH2D(String newtitle, String option) {
        int xbins = this.xAx.bins() + 2;
        int ybins = this.yAy.bins() + 2;
        double[][] newHeights = new double[xbins][ybins];
        double[][] newErrors = new double[xbins][ybins];
        double[][] newMeanXs = new double[xbins][ybins];
        double[][] newRmsXs = new double[xbins][ybins];
        double[][] newMeanYs = new double[xbins][ybins];
        double[][] newRmsYs = new double[xbins][ybins];
        int[][] newEntries = new int[xbins][ybins];
        for (int i = 0; i < xbins - 1; ++i) {
            for (int j = 0; j < ybins - 1; ++j) {
                int binx = i + 1;
                int biny = j + 1;
                newHeights[binx][biny] = this.h1.binHeight(i, j);
                newErrors[binx][biny] = this.h1.binError(i, j);
                if (option == "s" || option == "S") {
                    newErrors[binx][biny] = this.h1.binRms(i, j);
                }
                newEntries[binx][biny] = this.h1.binEntries(i, j);
                newMeanXs[binx][biny] = this.h1.binMeanX(i, j);
                newMeanYs[binx][biny] = this.h1.binMeanY(i, j);
                newRmsXs[binx][biny] = this.h1.binRms(i, j);
                newRmsYs[binx][biny] = this.h1.binRms(i, j);
            }
        }
        H2D hnew = new H2D(newtitle, this.xAx, this.yAy);
        hnew.setContents(newHeights, newErrors, newEntries, newMeanXs, newRmsXs, newMeanYs, newRmsYs);
        hnew.setMeanX(this.h1.meanX());
        hnew.setMeanY(this.h1.meanY());
        hnew.setRmsX(this.h1.rmsX());
        hnew.setRmsY(this.h1.rmsY());
        hnew.setNEntries(this.entries());
        return hnew;
    }

    public H2D getH2D() {
        return this.getH2D(this.title);
    }

    public void setRmsY(double rmsY) {
        this.h1.setRmsY(rmsY);
    }

    public void setMeanY(double mean) {
        this.h1.setMeanY(mean);
    }

    public double getRmsY() {
        return this.h1.rmsY();
    }

    public double getMeanY() {
        return this.h1.meanY();
    }

    public double getMeanX() {
        return this.h1.meanX();
    }

    public double getRmsX() {
        return this.h1.rmsX();
    }

    public void setNEntries(int entries) {
        this.h1.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.h1.setValidEntries(entries);
    }

    public void setRmsX(double rmsX) {
        this.h1.setRmsX(rmsX);
    }

    public void setMeanX(double mean) {
        this.h1.setMeanX(mean);
    }

    public void setContents(double[][] heights, double[][] errors) {
        this.h1.setContents(heights, errors, (int[][])null, (double[][])null, (double[][])null, (double[][])null);
    }

    public void fill(double x, double y, double z) {
        this.h1.fill(x, y, z);
    }

    public void fill(double x, double y, double z, double w) {
        this.h1.fill(x, y, z, w);
    }

    public double binHeight(int indexX, int indexY) {
        return this.h1.binHeight(indexX, indexY);
    }

    public int extraEntries() {
        return this.h1.extraEntries();
    }

    public double sumExtraBinHeights() {
        return this.h1.sumExtraBinHeights();
    }

    public double sumAllBinHeights() {
        return this.h1.sumAllBinHeights();
    }

    public int getBinsX() {
        return this.h1.xAxis().bins();
    }

    public int getBinsY() {
        return this.h1.yAxis().bins();
    }

    public double getMinX() {
        return this.h1.xAxis().lowerEdge();
    }

    public double getMaxX() {
        return this.h1.xAxis().upperEdge();
    }

    public double getMaxY() {
        return this.h1.yAxis().upperEdge();
    }

    public double getMinY() {
        return this.h1.yAxis().lowerEdge();
    }

    public int getUnderflowEntriesY() {
        return this.h1.binEntriesY(-2);
    }

    public double getUnderflowHeightY() {
        return this.h1.binHeightY(-2);
    }

    public double getUnderflowHeightX() {
        return this.h1.binHeightX(-2);
    }

    public int getUnderflowEntriesX() {
        return this.h1.binEntriesY(-2);
    }

    public int getOverflowEntriesY() {
        return this.h1.binEntriesY(-1);
    }

    public double getOverflowHeightY() {
        return this.h1.binHeightY(-1);
    }

    public int getOverflowEntriesX() {
        return this.h1.binEntriesX(-1);
    }

    public double getOverflowHeightX() {
        return this.h1.binHeightX(-1);
    }

    public double getLowerEdgeX(int index) {
        return this.h1.xAxis().binLowerEdge(index);
    }

    public double getUpperEdgeX(int index) {
        return this.h1.xAxis().binUpperEdge(index);
    }

    public double getUpperEdgeY(int index) {
        return this.h1.yAxis().binUpperEdge(index);
    }

    public double getLowerEdgeY(int index) {
        return this.h1.yAxis().binLowerEdge(index);
    }

    public double getUnderflowHeightsX() {
        return this.h1.binHeightX(-2);
    }

    public int allEntries() {
        return this.h1.allEntries();
    }

    public int entries() {
        return this.h1.entries();
    }

    public IAxis getAxisX() {
        return this.h1.xAxis();
    }

    public IAxis getAxisY() {
        return this.h1.yAxis();
    }

    public int binEntries(int indexX, int indexY) {
        return this.h1.binEntries(indexX, indexY);
    }

    public double binError(int indexX, int indexY) {
        return this.h1.binError(indexX, indexY);
    }

    public void fill(double[] x, double[] y, double[] z) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                this.h1.fill(x[i], y[j], z[i]);
            }
        }
    }

    public void fill(double[] x, double[] y, double[] z, double[] w) {
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                this.h1.fill(x[i], y[j], z[i], w[i]);
            }
        }
    }

    public int mapBinNumber(int index, IAxis axis) {
        int bins = axis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

