/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IDataStyle;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.ILegendBoxStyle;
import hep.aida.IPlotter;
import hep.aida.IPlotterStyle;
import hep.aida.IStatisticsBoxStyle;
import hep.aida.ITextStyle;
import hep.aida.ITitleStyle;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.plotter.PlotterUtilities;
import jas.hist.VectorGraphicsTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.ExportVGraphics;
import jhplot.utils.Util;
import org.freehep.application.Application;
import org.freehep.application.PrintHelper;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.swing.popup.GlobalMouseListener;
import org.freehep.swing.popup.GlobalPopupListener;

public class HPlotter
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private IAnalysisFactory factory = null;
    private IFunctionFactory function = null;
    private IPlotter plotter;
    private IPlotterStyle style;
    private static int N1 = 0;
    private static int N2 = 0;
    private int N1final;
    private int N2final;
    private int plotID;
    private int xsize;
    private int ysize;
    private JPanel aidaPanel;
    private String title = "";
    private static final String rootKey = HPlotter.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";

    public HPlotter(String title, int xsize, int ysize, int n1, int n2) {
        this.title = title;
        this.xsize = xsize;
        this.ysize = ysize;
        this.N1final = n1;
        this.N2final = n2;
        N1 = 1;
        N2 = 1;
        this.plotID = 0;
        this.setTitle(title);
        if (n1 > 24 || n2 > 24) {
            this.N1final = 1;
            this.N2final = 1;
            this.xsize = 600;
            this.ysize = 440;
            Util.ErrorMessage((String)"Too many plot regions given! Maximum number is 25 by 25. Set to the defalts.");
        }
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item1 = new JMenuItem("Export");
        item1.setActionCommand("savePlotter");
        item1.addActionListener(this);
        JMenuItem item3 = new JMenuItem("Close");
        item3.setActionCommand("Close");
        item3.addActionListener(this);
        this.setDefaultCloseOperation(2);
        menu.add(item1);
        menu.add(item3);
        GlobalMouseListener gml = new GlobalMouseListener((Component)this);
        gml.addMouseListener((MouseListener)new GlobalPopupListener());
        bar.add(menu);
        this.setJMenuBar(bar);
        this.aidaPanel = this.getAidaPanel();
        this.setContentPane(this.aidaPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("Close")) {
            this.close();
        } else if (command.equals("saveRegion")) {
            ExportDialog dlg = new ExportDialog(null, true);
            dlg.showExportDialog((Component)this, "Save As...", (Component)this.aidaPanel, "hplotter");
        } else if (command.equals("printRegion")) {
            Studio studio = (Studio)Application.getApplication();
            try {
                PrintHelper ph = new PrintHelper((Component)this.aidaPanel, studio);
                ph.print();
            }
            catch (PrinterException x) {
                studio.error("Error printing plot", (Throwable)x);
            }
        } else if (command.equals("savePlotter")) {
            ExportDialog dlg = new ExportDialog(null, true);
            dlg.showExportDialog((Component)this.aidaPanel, "Save As...", (Component)this.aidaPanel, "hplotter");
        } else if (command.equals("copyPlotter")) {
            Clipboard cb = this.aidaPanel.getToolkit().getSystemClipboard();
            VectorGraphicsTransferable t = new VectorGraphicsTransferable((Component)this.aidaPanel);
            cb.setContents((Transferable)t, (ClipboardOwner)t);
        } else if (command.equals("printPlotter")) {
            Studio studio = (Studio)Application.getApplication();
            try {
                PrintHelper ph = new PrintHelper((Component)this.aidaPanel, studio);
                ph.print();
            }
            catch (PrinterException x) {
                studio.error("Error printing plot", (Throwable)x);
            }
        }
    }

    protected JPanel getAidaPanel() {
        this.factory = IAnalysisFactory.create();
        this.style = this.factory.createPlotterFactory().createPlotterStyle();
        this.plotter = this.factory.createPlotterFactory().create(this.title);
        this.plotter.setParameter("plotterWidth", Integer.toString(this.xsize));
        this.plotter.setParameter("plotterHeight", Integer.toString(this.ysize));
        this.plotter.createRegions(this.N1final, this.N2final);
        for (int i = 0; i < this.plotter.numberOfRegions(); ++i) {
            this.plotter.region(i).style().xAxisStyle().lineStyle().setThickness(2);
            this.plotter.region(i).style().yAxisStyle().lineStyle().setThickness(2);
        }
        JPanel jp = new JPanel(new BorderLayout());
        jp.add(PlotterUtilities.componentForPlotter((IPlotter)this.plotter), "Center");
        return jp;
    }

    public void createRegion(double x, double y, double w, double h) {
        this.plotter.createRegion(x, y, w, h);
    }

    public boolean cd(int cols, int rows) {
        N1 = cols;
        N2 = rows;
        if (cols > this.N1final || rows > this.N2final) {
            Util.ErrorMessage((String)"Wrong number of canvas in cd() method\n  ");
            N1 = 1;
            N2 = 1;
            return false;
        }
        if (this.N1final == 1 && this.N2final == 1) {
            this.plotID = 0;
            return true;
        }
        if (this.N1final == 2 && this.N2final == 1 && N1 == 2 && N2 == 1) {
            this.plotID = 1;
            return true;
        }
        if (this.N1final == 1 && this.N2final == 2 && N1 == 1 && N2 == 2) {
            this.plotID = 1;
            return true;
        }
        if (this.N1final == 2 && this.N2final == 2) {
            if (N1 == 1 && N2 == 2) {
                this.plotID = 1;
                return true;
            }
            if (N1 == 2 && N2 == 1) {
                this.plotID = 2;
                return true;
            }
            if (N1 == 2 && N2 == 2) {
                this.plotID = 3;
                return true;
            }
        }
        this.plotID = (this.N2final - 1) * (N1 - 1) + (N2 - 1);
        return true;
    }

    public int getCdX() {
        return N1;
    }

    public int getCdY() {
        return N2;
    }

    public int getNtotX() {
        return this.N1final;
    }

    public int getNtotY() {
        return this.N2final;
    }

    public void visible(boolean vs) {
        if (vs) {
            this.pack();
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void visible() {
        this.visible(true);
    }

    public IPlotter getPlotter() {
        return this.plotter;
    }

    public HPlotter(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1);
    }

    public HPlotter(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1);
    }

    public HPlotter(String title) {
        this(title, 600, 400, 1, 1);
    }

    public HPlotter() {
        this("Default", 600, 400, 1, 1);
    }

    public void updateAll() {
        this.plotter.refresh();
    }

    public void update() {
        this.plotter.region(this.plotID).refresh();
    }

    public void export(String file) {
        this.aidaPanel.validate();
        ExportVGraphics.export(this.aidaPanel, rootKey, file);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    public String getTitle() {
        return this.plotter.title();
    }

    public void close() {
        this.setVisible(false);
        this.plotter.clearRegions();
        this.plotter.destroyRegions();
        this.plotter = null;
        this.aidaPanel = null;
        this.dispose();
    }

    private String colorString(Color c) {
        String rs = Integer.toString(c.getRed());
        String rg = Integer.toString(c.getGreen());
        String rb = Integer.toString(c.getBlue());
        String color = rs + "," + rg + "," + rb;
        return color;
    }

    public void draw(H1D h1, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)h1.get(), style);
    }

    public void draw(H2D h2, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2.get(), style);
    }

    public void draw(H2D h2, String style_str) {
        if (style_str.equalsIgnoreCase("ColorMap")) {
            this.style.setParameter("showStatisticsBox", "false");
            this.style.setParameter("hist2DStyle", "colorMap");
            this.style.dataStyle().fillStyle().setParameter("colorMapScheme", "rainbow");
        } else if (style_str.equalsIgnoreCase("Scatter")) {
            this.style.dataStyle().markerStyle().setColor("blue");
            this.style.dataStyle().markerStyle().setShape("1");
            this.style.dataStyle().markerStyle().setParameter("size", "5");
        } else if (style_str.equalsIgnoreCase("Box")) {
            this.style.setParameter("backgroundColor", "yellow");
            this.style.setParameter("foregroundColor", "green");
            this.style.setParameter("hist2DStyle", "box");
            this.style.dataStyle().markerStyle().setColor("blue");
            this.style.setParameter("showAsScatterPlot", "false");
        } else if (style_str.equalsIgnoreCase("style2D")) {
            this.style.setParameter("backgroundColor", "yellow");
            this.style.setParameter("foregroundColor", "green");
            this.style.setParameter("hist2DStyle", "ellipse");
            this.style.dataStyle().markerStyle().setColor("blue");
            this.style.setParameter("showAsScatterPlot", "false");
        } else {
            this.style.setParameter("backgroundColor", "yellow");
            this.style.setParameter("foregroundColor", "green");
            this.style.setParameter("hist2DStyle", "ellipse");
            this.style.dataStyle().markerStyle().setColor("blue");
            this.style.setParameter("showAsScatterPlot", "false");
        }
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2.get(), this.style);
    }

    public void draw(H1D h1) {
        IDataStyle dataStyle = this.factory.createPlotterFactory().createDataStyle();
        Color c = h1.getDrawOption().getFillColor();
        dataStyle.setParameter("showErrorBars", "true");
        dataStyle.setParameter("showHistogramBars", "false");
        dataStyle.setParameter("errorBarsColor", "black");
        dataStyle.setParameter("fillHistogramBars", "false");
        if (h1.getLineParm().isBarShown()) {
            dataStyle.setParameter("showHistogramBars", "true");
        }
        if (h1.isFilled()) {
            dataStyle.setParameter("fillHistogramBars", "true");
        }
        dataStyle.fillStyle().setColor(this.colorString(c));
        dataStyle.lineStyle().setColor(this.colorString(h1.getColor()));
        dataStyle.lineStyle().setThickness((int)h1.getLineParm().getPenWidth());
        dataStyle.errorBarStyle().setVisible(h1.getLineParm().getErrorsY());
        this.style.setDataStyle(dataStyle);
        this.plotter.region(this.plotID).plot((IBaseHistogram)h1.get(), this.style);
    }

    public void draw(Histogram1D h1, IPlotterStyle style) {
        this.plotter.region(this.plotID).applyStyle(style);
        this.plotter.region(this.plotID).plot((IBaseHistogram)h1, style);
    }

    public void draw(Histogram2D h2, IPlotterStyle style) {
        this.plotter.region(this.plotID).applyStyle(style);
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2, style);
    }

    public void draw(Histogram1D h1) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)h1);
    }

    public void draw(Histogram1D h1, IDataStyle datastyle) {
        this.plotter.region(this.plotID).style().setDataStyle(datastyle);
        this.plotter.region(this.plotID).plot((IBaseHistogram)h1);
    }

    public void draw(Histogram2D h2, IDataStyle datastyle) {
        this.plotter.region(this.plotID).style().setDataStyle(datastyle);
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2);
    }

    public void draw(H2D h2) {
        Color c = h2.getDrawOption().getFillColor();
        this.plotter.region(this.plotID).style().dataStyle().fillStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().dataStyle().lineStyle().setColor(this.colorString(h2.getColor()));
        this.plotter.region(this.plotID).style().dataStyle().lineStyle().setThickness((int)h2.getLineParm().getPenWidth());
        this.plotter.region(this.plotID).style().dataStyle().errorBarStyle().setVisible(h2.getLineParm().getErrorsY());
        this.plotter.region(this.plotID).style().setParameter("hist2DStyle", "ellipse");
        this.plotter.region(this.plotID).style().dataStyle().markerStyle().setColor(this.colorString(h2.getColor()));
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2.get());
    }

    public void draw(Histogram2D h2) {
        this.plotter.region(this.plotID).style().setParameter("hist2DStyle", "ellipse");
        this.plotter.region(this.plotID).style().dataStyle().markerStyle().setColor("blue");
        this.plotter.region(this.plotID).plot((IBaseHistogram)h2);
    }

    public void draw(IDataPointSet p1d) {
        this.plotter.region(this.plotID).plot(p1d);
    }

    public IPlotterStyle getPlotterStyle() {
        return this.plotter.region(this.plotID).style();
    }

    public IDataStyle getDataStyle() {
        return this.plotter.region(this.plotID).style().dataStyle();
    }

    public void draw(IDataPointSet p1d, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot(p1d, style);
    }

    public void draw(IDataPointSet p1d, IDataStyle datastyle) {
        IPlotterStyle s = this.plotter.region(this.plotID).style();
        this.plotter.region(this.plotID).plot(p1d, s);
    }

    public void draw(P1D p1d) {
        IDataStyle dataStyle = this.factory.createPlotterFactory().createDataStyle();
        Color c = p1d.getDrawOption().getFillColor();
        dataStyle.setParameter("showDataPoints", "true");
        dataStyle.setParameter("showErrorBars", "true");
        dataStyle.setParameter("showHistogramBars", "false");
        dataStyle.setParameter("errorBarsColor", "black");
        if (p1d.getLineParm().isDrawSymbol()) {
            dataStyle.setParameter("showDataPoints", "true");
        }
        dataStyle.fillStyle().setColor(this.colorString(c));
        dataStyle.lineStyle().setColor(this.colorString(p1d.getColor()));
        dataStyle.lineStyle().setThickness((int)p1d.getLineParm().getPenWidth());
        dataStyle.errorBarStyle().setVisible(p1d.getLineParm().getErrorsY());
        dataStyle.markerStyle().setSize((int)p1d.getLineParm().getSymbolSize());
        dataStyle.markerStyle().setColor(this.colorString(p1d.getColor()));
        String shape = "circle";
        if (p1d.getSymbol() == 0) {
            shape = "circle";
        }
        if (p1d.getSymbol() == 1) {
            shape = "square";
        }
        if (p1d.getSymbol() == 2) {
            shape = "diamond";
        }
        if (p1d.getSymbol() == 3) {
            shape = "triangle";
        }
        if (p1d.getSymbol() == 4) {
            shape = "dot";
        }
        if (p1d.getSymbol() == 10) {
            shape = "star";
        }
        dataStyle.markerStyle().setShape(shape);
        this.style.setDataStyle(dataStyle);
        this.plotter.region(this.plotID).plot(p1d.getIDataPointSet(), this.style);
    }

    public void draw(F1D f1d) {
        Color c = f1d.getDrawOption().getFillColor();
        this.plotter.region(this.plotID).style().dataStyle().fillStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().dataStyle().lineStyle().setColor(this.colorString(f1d.getColor()));
        this.plotter.region(this.plotID).style().dataStyle().lineStyle().setThickness((int)f1d.getLineParm().getPenWidth());
        this.plotter.region(this.plotID).style().dataStyle().errorBarStyle().setVisible(f1d.getLineParm().getErrorsY());
        IFunction ff = f1d.getIFunction();
        if (ff == null) {
            Util.ErrorMessage((String)"You can plot only functions created by AIDA");
            return;
        }
        this.plotter.region(this.plotID).plot(ff);
    }

    public void draw(IFunction f1d) {
        this.plotter.region(this.plotID).plot(f1d);
    }

    public void draw(IFunction f1d, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot(f1d, style);
    }

    public void draw(IFunction f1d, IDataStyle datastyle) {
        IPlotterStyle s = this.plotter.region(this.plotID).style();
        this.plotter.region(this.plotID).plot(f1d, s);
    }

    public void draw(Cloud1D c1d) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)c1d);
    }

    public void draw(Cloud1D c1d, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)c1d, style);
    }

    public void draw(Cloud1D c1d, IDataStyle datastyle) {
        IPlotterStyle s = this.plotter.region(this.plotID).style();
        this.plotter.region(this.plotID).plot((IBaseHistogram)c1d, s);
    }

    public void draw(Cloud2D c2d) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)c2d);
    }

    public void draw(Cloud2D c2d, IPlotterStyle style) {
        this.plotter.region(this.plotID).plot((IBaseHistogram)c2d, style);
    }

    public void draw(Cloud2D c2d, IDataStyle datastyle) {
        IPlotterStyle s = this.plotter.region(this.plotID).style();
        this.plotter.region(this.plotID).plot((IBaseHistogram)c2d, s);
    }

    public void setBackgColor(Color c) {
        this.plotter.region(this.plotID).style().setParameter("backgroundColor", this.colorString(c));
    }

    public void setStatBox(boolean set) {
        if (set) {
            this.plotter.region(this.plotID).style().statisticsBoxStyle().setVisible(true);
        } else {
            this.plotter.region(this.plotID).style().statisticsBoxStyle().setVisible(false);
        }
    }

    public IStatisticsBoxStyle getStatBoxStyle() {
        return this.plotter.region(this.plotID).style().statisticsBoxStyle();
    }

    public ILegendBoxStyle getLegendStyle() {
        return this.plotter.region(this.plotID).style().legendBoxStyle();
    }

    public IPlotterStyle getRegionStyle() {
        return this.plotter.region(this.plotID).style();
    }

    public IAxisStyle getAxisStyle(int axis) {
        if (axis == 0) {
            return this.plotter.region(this.plotID).style().xAxisStyle();
        }
        if (axis == 1) {
            return this.plotter.region(this.plotID).style().yAxisStyle();
        }
        return this.plotter.region(this.plotID).style().zAxisStyle();
    }

    public void setStatColor(Color foreg, Color backg) {
        this.plotter.region(this.plotID).style().statisticsBoxStyle().textStyle().setColor(this.colorString(foreg));
        this.plotter.region(this.plotID).style().statisticsBoxStyle().boxStyle().foregroundStyle().setColor(this.colorString(foreg));
        this.plotter.region(this.plotID).style().statisticsBoxStyle().boxStyle().backgroundStyle().setColor(this.colorString(backg));
    }

    public void setStatFont(Font f) {
        this.plotter.region(this.plotID).style().statisticsBoxStyle().textStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().statisticsBoxStyle().textStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().statisticsBoxStyle().textStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().statisticsBoxStyle().textStyle().setItalic(f.isItalic());
    }

    public void setStatBoxPos(double x, double y) {
        this.plotter.region(this.plotID).style().statisticsBoxStyle().boxStyle().setX(x);
        this.plotter.region(this.plotID).style().statisticsBoxStyle().boxStyle().setY(y);
    }

    public void setLegendPos(double x, double y) {
        this.plotter.region(this.plotID).style().legendBoxStyle().boxStyle().setX(x);
        this.plotter.region(this.plotID).style().legendBoxStyle().boxStyle().setY(y);
    }

    public void setLegend(boolean set) {
        if (set) {
            this.plotter.region(this.plotID).style().legendBoxStyle().setVisible(true);
        } else {
            this.plotter.region(this.plotID).style().legendBoxStyle().setVisible(false);
        }
    }

    public void setLegendFont(Font f) {
        this.plotter.region(this.plotID).style().legendBoxStyle().textStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().legendBoxStyle().textStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().legendBoxStyle().textStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().legendBoxStyle().textStyle().setItalic(f.isItalic());
    }

    public IPlotterStyle getStyle() {
        return this.plotter.region(this.plotID).style();
    }

    public void setAutoRange() {
        this.setAutoRange(true);
    }

    public void setAutoRange(boolean b) {
        if (!b) {
            this.setRange(0.0, 1.0, 0.0, 1.0);
        }
    }

    public void setRange(int axis, double min, double max) {
        if (axis == 0) {
            this.plotter.region(this.plotID).setXLimits(min, max);
        }
        if (axis == 1) {
            this.plotter.region(this.plotID).setYLimits(min, max);
        }
    }

    public void setRangeX(double min, double max) {
        this.plotter.region(this.plotID).setXLimits(min, max);
    }

    public void setRangeY(double min, double max) {
        this.plotter.region(this.plotID).setYLimits(min, max);
    }

    public void setRangeAll(int axis, double min, double max) {
        int Np = this.plotter.numberOfRegions();
        for (int i1 = 0; i1 < Np; ++i1) {
            if (axis == 0) {
                this.plotter.region(i1).setXLimits(min, max);
            }
            if (axis != 1) continue;
            this.plotter.region(i1).setYLimits(min, max);
        }
    }

    public void setRange(double minX, double maxX, double minY, double maxY) {
        this.plotter.region(this.plotID).setXLimits(minX, maxX);
        this.plotter.region(this.plotID).setYLimits(minY, maxY);
    }

    public void setRangeAll(double minX, double maxX, double minY, double maxY) {
        int Np = this.plotter.numberOfRegions();
        for (int i1 = 0; i1 < Np; ++i1) {
            this.plotter.region(i1).setXLimits(minX, maxX);
            this.plotter.region(i1).setYLimits(minY, maxY);
        }
    }

    public boolean setParAxis(int axis, String par, String opt) {
        if (axis == 0) {
            return this.plotter.region(this.plotID).style().xAxisStyle().setParameter(par, opt);
        }
        if (axis == 0) {
            return this.plotter.region(this.plotID).style().yAxisStyle().setParameter(par, opt);
        }
        return false;
    }

    public boolean setParRegion(int axis, String par, String opt) {
        if (axis == 0) {
            return this.plotter.region(this.plotID).style().setParameter(par, opt);
        }
        if (axis == 0) {
            return this.plotter.region(this.plotID).style().setParameter(par, opt);
        }
        return false;
    }

    public List<String> getParAxis() {
        String[] a = this.plotter.region(this.plotID).style().xAxisStyle().availableParameters();
        return Arrays.asList(a);
    }

    public List<String> getOptRegion(String parameter) {
        String[] a = this.plotter.region(this.plotID).style().availableParameterOptions(parameter);
        return Arrays.asList(a);
    }

    public List<String> getOptAxis(String parameter) {
        String[] a = this.plotter.region(this.plotID).style().xAxisStyle().availableParameterOptions(parameter);
        return Arrays.asList(a);
    }

    public void setGTitle(String sname, Font f, Color c) {
        this.plotter.setTitle(sname);
        ITitleStyle s = this.factory.createPlotterFactory().createTitleStyle();
        ITextStyle t = this.factory.createPlotterFactory().createTextStyle();
        t.setColor(this.colorString(c));
        t.setFont(f.getFontName());
        t.setFontSize((double)f.getSize());
        t.setBold(f.isItalic());
        t.setItalic(f.isItalic());
        s.setTextStyle(t);
        this.plotter.setTitleStyle(s);
    }

    public void setGTitle(String sname, Color c) {
        this.setGTitle(sname, new Font("Arial", 1, 18), c);
    }

    public int getSizeX() {
        return this.xsize;
    }

    public int getSizeY() {
        return this.ysize;
    }

    public void setGTitle(String sname) {
        this.setGTitle(sname, new Font("Arial", 1, 18), Color.black);
    }

    public void distroy() {
        this.close();
    }

    public void clear(int i1, int i2) {
        System.gc();
    }

    public void setNameX(String s) {
        this.setNameX(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setBackgColorGraph(Color c) {
        this.plotter.region(this.plotID).style().setParameter("dataAreaColor", this.colorString(c));
    }

    public void setLogScale(int axis, boolean b) {
        if (axis == 0) {
            if (!b) {
                this.plotter.region(this.plotID).style().xAxisStyle().setScaling("linear");
            }
            if (b) {
                this.plotter.region(this.plotID).style().xAxisStyle().setScaling("logarithmic");
            }
        }
        if (axis == 1) {
            if (!b) {
                this.plotter.region(this.plotID).style().yAxisStyle().setScaling("linear");
            }
            if (b) {
                this.plotter.region(this.plotID).style().yAxisStyle().setScaling("logarithmic");
            }
        }
    }

    public void setNameX(String s, Font f) {
        this.setNameX(s, f, Color.black);
    }

    public void setNameX(String s, Font f, Color c) {
        this.plotter.region(this.plotID).style().xAxisStyle().setLabel(s);
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setItalic(f.isItalic());
    }

    public double getMinValue(int axis) {
        if (axis == 0) {
            return this.plotter.region(this.plotID).xLimitMin();
        }
        if (axis == 1) {
            return this.plotter.region(this.plotID).yLimitMin();
        }
        return 0.0;
    }

    public double getMaxValue(int axis) {
        if (axis == 0) {
            return this.plotter.region(this.plotID).xLimitMax();
        }
        if (axis == 1) {
            return this.plotter.region(this.plotID).yLimitMax();
        }
        return 0.0;
    }

    public List<String> getParPlotter() {
        String[] a = this.plotter.availableParameters();
        return Arrays.asList(a);
    }

    public List<String> getParRegion() {
        String[] a = this.plotter.region(this.plotID).style().availableParameters();
        return Arrays.asList(a);
    }

    public List<String> getTextFonts() {
        String[] a = this.plotter.region(this.plotID).style().titleStyle().textStyle().availableFonts();
        return Arrays.asList(a);
    }

    public List<String> getParText() {
        String[] a = this.plotter.region(this.plotID).style().titleStyle().textStyle().availableParameters();
        return Arrays.asList(a);
    }

    public void setNameY(String s) {
        this.setNameY(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setNameY(String s, Font f) {
        this.setNameY(s, f, Color.black);
    }

    public void setNameY(String s, Font f, Color c) {
        this.plotter.region(this.plotID).style().yAxisStyle().setLabel(s);
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().yAxisStyle().labelStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().yAxisStyle().labelStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().yAxisStyle().labelStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().yAxisStyle().labelStyle().setItalic(f.isItalic());
    }

    @Override
    public void setName(String name) {
        this.setName(name, new Font("Arial", 1, 18), Color.black);
    }

    public void setName(String s, Font f, Color c) {
        this.plotter.region(this.plotID).setTitle(s);
        this.plotter.region(this.plotID).style().titleStyle().textStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().xAxisStyle().labelStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().titleStyle().textStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().titleStyle().textStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().titleStyle().textStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().titleStyle().textStyle().setItalic(f.isItalic());
    }

    public void setName(String s, Font f) {
        this.setName(s, f, Color.black);
    }

    public void setTicStyle(int axis, Font f, Color c) {
        if (axis == 0) {
            this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setColor(this.colorString(c));
            this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setFont(f.getFontName());
            this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setFontSize((double)f.getSize());
            this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setBold(f.isBold());
            this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setItalic(f.isItalic());
        }
        if (axis == 1) {
            this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setColor(this.colorString(c));
            this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setFont(f.getFontName());
            this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setFontSize((double)f.getSize());
            this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setBold(f.isBold());
            this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setItalic(f.isItalic());
        }
    }

    public void setTicColor(Color c) {
        this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setColor(this.colorString(c));
        this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setColor(this.colorString(c));
    }

    public void setTicFont(Font f) {
        this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().xAxisStyle().tickLabelStyle().setItalic(f.isItalic());
        this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setFont(f.getFontName());
        this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setFontSize((double)f.getSize());
        this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setBold(f.isBold());
        this.plotter.region(this.plotID).style().yAxisStyle().tickLabelStyle().setItalic(f.isItalic());
    }

    public Color getAxesColor() {
        String mm = this.plotter.region(this.plotID).style().yAxisStyle().lineStyle().color();
        String[] temp = mm.split(",");
        if (temp.length > 2) {
            int a1 = Integer.parseInt(temp[0]);
            int a2 = Integer.parseInt(temp[1]);
            int a3 = Integer.parseInt(temp[2]);
            return new Color(a1, a2, a3);
        }
        return Color.black;
    }

    public void setAxesColor(Color c) {
        this.plotter.region(this.plotID).style().yAxisStyle().lineStyle().setColor(this.colorString(c));
    }
}

