/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.histogram.Histogram1D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jhplot.F1D;
import jhplot.FND;
import jhplot.H1D;
import jhplot.HKey;
import jhplot.HLabel;
import jhplot.HLabelEq;
import jhplot.HMLabel;
import jhplot.JHPlot;
import jhplot.P1D;
import jhplot.gui.CommonGUI;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.io.BrowserData;
import jhplot.io.JHreader;
import jhplot.io.JHwriter;
import jhplot.shapes.HShape;
import jhplot.shapes.Picture;
import jhplot.utils.ExtensionFileFilter;
import jhplot.utils.HelpDialog;
import jplot.DataArray;
import jplot.GraphGeneral;
import jplot.GraphLabel;
import jplot.GraphSettings;
import jplot.GraphXY;
import jplot.JPlot;
import jplot.StyleChooser;

public class HPlot
extends GHFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String lf = System.getProperty("file.separator");
    private static int IndexPlot = 0;
    protected GraphGeneral[][] graph;
    protected GraphSettings[][] gs;
    protected StyleChooser[][] sc;
    protected JFrame[][] frames;
    protected JPlot[][] jp;
    protected int[][] plotType;
    protected int[][] hkeyCounter;
    protected Vector<DataArray>[][] data;
    private IAnalysisFactory m_IAnalysisFactory = null;
    private IHistogramFactory m_IHistogramFactory = null;
    private ITree m_ITree = null;
    private IFitFactory m_IFitFactory = null;
    private IFunctionFactory m_IFunctionFactory = null;
    private Thread1 m_Close;
    private final String help_file = "hplot";
    protected static int isOpen = 0;

    public HPlot(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set);
        if (set) {
            this.setGraph();
        }
    }

    @Override
    protected void clearFrame() {
        JFrame frm = this.getFrame();
        int res = JOptionPane.showConfirmDialog(frm, "This will clear HPlot frame. Data and settings will be lost. Continue?", "", 0);
        if (res == 1) {
            return;
        }
        String mess = "clear jHPlot frame";
        JHPlot.showStatusBarText(mess);
        Thread t = new Thread(mess){

            @Override
            public void run() {
                HPlot.this.removeGraph();
            }
        };
        t.start();
    }

    @Override
    public void refreshFrame() {
        String mess = "refresh  jHPlot frame";
        JHPlot.showStatusBarText(mess);
        Thread t = new Thread(mess){

            @Override
            public void run() {
                HPlot.this.updateAll();
            }
        };
        t.start();
    }

    @Override
    protected void openReadDialog() {
        JFileChooser fileChooser = new JFileChooser(".");
        ExtensionFileFilter filter1 = new ExtensionFileFilter("(*.jhp) HPlot graphs", new String[]{"jhp"});
        fileChooser.setFileFilter((FileFilter)filter1);
        int status = fileChooser.showOpenDialog(null);
        if (status == 0) {
            String mess = "reading JHplot XML file";
            JHPlot.showStatusBarText(mess);
            final File f = fileChooser.getSelectedFile();
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    boolean res = HPlot.this.readScript(f);
                }
            };
            t.start();
        } else if (status == 1) {
            return;
        }
    }

    protected boolean readScript(File f) {
        boolean res = JHreader.readScript(f, this);
        return res;
    }

    protected boolean writeScript(File f) {
        boolean res = JHwriter.writeScript(f, this);
        return res;
    }

    public void read(final String file) {
        Thread t = new Thread("reading XML file "){

            @Override
            public void run() {
                boolean res = HPlot.this.readScript(new File(file));
            }
        };
        t.start();
    }

    public void write(final String file) {
        Thread t = new Thread("writing XML file "){

            @Override
            public void run() {
                boolean res = HPlot.this.writeScript(new File(file));
            }
        };
        t.start();
    }

    public HPlot(String title, int xsize, int ysize, int n1, int n2) {
        super(title, xsize, ysize, n1, n2, true);
        this.setGraph();
    }

    public void visible(boolean vs) {
        this.updateAll();
        this.mainFrame.setVisible(vs);
        if (!vs) {
            this.mainFrame.validate();
        }
    }

    public void visible() {
        this.updateAll();
        this.mainFrame.setVisible(true);
    }

    public void visible(int posX, int posY) {
        this.updateAll();
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public void distroy() {
        this.mainFrame.setVisible(false);
        this.close();
        this.removeFrame();
    }

    public void showGraph(boolean vs) {
        this.jp[N1][N2].showGraph(vs);
    }

    public void showAllGraph(boolean vs) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.jp[i1][i2].showGraph(vs);
            }
        }
    }

    public void factories() {
        this.m_IAnalysisFactory = IAnalysisFactory.create();
        this.m_ITree = this.m_IAnalysisFactory.createTreeFactory().create();
        this.m_IHistogramFactory = this.m_IAnalysisFactory.createHistogramFactory(this.m_ITree);
        this.m_IFitFactory = this.m_IAnalysisFactory.createFitFactory();
        this.m_IFunctionFactory = this.m_IAnalysisFactory.createFunctionFactory(this.m_ITree);
    }

    public IAnalysisFactory analF() {
        return this.m_IAnalysisFactory;
    }

    public ITree treeF() {
        return this.m_ITree;
    }

    public IFitFactory fitF() {
        return this.m_IFitFactory;
    }

    public IFunctionFactory funcF() {
        return this.m_IFunctionFactory;
    }

    public IHistogramFactory histF() {
        return this.m_IHistogramFactory;
    }

    public void setGraph() {
        this.gs = new GraphSettings[this.N1final][this.N2final];
        this.jp = new JPlot[this.N1final][this.N2final];
        this.graph = new GraphXY[this.N1final][this.N2final];
        this.frames = new JFrame[this.N1final][this.N2final];
        this.data = new Vector[this.N1final][this.N2final];
        this.sc = new StyleChooser[this.N1final][this.N2final];
        this.plotType = new int[this.N1final][this.N2final];
        this.hkeyCounter = new int[this.N1final][this.N2final];
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.frames[i1][i2] = new JFrame();
                this.jp[i1][i2] = new JPlot(this.frames[i1][i2], null, null, false);
                this.frames[i1][i2].getContentPane().add(this.jp[i1][i2]);
                this.frames[i1][i2].setTitle("Editor for Canvas (" + Integer.toString(i1 + 1) + "," + Integer.toString(i2 + 1) + ")");
                this.frames[i1][i2].setSize(400, 400);
                this.frames[i1][i2].setVisible(false);
                this.hkeyCounter[i1][i2] = 0;
                JMenuBar bar1 = new JMenuBar();
                JMenu menu1 = new JMenu("Exit");
                JMenuItem item1 = new JMenuItem(new NotShowAction());
                menu1.add(item1);
                JMenuItem item2 = new JMenuItem(new RefreshAction());
                menu1.add(item2);
                bar1.add(menu1);
                this.frames[i1][i2].setJMenuBar(bar1);
                this.sc[i1][i2] = this.jp[i1][i2].getStyleChooser();
                this.gs[i1][i2] = this.jp[i1][i2].getGraphSettings();
                this.plotType[i1][i2] = 0;
                this.gs[i1][i2].setRange(0, 0.0, 1.0);
                this.gs[i1][i2].setRange(1, 0.0, 1.0);
                this.gs[i1][i2].setAutoRange(0, false);
                this.gs[i1][i2].setAutoRange(1, false);
                this.gs[i1][i2].setDrawGrid(0, false);
                this.gs[i1][i2].setDrawGrid(1, false);
                this.gs[i1][i2].setLeftMargin(50.0);
                Font fleg = new Font("Arial", 1, 14);
                this.gs[i1][i2].setLegendFont(fleg);
                this.data[i1][i2] = new Vector();
                this.graph[i1][i2] = this.jp[i1][i2].getGraph();
                final int kk1 = i1;
                final int kk2 = i2;
                this.graph[i1][i2].m_edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        HPlot.this.frames[kk1][kk2].setVisible(true);
                        HPlot.this.N1edit = kk1;
                        HPlot.this.N2edit = kk2;
                    }
                });
                this.mainPanel.add(this.graph[i1][i2]);
                this.update(i1, i2);
            }
        }
    }

    public HPlot(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public void resizePad(double widthScale, double heightScale) {
        Dimension dim = this.graph[N1][N2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.graph[N1][N2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.graph[N1][N2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.graph[N1][N2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void resizePad(int n1, int n2, double widthScale, double heightScale) {
        Dimension dim = this.graph[n1][n2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.graph[n1][n2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.graph[n1][n2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.graph[n1][n2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public HPlot(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public HPlot(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public HPlot() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void updateAll() {
        if (this.N1final == 0 && this.N2final == 0) {
            return;
        }
        if (this.jp == null) {
            return;
        }
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.graph[i1][i2].show(this.data[i1][i2]);
                this.jp[i1][i2].updateGraphIfShowing();
            }
        }
    }

    public void update(int n1, int n2) {
        this.graph[n1][n2].show(this.data[n1][n2]);
        this.jp[n1][n2].updateGraphIfShowing();
    }

    public void update() {
        this.update(N1, N2);
    }

    public void updateGraphIfShowing() {
        this.jp[N1][N2].updateGraphIfShowing();
    }

    public void viewHisto(boolean what) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].set2DType(0);
                if (!what) continue;
                this.gs[i1][i2].set2DType(1);
            }
        }
    }

    public void printGraphSettings() {
        System.out.println("printGraphSettings");
        System.out.println("N1=" + Integer.toString(N1) + "  N2=" + Integer.toString(N2));
        PrintStream out = System.out;
        this.gs[N1][N2].print(out);
    }

    public void setAttResizable(boolean resizable) {
        this.gs[N1][N2].setAttResizable(resizable);
    }

    public void setAttResizableAll(boolean resizable) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setAttResizable(resizable);
            }
        }
    }

    public void printGraphSettings(PrintStream out) {
        System.out.println("printGraphSettings");
        System.out.println("N1=" + Integer.toString(N1) + "  N2=" + Integer.toString(N2));
        this.gs[N1][N2].print(out);
    }

    public void setContour(boolean contour) {
        this.plotType[HPlot.N1][HPlot.N2] = 0;
        this.gs[HPlot.N1][HPlot.N2] = this.jp[N1][N2].getGraphSettings();
        Dimension panel = this.gs[N1][N2].getPanelSize();
        if (contour) {
            this.plotType[HPlot.N1][HPlot.N2] = 4;
            this.gs[N1][N2].setRightMargin((int)((double)panel.width * 0.17));
            this.gs[N1][N2].setContour_bar(true);
            this.gs[N1][N2].setContour_levels(10);
            this.gs[N1][N2].setContour_binsX(40);
            this.gs[N1][N2].setContour_binsY(40);
            this.gs[N1][N2].setContour_gray(false);
            this.gs[N1][N2].setDrawLegend(false);
        } else {
            this.gs[N1][N2].setGraphType(0);
            this.gs[N1][N2].setRightMargin((int)((double)panel.width * 0.1));
        }
        this.jp[N1][N2].setGraphSettings(this.gs[N1][N2]);
    }

    public void setContourBar(boolean bar) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        this.gs[N1][N2].setRightMargin((int)((double)panel.width * 0.1));
        if (bar) {
            this.gs[N1][N2].setRightMargin((int)((double)panel.width * 0.2));
        }
        this.gs[N1][N2].setContour_bar(bar);
    }

    public void setContourLevels(int levels) {
        this.gs[N1][N2].setContour_levels(levels);
    }

    public void setContourBins(int binsX, int binsY) {
        this.gs[N1][N2].setContour_binsX(binsX);
        this.gs[N1][N2].setContour_binsY(binsY);
    }

    public void setContourGray(boolean gray) {
        this.gs[N1][N2].setContour_gray(gray);
    }

    public void setAntiAlias(boolean setit) {
        this.gs[N1][N2].setAntiAlias(setit);
    }

    public boolean getAntiAlias() {
        return this.gs[N1][N2].getAntiAlias();
    }

    public void setAntiAliasAll(boolean setit) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setAntiAlias(setit);
            }
        }
    }

    public void setNameX(String s, Font f, Color c) {
        GraphLabel label = new GraphLabel(0, s, f, c);
        this.gs[N1][N2].addLabel(label);
    }

    public void setLegendFont(Font font) {
        this.gs[N1][N2].setLegendFont(font);
    }

    public void setLegendFont(String name) {
        this.gs[N1][N2].setLegendFont(Font.decode(name));
    }

    public void setMarginLeft(double lm) {
        this.gs[N1][N2].setLeftMargin(lm);
    }

    public double getMarginLeft() {
        return this.gs[N1][N2].getLeftMargin();
    }

    public Dimension getPanelSize() {
        return this.gs[N1][N2].getPanelSize();
    }

    public void setPanelSize(Dimension d) {
        this.gs[N1][N2].setPanelSize(d);
    }

    public double getMarginRight() {
        return this.gs[N1][N2].getRightMargin();
    }

    public void setMarginRight(double rm) {
        this.gs[N1][N2].setRightMargin(rm);
    }

    public double getPenWidthAxis() {
        return this.gs[N1][N2].getPenWidthAxis();
    }

    public void setPenWidthAxis(double width) {
        this.gs[N1][N2].setPenWidthAxis((float)width);
    }

    public double getMarginBottom() {
        return this.gs[N1][N2].getBottomMargin();
    }

    public void setMarginBottom(double bm) {
        this.gs[N1][N2].setBottomMargin(bm);
    }

    public double getMarginTop() {
        return this.gs[N1][N2].getTopMargin();
    }

    public void setMarginTop(double tm) {
        this.gs[N1][N2].setTopMargin(tm);
    }

    public double getTicLength(int axis) {
        return this.gs[N1][N2].getTicLength(axis);
    }

    public double getSubTicLength(int axis) {
        return this.gs[N1][N2].getSubTicLength(axis);
    }

    public void getSubTicNumber(int axis) {
        this.gs[N1][N2].getSubTicNumber(axis);
    }

    public void setTicLength(int axis, double length) {
        this.gs[N1][N2].setTicLength(axis, length);
    }

    public void setSubTicLength(int axis, double length) {
        this.gs[N1][N2].setSubTicLength(axis, length);
    }

    public void setSubTicNumber(int axis, int number) {
        this.gs[N1][N2].setSubTicNumber(axis, number);
    }

    public void setTicLength(double length) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setTicLength(0, length);
                this.gs[i1][i2].setTicLength(1, length);
            }
        }
    }

    public void setSubTicLength(double length) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setSubTicLength(0, length);
                this.gs[i1][i2].setSubTicLength(1, length);
            }
        }
    }

    public boolean getAxesRatioUse() {
        return this.gs[N1][N2].useAxesRatio();
    }

    public void setAxesRatioUse(boolean b) {
        this.gs[N1][N2].setUseAxesRatio(b);
    }

    public double getAxesRatio() {
        return this.gs[N1][N2].getAxesRatio();
    }

    public void setAxesRatio(double r) {
        this.gs[N1][N2].setAxesRatio(r);
    }

    public void setAxisArrow(int type) {
        this.gs[N1][N2].setAxesArrow(type);
    }

    public int getAxisArrow() {
        return this.gs[N1][N2].getAxesArrow();
    }

    public void setNumberOfTicsFixed(int axis, boolean b) {
        this.gs[N1][N2].setUseNumberOfTics(axis, b);
    }

    public void setNumberOfTicsFixed(boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setUseNumberOfTics(0, b);
                this.gs[i1][i2].setUseNumberOfTics(1, b);
            }
        }
    }

    public boolean useNumberOfTics(int axis) {
        return this.gs[N1][N2].useNumberOfTics(axis);
    }

    public int getNumberOfTics(int axis) {
        return this.gs[N1][N2].getNumberOfTics(axis);
    }

    public void setNumberOfTics(int axis, int n) {
        this.gs[N1][N2].setNumberOfTics(axis, n);
    }

    public int getMaxNumberOfSubticsLog() {
        return this.gs[N1][N2].getMaxNumberOfTics();
    }

    public void setMaxNumberOfSubticsLog(int n) {
        this.gs[N1][N2].setMaxNumberOfTics(n);
    }

    public double getMinValue(int axis) {
        return this.gs[N1][N2].getMinValue(axis);
    }

    public void setMinValue(int axis, double min) {
        this.gs[N1][N2].setMinValue(axis, min);
    }

    public double getMaxValue(int axis) {
        return this.gs[N1][N2].getMaxValue(axis);
    }

    public void setMaxValue(int axis, double max) {
        this.gs[N1][N2].setMaxValue(axis, max);
    }

    public Font getLegendFont() {
        return this.gs[N1][N2].getLegendFont();
    }

    public void setLegend(boolean b) {
        this.gs[N1][N2].setDrawLegend(b);
    }

    public void setLegendPos(int axis, double coordinate) {
        this.gs[N1][N2].setLegendPosition(axis, coordinate);
    }

    public void setLegendPos(double x, double y, String system) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        double h = panel.height;
        double ix = w * x;
        double iy = h * (1.0 - y);
        if (system.equals("USER")) {
            ix = this.toX(x);
            iy = this.toY(y);
        }
        this.gs[N1][N2].setUseLegendPosition(true);
        this.gs[N1][N2].setLegendPosition(ix, iy);
    }

    public boolean getLegendPosUse() {
        return this.gs[N1][N2].useLegendPosition();
    }

    public void setLegendPosUse(boolean b) {
        this.gs[N1][N2].setUseLegendPosition(b);
    }

    public double getLegendSpacing() {
        return this.gs[N1][N2].getLegendSpacing();
    }

    public void setLegendSpac(double dy) {
        this.gs[N1][N2].setLegendSpacing(dy);
    }

    public double getLegendPos(int axis) {
        return this.gs[N1][N2].getLegendPosition(axis);
    }

    public void setLogScale(int axis, boolean b) {
        this.gs[N1][N2].setUseLogScale(axis, b);
    }

    public void setTicsMirror(int axis, boolean b) {
        this.gs[N1][N2].setDrawMirrorTics(axis, b);
    }

    public void setTicsMirror(boolean b) {
        this.gs[N1][N2].setDrawMirrorTics(0, b);
        this.gs[N1][N2].setDrawMirrorTics(1, b);
    }

    public boolean getTicsMirror(int axis) {
        return this.gs[N1][N2].drawMirrorTics(axis);
    }

    public void setTicsRotate(int axis, boolean b) {
        this.gs[N1][N2].setRotateTics(axis, b);
    }

    public boolean getTicsRotate(int axis) {
        return this.gs[N1][N2].rotateTics(axis);
    }

    public void setShadow(boolean b) {
        this.gs[N1][N2].setShadow(b);
    }

    public boolean getShadow() {
        return this.gs[N1][N2].drawShadow();
    }

    public void setGrid(int axis, boolean b) {
        this.gs[N1][N2].setDrawGrid(axis, b);
    }

    public void setGrid(boolean b) {
        this.gs[N1][N2].setDrawGrid(0, b);
        this.gs[N1][N2].setDrawGrid(1, b);
    }

    public void setGridAll(int axis, boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setDrawGrid(axis, b);
            }
        }
    }

    public void setGridColorAll(Color c) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setGridColor(c);
            }
        }
    }

    public Color getGridColor() {
        return this.gs[N1][N2].getGridColor();
    }

    public Color getInnerColor() {
        return this.gs[N1][N2].getInnerColor();
    }

    public void setInnerColor(Color c) {
        this.gs[N1][N2].setInnerColor(c);
    }

    public void setGridToFront(boolean b) {
        this.gs[N1][N2].setGridToFront(b);
    }

    public boolean isGridToFront() {
        return this.gs[N1][N2].gridToFront();
    }

    public void setPrimitivesToFront(boolean b) {
        this.gs[N1][N2].setPrimitivesToFront(b);
    }

    public boolean isPrimitivesToFront() {
        return this.gs[N1][N2].primitivesToFront();
    }

    public void setBox(boolean b) {
        this.gs[N1][N2].setDrawBox(b);
    }

    public void setBoxOffset(double f) {
        this.gs[N1][N2].setBoxOffset((float)f);
    }

    public float getBoxOffset() {
        return this.gs[N1][N2].getBoxOffset();
    }

    public void setBoxFillColor(Color c) {
        this.gs[N1][N2].setBoxFillColor(c);
    }

    public Color getBoxFillColor() {
        return this.gs[N1][N2].getBoxFillColor();
    }

    public Color getBoxColor() {
        return this.gs[N1][N2].getBoxColor();
    }

    public void setBoxColor(Color c) {
        this.gs[N1][N2].setBoxColor(c);
    }

    public Color getBackgColor() {
        return this.gs[N1][N2].getBackgroundColor();
    }

    public void setBackgColor(Color color) {
        this.gs[N1][N2].setBackgroundColor(color);
    }

    public void setBackgColorGraph(Color c) {
        this.gs[N1][N2].setGraphBackgroundColor(c);
    }

    public void setBackgColorForAllGraph(Color c) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setGraphBackgroundColor(c);
            }
        }
    }

    public Color getBackgColorGraph() {
        return this.gs[N1][N2].getGraphBackgroundColor();
    }

    public GraphSettings getGraphSettings(int n1, int n2) {
        return this.gs[n1][n2];
    }

    public void setGraphSettings(GraphSettings ggs) {
        this.gs[HPlot.N1][HPlot.N2] = ggs;
        this.jp[N1][N2].setGraphSettings(ggs);
    }

    public GraphSettings getGraphSettings() {
        return this.gs[N1][N2];
    }

    public JPlot getJPlot(int n1, int n2) {
        return this.jp[n1][n1];
    }

    public JPlot getJPlot() {
        return this.jp[N1][N2];
    }

    public void setNameX(String s) {
        this.setNameX(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setNameX(String s, Font f) {
        this.setNameX(s, f, Color.black);
    }

    public void setNameXpos(double x, double y, String system) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        double h = panel.height;
        int ix = (int)(w * x);
        int iy = (int)(h * (1.0 - y));
        if (system.equals("USER")) {
            ix = this.toX(x);
            iy = this.toY(y);
        }
        Vector<GraphLabel> labels = this.gs[N1][N2].getLabels();
        Enumeration<GraphLabel> e = labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.getID() != 0) continue;
            gl.setLocation(ix, iy);
            gl.setUsePosition(true);
            break;
        }
    }

    public void setNameYpos(double x, double y, String system) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        double h = panel.height;
        int ix = (int)(w * x);
        int iy = (int)(h * (1.0 - y));
        if (system.equals("USER")) {
            ix = this.toX(x);
            iy = this.toY(y);
        }
        Vector<GraphLabel> labels = this.gs[N1][N2].getLabels();
        Enumeration<GraphLabel> e = labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.getID() != 1) continue;
            gl.setLocation(ix, iy);
            gl.setUsePosition(true);
            break;
        }
    }

    public void setNameXpos(double x, double y) {
        this.setNameXpos(x, y, "NDC");
    }

    public void setNameYpos(double x, double y) {
        this.setNameYpos(x, y, "NDC");
    }

    public void setNameY(String s) {
        this.setNameY(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setNameY(String s, Font f) {
        this.setNameY(s, f, Color.black);
    }

    public void setNameY(String s, Font f, Color c) {
        GraphLabel label = new GraphLabel(1, s, f, c);
        label.setRotation(4.71238898038469);
        this.gs[N1][N2].addLabel(label);
    }

    public void setName(String name) {
        GraphLabel label = new GraphLabel(2, name, new Font("Arial", 1, 18), Color.black);
        this.gs[N1][N2].addLabel(label);
    }

    public void setName(String s, Font f, Color c) {
        GraphLabel label = new GraphLabel(2, s, f, c);
        this.gs[N1][N2].addLabel(label);
    }

    public void setName(String s, Font f) {
        this.setName(s, f, Color.black);
    }

    public void setNamePos(double x, double y, String system) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        double h = panel.height;
        int ix = (int)(w * x);
        int iy = (int)(h * (1.0 - y));
        if (system.equals("USER")) {
            ix = this.toX(x);
            iy = this.toY(y);
        }
        Vector<GraphLabel> labels = this.gs[N1][N2].getLabels();
        Enumeration<GraphLabel> e = labels.elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = e.nextElement();
            if (gl.getID() != 2) continue;
            gl.setLocation(ix, iy);
            gl.setUsePosition(true);
            break;
        }
    }

    public void setNamePos(double x, double y) {
        this.setNamePos(x, y, "NDC");
    }

    public void removeLabels() {
        this.gs[N1][N2].removeLabels();
    }

    public void removeAxes() {
        this.setAxisAll(false);
        this.setTics(0, false);
        this.setTics(1, false);
        this.setTicLabels(0, false);
        this.setTicLabels(1, false);
        this.setAxisMirror(0, false);
        this.setAxisMirror(1, false);
        this.setTicsMirror(0, false);
        this.setTicsMirror(1, false);
    }

    public void removeLabel(int i) {
        this.gs[N1][N2].removeLabel(i);
    }

    public int numberLabels() {
        return this.gs[N1][N2].numberLabels();
    }

    public void removeLabelsAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].removeLabels();
            }
        }
    }

    public void removePrimitives() {
        this.gs[N1][N2].removePrimitives();
    }

    public void removePrimitives(int i) {
        this.gs[N1][N2].removePrimitive(i);
    }

    public int numberPrimitives() {
        return this.gs[N1][N2].numberPrimitives();
    }

    public void removePrimitivesAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].removePrimitives();
            }
        }
    }

    public double axisLengthX() {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double tmp = (double)panel.width - this.gs[N1][N2].getLeftMargin() - this.gs[N1][N2].getRightMargin();
        return tmp;
    }

    public double axisLengthY() {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double tmp = (double)panel.height - this.gs[N1][N2].getTopMargin() - this.gs[N1][N2].getBottomMargin();
        return tmp;
    }

    public int toX(double x) {
        double d = this.gs[N1][N2].useLogScale(0) ? Math.log10(x / this.gs[N1][N2].getMinValue(0)) : x - this.gs[N1][N2].getMinValue(0);
        double min = this.gs[N1][N2].getMinValue(0);
        double max = this.gs[N1][N2].getMaxValue(0);
        if (this.gs[N1][N2].useLogScale(0)) {
            min = Math.log10(min);
            max = Math.log10(max);
        }
        double diff = Math.abs(min - max);
        double inv = min < max ? 1.0 : -1.0;
        int tmp = (int)(this.gs[N1][N2].getLeftMargin() + inv * d * this.axisLengthX() / diff);
        return tmp;
    }

    public int toY(double y) {
        double d = this.gs[N1][N2].useLogScale(1) ? Math.log10(y / this.gs[N1][N2].getMinValue(1)) : y - this.gs[N1][N2].getMinValue(1);
        double min = this.gs[N1][N2].getMinValue(1);
        double max = this.gs[N1][N2].getMaxValue(1);
        if (this.gs[N1][N2].useLogScale(1)) {
            min = Math.log10(min);
            max = Math.log10(max);
        }
        double diff = Math.abs(min - max);
        double inv = min < max ? 1.0 : -1.0;
        int tmp = (int)(this.gs[N1][N2].getTopMargin() + this.axisLengthY() * (1.0 - inv * d / diff));
        return tmp;
    }

    public void add(HLabel label) {
        double y;
        double x;
        GraphLabel glabel = label.getGraphLabel();
        glabel.setUsePosition(false);
        if (label.getPositionCoordinate() == 2) {
            x = label.getX();
            y = label.getY();
            glabel.setLocation((double)this.toX(x) + glabel.getTextHeight(), (double)this.toY(y) - glabel.getTextHeight());
            glabel.setUsePosition(true);
            glabel.setUseDataPosition(true);
        }
        if (label.getPositionCoordinate() == 1) {
            x = label.getX();
            y = label.getY();
            Dimension panel = this.gs[N1][N2].getPanelSize();
            double w = panel.width;
            double h = panel.height;
            int ix = (int)(w * x);
            int iy = (int)(h * (1.0 - y));
            glabel.setLocation((double)ix + glabel.getTextHeight(), (double)iy - glabel.getTextHeight());
            glabel.setUsePosition(true);
            glabel.setUseDataPosition(false);
        }
        this.gs[N1][N2].addLabel(glabel);
    }

    public void add(HKey label) {
        GraphLabel glabel = label.getGraphLabel();
        glabel.setUsePosition(false);
        double x = label.getX();
        double y = label.getY();
        if (label.getPositionCoordinate() == 2) {
            glabel.setLocation((double)this.toX(x) + glabel.getTextHeight(), (double)this.toY(y) - glabel.getTextHeight());
            glabel.setUsePosition(true);
        }
        if (label.getPositionCoordinate() == 1) {
            if (label.isDefaultPosition()) {
                y -= (double)(label.getSeparation() * (float)this.hkeyCounter[N1][N2]);
            }
            Dimension panel = this.gs[N1][N2].getPanelSize();
            double w = panel.width;
            double h = panel.height;
            int ix = (int)(w * x);
            int iy = (int)(h * (1.0 - y));
            glabel.setLocation((double)ix + glabel.getTextHeight(), (double)iy - glabel.getTextHeight());
            glabel.setUsePosition(true);
        }
        this.gs[N1][N2].addLabel(glabel);
        int[] nArray = this.hkeyCounter[N1];
        int n = N2;
        nArray[n] = nArray[n] + 1;
    }

    public void add(HMLabel label) {
        double y;
        double x;
        GraphLabel glabel = label.getGraphLabel();
        glabel.setUsePosition(false);
        if (label.getPositionCoordinate() == 2) {
            x = label.getX();
            y = label.getY();
            glabel.setLocation((double)this.toX(x) + glabel.getTextHeight(), this.toY(y));
            glabel.setUsePosition(true);
        }
        if (label.getPositionCoordinate() == 1) {
            x = label.getX();
            y = label.getY();
            Dimension panel = this.gs[N1][N2].getPanelSize();
            double w = panel.width;
            double h = panel.height;
            int ix = (int)(w * x);
            int iy = (int)(h * (1.0 - y));
            glabel.setLocation((double)ix + glabel.getTextHeight(), iy);
            glabel.setUsePosition(true);
        }
        this.gs[N1][N2].addLabel(glabel);
    }

    public void draw(HLabel label) {
        this.add(label);
        this.update();
    }

    public void draw(HKey label) {
        this.add(label);
        this.update();
    }

    public void add(HLabelEq ob) {
        BufferedImage img = ob.getImage();
        Picture p = new Picture(ob.getX(), ob.getY(), img);
        p.setPositionCoordinate(ob.getPositionCoordinate());
        this.gs[N1][N2].addPrimitive(p);
    }

    public void draw(HLabelEq ob) {
        this.add(ob);
        this.update();
    }

    public void add(HShape ob) {
        this.gs[N1][N2].addPrimitive(ob);
    }

    public void draw(HShape ob) {
        this.add(ob);
        this.update();
    }

    public void draw(HMLabel ob) {
        this.add(ob);
        this.update();
    }

    public Color getAxesColor() {
        return this.gs[N1][N2].getAxesColor();
    }

    public void setAxesColor(Color color) {
        this.gs[N1][N2].setAxesColor(color);
    }

    public Font getTicFont(int axis) {
        return this.gs[N1][N2].getTicFont(axis);
    }

    public void setTicFont(int axis, Font font) {
        this.gs[N1][N2].setTicFont(axis, font);
    }

    public void setTicFont(Font font) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setTicFont(0, font);
                this.gs[i1][i2].setTicFont(1, font);
            }
        }
    }

    public Color getTicColor(int axis) {
        return this.gs[N1][N2].getTicColor(axis);
    }

    public void setTicColor(int axis, Color color) {
        this.gs[N1][N2].setTicColor(axis, color);
    }

    public void setTicColor(Color color) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setTicColor(0, color);
                this.gs[i1][i2].setTicColor(1, color);
            }
        }
    }

    public boolean isAxisShown(int axis) {
        return this.gs[N1][N2].drawAxis(axis);
    }

    public void setAxis(int axis, boolean b) {
        this.gs[N1][N2].setDrawAxis(axis, b);
    }

    public void setAxisX() {
        this.setAxis(0, true);
        this.setAxisMirror(0, false);
        this.setTicLabels(0, true);
        this.setTicsMirror(0, false);
        this.setTics(0, true);
        this.setTicsMirror(0, false);
    }

    public void setAxisY() {
        this.setAxis(1, true);
        this.setAxisMirror(1, false);
        this.setTicLabels(1, true);
        this.setTicsMirror(1, false);
        this.setTics(1, true);
        this.setTicsMirror(1, false);
    }

    public void setAxisAll(boolean b) {
        this.gs[N1][N2].setDrawAxis(0, b);
        this.gs[N1][N2].setDrawAxis(1, b);
    }

    public void setAxisPenTicWidth(int penWidth) {
        this.gs[N1][N2].setAxesPenTicWidth(penWidth);
    }

    public int getAxisPenTicWidth() {
        return (int)this.gs[N1][N2].getAxesPenTicWidth();
    }

    public boolean isMirrorAxisShown(int axis) {
        return this.gs[N1][N2].drawMirrorAxis(axis);
    }

    public void setAxisMirror(int axis, boolean b) {
        this.gs[N1][N2].setDrawMirrorAxis(axis, b);
    }

    public boolean isTicLabelsShown(int axis) {
        return this.gs[N1][N2].drawTicLabels(axis);
    }

    public void setTicLabels(boolean b) {
        this.gs[N1][N2].setDrawTicLabels(b);
    }

    public void setTicLabels(int axis, boolean b) {
        this.gs[N1][N2].setDrawTicLabels(axis, b);
    }

    public boolean isTicsShown(int axis) {
        return this.gs[N1][N2].drawTics(axis);
    }

    public void resetStyle() {
        this.gs[N1][N2].reset();
    }

    public void resetStyleAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].reset();
            }
        }
    }

    public void clear() {
        this.clear(N1, N2);
    }

    public void clear(int i1, int i2) {
        this.setGTitle("");
        this.data[i1][i2].clear();
        this.gs[i1][i2].reset();
        this.jp[i1][i2].clearData();
        this.jp[i1][i2].dismissGraph();
        this.jp[i1][i2].clear();
        System.gc();
    }

    public void clearData() {
        this.clearData(N1, N2);
    }

    public void clearLabels() {
        this.clearLabels(N1, N2);
    }

    public void clearLabels(int i1, int i2) {
        this.gs[i1][i2].getLabels().clear();
        this.jp[i1][i2].updateGraphIfShowing();
        this.updateFrame();
    }

    public void clearData(int i1, int i2) {
        IndexPlot = 0;
        this.data[i1][i2].clear();
        this.jp[i1][i2].clearData();
        this.jp[i1][i2].updateGraphIfShowing();
        this.updateFrame();
    }

    public void clearAllData() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clearData(i1, i2);
            }
        }
    }

    public void clearAllLabels() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clearLabels(i1, i2);
            }
        }
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    public void setTics(int axis, boolean b) {
        this.gs[N1][N2].setDrawTics(axis, b);
    }

    public void setTics(boolean b) {
        this.gs[N1][N2].setDrawTics(0, b);
        this.gs[N1][N2].setDrawTics(1, b);
    }

    public void setRange(int axis, double min, double max) {
        this.gs[N1][N2].setRange(axis, min, max);
        this.gs[N1][N2].setAutoRange(axis, false);
        if (axis == 0) {
            this.gs[N1][N2].setAutoRange(1, true);
        }
    }

    public void setRangeX(double min, double max) {
        this.gs[N1][N2].setRange(0, min, max);
        this.gs[N1][N2].setAutoRange(0, false);
        this.gs[N1][N2].setAutoRange(1, true);
    }

    public void setRangeY(double min, double max) {
        this.gs[N1][N2].setRange(1, min, max);
        this.gs[N1][N2].setAutoRange(1, false);
        this.gs[N1][N2].setAutoRange(0, true);
    }

    public void setRangeAll(int axis, double min, double max) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setRange(axis, min, max);
                this.gs[i1][i2].setAutoRange(axis, false);
            }
        }
    }

    public void setRange(double minX, double maxX, double minY, double maxY) {
        this.gs[N1][N2].setRange(0, minX, maxX);
        this.gs[N1][N2].setRange(1, minY, maxY);
        this.gs[N1][N2].setAutoRange(0, false);
        this.gs[N1][N2].setAutoRange(1, false);
    }

    public void setRangeAll(double minX, double maxX, double minY, double maxY) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setRange(0, minX, maxX);
                this.gs[i1][i2].setRange(1, minY, maxY);
                this.gs[i1][i2].setAutoRange(0, false);
                this.gs[i1][i2].setAutoRange(1, false);
            }
        }
    }

    public void setAutoRange(int axis, boolean b) {
        this.gs[N1][N2].setAutoRange(axis, b);
    }

    public void setAutoRangeAll(int axis, boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setAutoRange(axis, b);
            }
        }
    }

    public void setAutoRange(boolean b) {
        this.gs[N1][N2].setAutoRange(0, b);
        this.gs[N1][N2].setAutoRange(1, b);
    }

    public void setAutoRangeAll(boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setAutoRange(0, b);
                this.gs[i1][i2].setAutoRange(1, b);
            }
        }
    }

    public void setAutoRange() {
        this.gs[N1][N2].setAutoRange(0, true);
        this.gs[N1][N2].setAutoRange(1, true);
    }

    public void setAutoRangeAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.gs[i1][i2].setAutoRange(0, true);
                this.gs[i1][i2].setAutoRange(1, true);
            }
        }
    }

    public void drawStatBox(H1D h1) {
        String name = h1.getTitle();
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        double h = panel.height;
        GraphLabel label0 = new GraphLabel(12, name);
        label0.setUsePosition(true);
        label0.setText(h1.getStatParameters());
        double xtop = this.gs[N1][N2].getTopMargin() + 0.4 * label0.getHeight();
        label0.setLocation(w - this.gs[N1][N2].getRightMargin() - 0.8 * label0.getWidth(), xtop);
        this.gs[N1][N2].addLabel(label0);
    }

    public void drawStatBox(H1D h1, int x, int y) {
        double mean = h1.mean();
        double rms = h1.rms();
        DecimalFormat dfb = new DecimalFormat("##.###E00");
        String name = h1.getTitle();
        String sentries = "Entries =" + Integer.toString(h1.entries());
        String smean = "Mean  =" + dfb.format(mean);
        String srms = "RMS =" + dfb.format(rms);
        String extra = "Under/Overflow =" + Integer.toString(h1.extraEntries());
        GraphLabel label0 = new GraphLabel(12, name);
        label0.setUsePosition(true);
        String[] s = new String[]{name, sentries, smean, srms, extra};
        label0.setText(s);
        label0.setLocation(x, y);
        this.gs[N1][N2].addLabel(label0);
    }

    public void drawStatBox(H1D h1, double x, double y, String howToSet) {
        if (howToSet.equalsIgnoreCase("USER")) {
            this.drawStatBox(h1, this.toX(x), this.toY(y));
        } else if (howToSet.equalsIgnoreCase("NDC")) {
            Dimension panel = this.gs[N1][N2].getPanelSize();
            double w = panel.width;
            double h = panel.height;
            int ix = (int)(w * x);
            int iy = (int)(h * (1.0 - y));
            this.drawStatBox(h1, ix, iy);
        }
    }

    public void drawTextBox(String[] lines) {
        Dimension panel = this.gs[N1][N2].getPanelSize();
        double w = panel.width;
        GraphLabel label0 = new GraphLabel(12, "");
        label0.setUsePosition(true);
        label0.setText(lines);
        double xtop = this.gs[N1][N2].getTopMargin() + 0.5 * label0.getHeight();
        label0.setLocation(w - 2.0 * this.gs[N1][N2].getRightMargin() - label0.getWidth(), xtop);
        this.gs[N1][N2].addLabel(label0);
    }

    public void clearData(int i) {
        this.jp[N1][N2].clearData(i);
    }

    public int sizeData() {
        return this.jp[N1][N2].sizeData();
    }

    public void setDataPers(DataArray data) {
        String name = data.getName();
        String s = "jplot3d" + this.lf;
        s = s + name;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(s));
            out.write("# column 1: X");
            out.newLine();
            out.write("# column 2: ");
            out.write(name);
            out.newLine();
            for (int i = 0; i < data.size(); ++i) {
                out.write(Double.toString(data.getX(i)));
                out.write(" ");
                out.write(Double.toString(data.getY(i)));
                out.newLine();
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JHPlot.ReadFile = true;
    }

    public void draw(H1D[] h1) {
        for (int i = 0; i < h1.length; ++i) {
            this.draw(h1[i]);
        }
    }

    public void draw(Cloud1D c1d) {
        this.draw(new H1D(c1d, 100));
    }

    public void draw(DataPointSet ds) {
        this.draw(new P1D((IDataPointSet)ds));
    }

    public void draw(Cloud2D c2d) {
        this.draw(new P1D(c2d));
    }

    public void draw(Histogram1D h1d) {
        H1D h1 = new H1D(h1d);
        this.draw(h1);
    }

    public void draw(H1D h1) {
        if (h1.getLabelX() != null && h1.getLabelX().length() > 0) {
            this.setNameX(h1.getLabelX());
        }
        if (h1.getLabelY() != null && h1.getLabelY().length() > 0) {
            this.setNameY(h1.getLabelY());
        }
        h1.setType(101);
        this.gs[N1][N2].setGraphType(0);
        this.gs[N1][N2].set2DType(1);
        Histogram1D h = h1.get();
        IAxis ax = h.axis();
        int Bin = ax.bins();
        DataArray data1 = new DataArray(++IndexPlot, 1, Bin, h1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            double dd = ax.binCenter(i);
            double hh = h1.binHeight(i);
            double errX1 = dd - ax.binLowerEdge(i);
            double errX2 = ax.binUpperEdge(i) - dd;
            double errY = h.binError(i);
            data1.addPoint(dd, hh, errX1, errX2, errY, errY);
        }
        data1.setDimension(6);
        data1.setLinePars(h1.getDrawOption());
        data1.setName(h1.getTitle());
        JHPlot.ReadFile = false;
        this.data[N1][N2].add(data1);
        this.jp[N1][N2].insertData(IndexPlot, data1);
    }

    public int fit(H1D h1, String predefFunc, String method) {
        if (this.m_IFunctionFactory == null || this.m_IAnalysisFactory == null) {
            this.m_IAnalysisFactory = IAnalysisFactory.create();
            this.m_ITree = this.m_IAnalysisFactory.createTreeFactory().create();
            this.m_IHistogramFactory = this.m_IAnalysisFactory.createHistogramFactory(this.m_ITree);
            this.m_IFitFactory = this.m_IAnalysisFactory.createFitFactory();
            this.m_IFunctionFactory = this.m_IAnalysisFactory.createFunctionFactory(this.m_ITree);
        }
        IFunction fitfunc = this.m_IFunctionFactory.createFunctionByName("Gaussian", "G");
        IFitter fitter = this.m_IFitFactory.createFitter("chi2", "jminuit");
        IFitResult result = fitter.fit((IBaseHistogram)h1.get(), fitfunc);
        IFunction fresult = result.fittedFunction();
        double[] fPars = result.fittedParameters();
        double[] fParErrs = result.errors();
        String[] fParNames = result.fittedParameterNames();
        for (int i = 0; i < fresult.numberOfParameters(); ++i) {
            System.out.println(fParNames[i] + " : " + fPars[i] + " +- " + fParErrs[i]);
        }
        return result.fitStatus();
    }

    public void draw(F1D[] f) {
        for (int i = 0; i < f.length; ++i) {
            this.draw(f[i]);
        }
    }

    public void draw(DataArray inputDA, int index) {
        JHPlot.ReadFile = false;
        this.data[N1][N2].add(inputDA);
        this.jp[N1][N2].insertData(++IndexPlot, inputDA);
    }

    public boolean draw(F1D f1) {
        return this.draw(f1, false);
    }

    public boolean draw(F1D f1, double min, double max) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        f1.setType(102);
        f1.setMin(min);
        f1.setMax(max);
        this.gs[N1][N2].setRange(0, min, max);
        this.gs[N1][N2].setAutoRange(0, false);
        this.gs[N1][N2].setAutoRange(1, true);
        f1.eval(this.getMinValue(0), this.getMaxValue(0), f1.getPoints());
        this.gs[N1][N2].setGraphType(0);
        this.gs[N1][N2].set2DType(0);
        int Bin = f1.getPoints();
        f1.setGraphStyle(0);
        f1.setDrawSymbol(false);
        f1.setDrawLine(true);
        DataArray data1 = new DataArray(++IndexPlot, 1, Bin, f1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            data1.addPoint(f1.getX(i), f1.getY(i));
        }
        data1.setDimension(2);
        data1.setName(f1.getTitle());
        JHPlot.ReadFile = false;
        this.data[N1][N2].add(data1);
        this.jp[N1][N2].insertData(IndexPlot, data1);
        return true;
    }

    public boolean draw(FND f1) {
        return this.draw(f1, false);
    }

    public boolean draw(F1D f1, boolean startZero) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        f1.setType(102);
        if (f1.getMin() == f1.getMax()) {
            f1.eval(this.getMinValue(0), this.getMaxValue(0), f1.getPoints());
        } else {
            f1.eval(f1.getMin(), f1.getMax(), f1.getPoints());
        }
        this.gs[N1][N2].set2DType(1);
        if (!startZero) {
            this.gs[N1][N2].setGraphType(0);
            this.gs[N1][N2].set2DType(0);
        }
        int Bin = f1.getPoints();
        f1.setGraphStyle(0);
        f1.setDrawSymbol(false);
        f1.setDrawLine(true);
        DataArray data1 = new DataArray(++IndexPlot, 1, Bin, f1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            data1.addPoint(f1.getX(i), f1.getY(i));
        }
        data1.setDimension(2);
        data1.setName(f1.getTitle());
        JHPlot.ReadFile = false;
        this.data[N1][N2].add(data1);
        this.jp[N1][N2].insertData(IndexPlot, data1);
        return true;
    }

    public boolean draw(FND f1, boolean startZero) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        if (!f1.isEvaluated()) {
            System.out.println("The function is not avaluated yet!");
            return false;
        }
        f1.setType(102);
        this.gs[N1][N2].set2DType(1);
        if (!startZero) {
            this.gs[N1][N2].setGraphType(0);
            this.gs[N1][N2].set2DType(0);
        }
        int Bin = f1.getPoints();
        f1.setGraphStyle(0);
        f1.setDrawSymbol(false);
        f1.setDrawLine(true);
        DataArray data1 = new DataArray(++IndexPlot, 1, Bin, f1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            data1.addPoint(f1.getX(i), f1.getY(i));
        }
        data1.setDimension(2);
        data1.setName(f1.getTitle() + "; " + f1.getFixedVars());
        JHPlot.ReadFile = false;
        this.data[N1][N2].add(data1);
        this.jp[N1][N2].insertData(IndexPlot, data1);
        return true;
    }

    public Vector<DataArray>[][] getData() {
        return this.data;
    }

    public void close() {
        isOpen = 0;
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    protected int isOpen() {
        return isOpen;
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAllData();
        this.clearAll();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.data[i1][i2].clear();
                this.data[i1][i2] = null;
                this.jp[i1][i2].quit();
                this.jp[i1][i2] = null;
                this.frames[i1][i2].dispose();
                this.frames[i1][i2] = null;
            }
        }
        this.gs = null;
        this.jp = null;
        this.graph = null;
        this.data = null;
        this.sc = null;
        this.frames = null;
        this.removeFrame();
    }

    public void removeGraph() {
        int i1;
        int i2;
        this.resetMargins();
        for (i2 = 0; i2 < this.N2final; ++i2) {
            for (i1 = 0; i1 < this.N1final; ++i1) {
                this.mainPanel.remove(this.graph[i1][i2]);
            }
        }
        this.clearAllData();
        this.clearAll();
        for (i2 = 0; i2 < this.N2final; ++i2) {
            for (i1 = 0; i1 < this.N1final; ++i1) {
                this.frames[i1][i2].dispose();
                this.frames[i1][i2] = null;
                this.graph[i1][i2] = null;
            }
        }
        this.gs = null;
        this.jp = null;
        this.graph = null;
        this.data = null;
        this.sc = null;
        this.frames = null;
        this.N1final = 0;
        this.N2final = 0;
        System.gc();
    }

    public void draw(P1D[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.draw(d[i]);
        }
    }

    public void draw(P1D d) {
        ++IndexPlot;
        JHPlot.ReadFile = false;
        if (d.getLabelX() != null && d.getLabelX().length() > 0) {
            this.setNameX(d.getLabelX());
        }
        if (d.getLabelY() != null && d.getLabelY().length() > 0) {
            this.setNameY(d.getLabelY());
        }
        d.setType(103);
        d.setGraphStyle(0);
        if (this.plotType[N1][N2] == 4) {
            d.setGraphStyle(2);
        }
        DataArray tmp = d.getDataArray();
        tmp.setDimension(d.dimension());
        tmp.setLinePars(d.getDrawOption());
        tmp.setName(d.getTitle());
        this.data[N1][N2].add(tmp);
        this.jp[N1][N2].insertData(IndexPlot, tmp);
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    @Override
    protected void showHelp() {
        new HelpDialog((Component)this.getFrame(), "hplot.html");
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void openReadDataDialog() {
        JFileChooser fileChooser = CommonGUI.openDataFileChooser(this.getFrame());
        int ret = fileChooser.showDialog(this.getFrame(), "Open Data file");
        if (ret == 0) {
            new BrowserData(fileChooser.getSelectedFile().getAbsolutePath(), this);
        }
    }

    @Override
    protected void openWriteDialog() {
        JFrame frm = this.getFrame();
        JFileChooser chooser = new JFileChooser(new File("."));
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".jhp");
            }
        };
        if (chooser.showDialog(frm, "Save As") == 0) {
            int res;
            final File scriptFile = chooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(frm, "The file exist: do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write JHPlot XML file";
            JHPlot.showStatusBarText(mess);
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    boolean res = HPlot.this.writeScript(scriptFile);
                }
            };
            t.start();
        }
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HPlot.this.quit();
        }
    }

    private class NotShowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        NotShowAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HPlot.this.frames[HPlot.this.N1edit][HPlot.this.N2edit].setVisible(false);
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
            super("Data reload");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HPlot.this.update(HPlot.this.N1edit, HPlot.this.N2edit);
        }
    }
}

