/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Component;
import java.io.IOException;
import jhplot.gui.HelpBrowser;
import medusa.DataFormatException;
import medusa.MedusaSimplerFrame;
import medusa.display.EditableGraphPanel;
import medusa.georgios.Layouts.Layouts;
import medusa.graph.Graph;

public class HMedusa {
    private static final long serialVersionUID = 1L;
    private MedusaSimplerFrame frame = new MedusaSimplerFrame();
    private EditableGraphPanel stringletPanel = this.frame.getPanel();

    public HMedusa() {
        this.frame.setDefaultCloseOperation(2);
    }

    public void visible(boolean vs) {
        this.frame.setVisible(vs);
        if (!vs) {
            this.frame.validate();
        }
    }

    public void visible() {
        this.frame.setVisible(true);
    }

    public void quit() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void clear() {
        this.stringletPanel.clearGraph();
        this.update();
    }

    public void update() {
        this.stringletPanel.repaint();
        this.frame.updateInfo();
    }

    public void add(Graph g) {
        this.frame.hide_starting_background();
        this.frame.clearImageEvent();
        this.frame.scaleOut();
        Layouts.Apply_Random_Coordinates((Graph)g, (Component)this.stringletPanel);
        this.frame.setCursor(null);
        this.stringletPanel.setGraph(g);
        this.frame.updateInfo();
        this.stringletPanel.repaint();
    }

    public void setGraph(Graph g) {
        this.add(g);
    }

    public Graph getGraph() {
        return this.stringletPanel.getGraph();
    }

    public MedusaSimplerFrame getFrame() {
        return this.frame;
    }

    public EditableGraphPanel getPanel() {
        return this.stringletPanel;
    }

    public void loadFile(String file) {
        this.frame.hide_starting_background();
        this.frame.clearImageEvent();
        this.frame.scaleOut();
        try {
            this.stringletPanel.appendGraph(file);
            this.frame.updateInfo();
            this.stringletPanel.repaint();
        }
        catch (IOException | DataFormatException e) {
            e.printStackTrace();
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

