/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import jhplot.gui.HelpBrowser;
import jplot.GraphLabel;

public class HLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected Font font;
    protected Color color;
    protected float transp;
    protected GraphLabel label;
    protected double Xpos;
    protected double Ypos;
    protected int usePosition = 2;

    public HLabel(String s, Font f, Color c) {
        this.label = new GraphLabel(10, s, f, c);
        this.label.setUseDataPosition(true);
        this.text = s;
        this.font = f;
        this.color = c;
        this.transp = 1.0f;
        this.Xpos = 0.0;
        this.Ypos = 0.0;
        this.usePosition = 2;
    }

    public HLabel(String s, Font f) {
        this(s, f, Color.BLACK);
    }

    public HLabel(String s) {
        this(s, new Font("Arial", 1, 14), Color.BLACK);
    }

    public HLabel(String s, double x, double y) {
        this.font = new Font("Arial", 1, 16);
        this.label = new GraphLabel(10, s, this.font, Color.BLACK);
        this.label.setUseDataPosition(true);
        this.usePosition = 2;
        this.Xpos = x;
        this.Ypos = y;
        this.text = s;
    }

    public HLabel(String s, double x, double y, String howToSet) {
        this.font = new Font("Arial", 1, 16);
        this.label = new GraphLabel(10, s, this.font, Color.BLACK);
        this.usePosition = 1;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
            this.label.setUseDataPosition(true);
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            this.label.setUseDataPosition(false);
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
        this.text = s;
    }

    public void setText(String s) {
        this.text = s;
        this.label.setText(s);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setColor(Color c) {
        this.label.setColor(c);
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font f) {
        this.font = f;
        this.label.setFont(f);
    }

    public Font getFont() {
        return this.font;
    }

    public void setRotation(double r) {
        this.label.setRotation(r);
    }

    public double getRotation() {
        return this.label.getRotation();
    }

    public void setLocation(double x, double y) {
        this.usePosition = 1;
        this.Xpos = x;
        this.Ypos = y;
    }

    public void setLocation(double x, double y, String howToSet) {
        this.usePosition = 2;
        if (howToSet.equalsIgnoreCase("USER")) {
            this.usePosition = 2;
            this.label.setUseDataPosition(true);
        }
        if (howToSet.equalsIgnoreCase("NDC")) {
            this.usePosition = 1;
            this.label.setUseDataPosition(false);
            if (x > 1.0) {
                x = 1.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            if (x < 0.0) {
                x = 0.0;
            }
            if (y < 0.0) {
                y = 0.0;
            }
        }
        this.Xpos = x;
        this.Ypos = y;
    }

    public int getPositionCoordinate() {
        return this.usePosition;
    }

    public double getX() {
        return this.Xpos;
    }

    public double getY() {
        return this.Ypos;
    }

    public GraphLabel getGraphLabel() {
        return this.label;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

