/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import jhplot.FProxy;
import jhplot.Plottable;
import jhplot.utils.Util;

public class FPR
extends Plottable {
    private static final long serialVersionUID = 1L;
    private Color fillColor;
    private Color lineColor;
    private int penWidth;
    private FProxy proxy;

    public FPR(String title, String name, int divU, int divV) {
        this.proxy = new FProxy(5, title, name, null, new double[]{divU, divV, 0.0, 0.0, 0.0, 0.0}, 0, true);
        this.fillColor = Color.blue;
        this.lineColor = Color.black;
        this.penWidth = 1;
        this.is3D = true;
    }

    public FPR(FProxy f) {
        if (f.getType() != 5) {
            Util.ErrorMessage((String)("Error in parsing FPR. Wrong function type! " + f.getName()));
            return;
        }
        this.proxy = f;
        String name = this.proxy.getName();
        this.setTitle(this.proxy.getTitle());
        this.fillColor = Color.blue;
        this.lineColor = Color.black;
        this.penWidth = 1;
        this.is3D = true;
    }

    public FPR(String name, int divU, int divV) {
        this(name, name, divU, divV);
    }

    public FPR(String name) {
        this(name, 21, 21);
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public String getName() {
        return this.proxy.getName();
    }

    public int getDivU() {
        double[] d = this.proxy.getLimits();
        return (int)d[0];
    }

    public int getDivV() {
        double[] d = this.proxy.getLimits();
        return (int)d[1];
    }

    public void setDivisions(int U, int V) {
        this.proxy.setLimit(0, U);
        this.proxy.setLimit(0, V);
    }

    public void setPenWidth(int penWidth) {
        this.penWidth = penWidth;
    }

    public int getPenWidth() {
        return this.penWidth;
    }

    public void setFilled(boolean isFilled) {
        this.proxy.setParsed(isFilled);
    }

    public boolean isFilled() {
        return this.proxy.isParsed();
    }

    public String toString() {
        String tmp = "FPR:" + this.proxy.getName();
        double[] d = this.proxy.getLimits();
        boolean isFilled = this.proxy.isParsed();
        double Xmin = d[0];
        double Xmax = d[1];
        int points = this.proxy.getPoints();
        tmp = tmp + " (title=" + this.getTitle() + ", n=" + Integer.toString(points) + ", divX=" + Double.toString(Xmin) + ", divY=" + Double.toString(Xmax);
        return tmp;
    }
}

