/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IFunction;
import jhplot.DrawOptions;
import jhplot.FProxy;
import jhplot.H1D;
import jhplot.HTable;
import jhplot.gui.HelpBrowser;
import jhplot.math.Numeric;
import jhplot.math.exp4j.Expression;
import jhplot.math.exp4j.ExpressionBuilder;
import jhplot.utils.Util;

public class F1D
extends DrawOptions {
    private static final long serialVersionUID = 1L;
    private double[] x = null;
    private double[] y = null;
    private Expression calc = null;
    private ExpressionBuilder function = null;
    private String lastException = "";
    final int maxpoints = 500;
    private FProxy proxy;

    public F1D(String name) {
        this(name, name, 0.0, 0.0, true);
    }

    public F1D(FProxy f) {
        if (f.getType() != 1) {
            Util.ErrorMessage((String)("Error in parsing F1D. Wrong type! " + f.getName()));
            return;
        }
        this.proxy = f;
        this.setTitle(this.proxy.getTitle());
        this.lpp.setType(102);
    }

    public F1D(String title, String name) {
        this(title, name, 0.0, 0.0, true);
    }

    public F1D(String title, String name, double min, double max) {
        this(title, name, min, max, true);
    }

    public F1D(String name, double min, double max, boolean parsed) {
        this(name, name, min, max, parsed);
    }

    public F1D(String title, IFunction iname, double min, double max) {
        this.proxy = new FProxy(1, title, iname.title(), iname, new double[]{min, max, 0.0, 0.0, 0.0, 0.0}, 500, false);
        this.setTitle(title);
        this.lpp.setType(102);
    }

    public FProxy get() {
        return this.proxy;
    }

    public F1D(String title, String name, double min, double max, boolean parse) {
        this.proxy = new FProxy(1, title, name, null, new double[]{min, max, 0.0, 0.0, 0.0, 0.0}, 500, parse);
        this.setTitle(title);
        this.lpp.setType(102);
        this.function = new ExpressionBuilder(this.proxy.getName());
        if (parse) {
            try {
                this.function.variables("x");
                this.calc = this.function.build();
            }
            catch (IllegalArgumentException e) {
                this.proxy.setParsed(false);
                Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
            }
        }
    }

    public F1D(IFunction iname, double min, double max) {
        this.proxy = new FProxy(1, iname.title(), iname.title(), iname, new double[]{min, max}, 500, false);
        this.setTitle(iname.title());
        this.lpp.setType(102);
    }

    public F1D(String name, double min, double max) {
        this(name, name, min, max, true);
    }

    public F1D(String title, String name, boolean parsed) {
        this(title, name, 0.0, 0.0, parsed);
    }

    public F1D(String title, double[] pars, boolean parse) {
        if (pars == null || pars.length < 1) {
            System.err.println("Failed to evaluate this polynomial");
        }
        String name = Double.toString(pars[0]);
        this.proxy = new FProxy(1, title, name, null, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 500, parse);
        for (int i = 1; i < pars.length; ++i) {
            String sig = "+";
            if (pars[i] < 0.0) {
                sig = "-";
            }
            double val = Math.abs(pars[i]);
            String X = "*x";
            for (int j = 1; j < i; ++j) {
                X = X + "*x";
            }
            name = name + sig + Double.toString(val) + X;
        }
        this.setTitle(title);
        this.lpp.setType(102);
        this.function = new ExpressionBuilder(name);
        if (parse) {
            try {
                this.calc = this.function.variables("x").build();
            }
            catch (IllegalArgumentException e) {
                this.proxy.setParsed(false);
                Util.ErrorMessage((String)("Failed to parse function " + name + " Error:" + e.toString()));
            }
        }
    }

    public F1D(String name, boolean parse) {
        this(name, name, 999.0, 999.0, parse);
    }

    public boolean parse() {
        try {
            this.function = new ExpressionBuilder(this.proxy.getName());
            this.function.variables("x");
            this.calc = this.function.build();
            this.proxy.setParsed(true);
        }
        catch (IllegalArgumentException e) {
            this.proxy.setParsed(false);
            Util.ErrorMessage((String)("Failed to parse function " + this.proxy.getName() + " Error:" + e.toString()));
            return false;
        }
        return true;
    }

    public F1D(String title, ExpressionBuilder function) {
        this.proxy = new FProxy(1, title, null, null, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 500, false);
        this.function = function;
        this.lpp.setType(102);
        boolean isParsed = this.parse();
        if (!isParsed) {
            Util.ErrorMessage((String)("Failed to parse function " + title));
        }
    }

    public F1D(Expression calc, double min, double max) {
        this("F1D", calc, min, max);
    }

    public F1D(String title, Expression calc, double min, double max) {
        this.proxy = new FProxy(1, title, title, null, new double[]{min, max, 0.0, 0.0, 0.0, 0.0}, 500, true);
        this.calc = calc;
        this.setTitle(title);
        this.lpp.setType(102);
    }

    public F1D(String title, Expression calc) {
        this(title, calc, 0.0, 0.0);
    }

    public F1D(Expression calc) {
        this("F1D", calc, 0.0, 0.0);
    }

    public F1D(ExpressionBuilder function) {
        this("F1D", function);
    }

    public double eval(double x) {
        double y = 0.0;
        IFunction iname = this.proxy.getIFunction();
        if (!(iname != null || this.calc != null && this.proxy.isParsed())) {
            Util.ErrorMessage((String)"eval(): Function was not parsed correctly!");
            return y;
        }
        if (iname == null && this.calc != null && this.proxy.isParsed()) {
            try {
                this.calc.setVariable("x", x);
                y = this.calc.evaluate();
            }
            catch (Exception e) {
                this.lastException = e.getMessage().toString();
                String ss1 = Double.toString(x);
                System.err.println("Failed to evaluate function:" + this.proxy.getName() + " at x=" + ss1 + "\n" + e.toString());
            }
            return y;
        }
        if (iname != null && iname.dimension() == 1) {
            try {
                double[] xx = new double[iname.dimension()];
                xx[0] = x;
                y = iname.value(xx);
            }
            catch (Exception e) {
                this.lastException = e.getMessage().toString();
                String ss1 = Double.toString(x);
                System.err.println("Failed to evaluate function:" + this.proxy.getName() + " at x=" + ss1 + "\n" + e.toString());
            }
            return y;
        }
        return y;
    }

    public double[] eval(double[] x) {
        double[] y = new double[x.length];
        IFunction iname = this.proxy.getIFunction();
        if (!(iname != null || this.calc != null && this.proxy.isParsed())) {
            Util.ErrorMessage((String)"eval(): Function was not parsed correctly!");
            return y;
        }
        if (iname == null && this.calc != null && this.proxy.isParsed()) {
            for (int i = 0; i < x.length; ++i) {
                try {
                    this.calc.setVariable("x", x[i]);
                    y[i] = this.calc.evaluate();
                    continue;
                }
                catch (Exception e) {
                    String ss = Integer.toString(i);
                    this.lastException = e.getMessage().toString() + " at position=" + ss;
                    Util.ErrorMessage((String)("eval(): Failed to evaluate:" + this.proxy.getName() + " at position=" + ss));
                    return null;
                }
            }
            return y;
        }
        if (iname != null) {
            for (int i = 0; i < x.length; ++i) {
                try {
                    double[] xx = new double[iname.dimension()];
                    xx[0] = x[i];
                    y[i] = iname.value(xx);
                    continue;
                }
                catch (Exception e) {
                    String ss = Integer.toString(i);
                    this.lastException = e.getMessage().toString() + " at position=" + ss;
                    Util.ErrorMessage((String)("Failed to evaluate:" + this.proxy.getName() + " at position=" + ss));
                }
            }
            return y;
        }
        return y;
    }

    public void eval(double xMin, double xMax) {
        this.eval(xMin, xMax, 500);
    }

    public void eval() {
        double[] d = this.proxy.getLimits();
        this.eval(d[0], d[1], 500);
    }

    public void eval(double min, double max, int Npoints) {
        int i;
        double d;
        int points = Npoints;
        IFunction iname = this.proxy.getIFunction();
        boolean isParsed = this.proxy.isParsed();
        if (!(iname != null || this.calc != null && isParsed)) {
            Util.ErrorMessage((String)"eval(): Function was not parsed correctly! Not parsed?");
            return;
        }
        if (iname == null && isParsed) {
            this.x = new double[points];
            this.y = new double[points];
            d = (max - min) / (double)(points - 1);
            for (i = 0; i < points; ++i) {
                this.x[i] = min + (double)i * d;
                try {
                    this.calc.setVariable("x", this.x[i]);
                    this.y[i] = this.calc.evaluate();
                    continue;
                }
                catch (Exception e) {
                    String ss = Double.toString(this.x[i]);
                    System.err.println("Failed to evaluate:" + this.proxy.getName() + " at position=" + ss);
                    return;
                }
            }
        }
        if (iname != null) {
            this.x = new double[points];
            this.y = new double[points];
            d = (max - min) / (double)(points - 1);
            for (i = 0; i < points; ++i) {
                this.x[i] = min + (double)i * d;
                double[] xx = new double[iname.dimension()];
                try {
                    xx[0] = this.x[i];
                    this.y[i] = iname.value(xx);
                    continue;
                }
                catch (Exception e) {
                    String ss = Double.toString(this.x[i]);
                    System.err.println("Failed to evaluate at x=" + ss);
                    return;
                }
            }
        }
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public F1D(IFunction iname) {
        this.proxy = new FProxy(1, iname.title(), null, iname, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 500, true);
        this.setTitle(iname.title());
        this.lpp.setType(102);
    }

    public F1D(String title, IFunction iname) {
        this.proxy = new FProxy(1, title, null, iname, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 500, true);
        this.setTitle(title);
        this.lpp.setType(102);
    }

    public void toTable() {
        new HTable(this);
    }

    public void setPar(String parameter, double value) {
        String s1 = Double.toString(value);
        String name = this.proxy.getName();
        this.proxy.setName(name.replaceAll(parameter, s1));
    }

    public H1D getH1D() {
        double[] d = this.proxy.getLimits();
        return this.getH1D(d[0], d[1]);
    }

    public H1D getH1D(double min, double max) {
        int bins = this.getPoints();
        this.eval(min, max, bins);
        H1D h = new H1D(this.getTitle(), bins, min, max);
        int ibins = bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = 0.0;
        newHeights[ibins - 1] = 0.0;
        for (int i = 0; i < ibins - 2; ++i) {
            newHeights[i + 1] = this.y[i];
            newErrors[i + 1] = 0.0;
            newEntries[i + 1] = (int)this.y[i];
            newMeans[i + 1] = this.y[i];
            newRmss[i + 1] = 0.0;
        }
        h.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        h.setMeanAndRms(0.0, 0.0);
        return h;
    }

    public H1D getH1D(String hname, int bins, double hmin, double hmax) {
        double d = (hmax - hmin) / (double)bins;
        double[] xx = new double[bins];
        for (int i = 0; i < bins; ++i) {
            xx[i] = hmin + (double)i * d + 0.5 * d;
        }
        double[] yy = this.eval(xx);
        H1D h = new H1D(hname, bins, hmin, hmax);
        int ibins = bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = 0.0;
        newHeights[ibins - 1] = 0.0;
        for (int i = 0; i < ibins - 2; ++i) {
            newHeights[i + 1] = yy[i];
            newErrors[i + 1] = 0.0;
            newEntries[i + 1] = (int)yy[i];
            newMeans[i + 1] = yy[i];
            newRmss[i + 1] = 0.0;
        }
        h.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        h.setMeanAndRms(0.0, 0.0);
        return h;
    }

    public void setPar(String parameter, int value) {
        String s1 = Integer.toString(value);
        String name = this.proxy.getName();
        this.proxy.setName(name.replaceAll(parameter, s1));
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getY(int i) {
        return this.y[i];
    }

    public void setName(String name) {
        this.proxy.setName(name);
    }

    public String getName() {
        return this.proxy.getName();
    }

    public Expression getParse() {
        return this.calc;
    }

    public void setPoints(int bins) {
        this.proxy.setPoints(bins);
    }

    public double integral() {
        int points = this.proxy.getPoints();
        double[] d = this.proxy.getLimits();
        return this.integral("trapezium", points, d[0], d[1]);
    }

    public double integral(double min, double max) {
        int points = this.proxy.getPoints();
        return this.integral("trapezium", points, min, max);
    }

    public double integral(String type, int N, double min, double max) {
        if (type == "gauss4") {
            return Numeric.gaussian4(N, this, min, max);
        }
        if (type == "gauss8") {
            return Numeric.gaussian8(N, this, min, max);
        }
        if (type == "richardson") {
            return Numeric.richardson(N, this, min, max);
        }
        if (type == "simpson") {
            return Numeric.simpson(N, this, min, max);
        }
        if (type == "trapezium") {
            return Numeric.trapezium(N, this, min, max);
        }
        return Numeric.gaussian4(N, this, min, max);
    }

    public double integral(int N, double min, double max) {
        return Numeric.trapezium(N, this, min, max);
    }

    public IFunction getIFunction() {
        return this.proxy.getIFunction();
    }

    public double[] getArrayX() {
        return this.x;
    }

    public double[] getArrayY() {
        return this.y;
    }

    public boolean isParsed() {
        return this.proxy.isParsed();
    }

    public String toMathML() {
        try {
            return jscl.math.Expression.valueOf((String)this.proxy.getName()).toMathML();
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return "";
        }
    }

    public String toJava() {
        try {
            return jscl.math.Expression.valueOf((String)this.proxy.getName()).toJava();
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return "";
        }
    }

    public boolean simplify() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).simplify().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean elementary() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).elementary().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean expand() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).expand().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean factorize() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).factorize().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public boolean numeric() {
        String name = this.proxy.getName();
        try {
            name = jscl.math.Expression.valueOf((String)name).numeric().toString();
            this.proxy.setName(name);
        }
        catch (Exception e) {
            this.lastException = e.getMessage().toString();
            return false;
        }
        return true;
    }

    public double[] differentiate(int N, double min, double max) {
        return Numeric.differentiate(N, this, min, max);
    }

    public double[] differentiate() {
        int points = this.proxy.getPoints();
        double[] d = this.proxy.getLimits();
        return Numeric.differentiate(points, this, d[0], d[1]);
    }

    public int getPoints() {
        return this.proxy.getPoints();
    }

    public String getException() {
        return this.lastException;
    }

    public void setMin(double min) {
        this.proxy.setLimit(0, min);
    }

    public double getMin() {
        double[] d = this.proxy.getLimits();
        if (d != null) {
            return d[0];
        }
        return 0.0;
    }

    public void setMax(double max) {
        this.proxy.setLimit(1, max);
    }

    public void set(FProxy f) {
        this.proxy = f;
    }

    public double getMax() {
        double[] d = this.proxy.getLimits();
        if (d != null) {
            return d[1];
        }
        return 0.0;
    }

    public String toString() {
        String tmp = "F1D:" + this.proxy.getName();
        tmp = tmp + " (title=" + this.proxy.getTitle() + ", n=" + Integer.toString(this.proxy.getPoints()) + ", " + Boolean.toString(this.proxy.isParsed()) + ")";
        return tmp;
    }
}

