/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Font;
import java.io.PrintStream;
import java.io.Serializable;
import jhplot.Plottable;
import jhplot.utils.Util;
import jplot.LinePars;

public class DrawOptions
extends Plottable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinePars lpp = new LinePars();
    protected Font FontTitle;
    protected int lineStyle;
    protected Font FontAxis;
    protected String symbolshape = "Circle";
    protected String title = "";

    public DrawOptions() {
        this.lpp.setColor(Color.black);
        this.lpp.setPenWidth(2.0f);
        this.lpp.setGraphStyle(1);
        this.lpp.setDrawLegend(true);
        this.lpp.setColorErrorsY(Color.black);
        this.lpp.setColorErrorsX(Color.black);
        this.lpp.errorsY(true);
        this.lpp.errorsX(false);
        this.lpp.setDashLength(0.0f);
        this.lineStyle = 0;
        this.symbolshape = "Circle";
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.lpp.setName(title);
    }

    public LinePars copyLinePars(LinePars old) {
        LinePars lnew = new LinePars();
        lnew.copy(old);
        return lnew;
    }

    @Override
    public String getTitle() {
        String s = this.lpp.getName();
        if (s != null && s.length() > 0) {
            return s;
        }
        return this.title;
    }

    public void setNameX(String name) {
        this.lpp.setNameX(name);
    }

    public String getNameX() {
        return this.lpp.getNameX();
    }

    public void setNameY(String name) {
        this.lpp.setNameY(name);
    }

    public String getNameY() {
        return this.lpp.getNameY();
    }

    public void setNameZ(String name) {
        this.lpp.setNameZ(name);
    }

    public String getNameZ() {
        return this.lpp.getNameZ();
    }

    public LinePars getDrawOption() {
        return this.lpp;
    }

    public void setDrawOption(LinePars lp) {
        this.lpp = lp;
    }

    public void setLegend(boolean b) {
        this.lpp.setDrawLegend(b);
    }

    public boolean getLegend() {
        return this.lpp.drawLegend();
    }

    public void setStyle(String type) {
        if (type.equalsIgnoreCase("l")) {
            this.lpp.setGraphStyle(0);
            this.lpp.setDrawLine(true);
            this.lpp.setDrawSymbol(false);
            return;
        }
        if (type.equalsIgnoreCase("p")) {
            this.lpp.setGraphStyle(0);
            this.lpp.setDrawLine(false);
            this.lpp.setSymbol(4);
            this.lpp.setDrawSymbol(true);
            return;
        }
        if (type.equalsIgnoreCase("h")) {
            this.lpp.setGraphStyle(1);
            this.lpp.setDrawLine(true);
            this.lpp.setDrawSymbol(false);
            return;
        }
        if (type.equalsIgnoreCase("pl") || type.equalsIgnoreCase("lp")) {
            this.lpp.setGraphStyle(0);
            this.lpp.setDrawLine(true);
            this.lpp.setSymbol(4);
            this.lpp.setDrawSymbol(true);
            return;
        }
        Util.ErrorMessage((String)("Option =" + type + " is not defined"));
    }

    public void setFill(boolean cfill) {
        this.lpp.fill(cfill);
    }

    public boolean isFilled() {
        return this.lpp.fill();
    }

    public void setBars(boolean cfill) {
        this.lpp.setShowBars(cfill);
    }

    public boolean isBars() {
        return this.lpp.isBarShown();
    }

    public void setFillColor(Color color) {
        this.lpp.setFillColor(color);
    }

    public Color getFillColor() {
        return this.lpp.getFillColor();
    }

    public void setFillColorTransparency(double ff) {
        this.lpp.setFillColorTransparency((float)ff);
    }

    public void setErrY(boolean sho) {
        this.lpp.errorsY(sho);
    }

    public void setErrSysY(boolean sho) {
        this.lpp.errorsSysY(sho);
    }

    public void setErrSys(boolean sho) {
        this.lpp.errorsSysX(sho);
        this.lpp.errorsSysY(sho);
    }

    public void setErrX(boolean sho) {
        this.lpp.errorsX(sho);
    }

    public void setErr(boolean sho) {
        this.lpp.errorsX(sho);
        this.lpp.errorsY(sho);
    }

    public boolean isErrX() {
        return this.lpp.getErrorsX();
    }

    public boolean isErrY() {
        return this.lpp.getErrorsY();
    }

    public void setErrSysX(boolean sho) {
        this.lpp.errorsSysX(sho);
    }

    public void setErrColorY(Color color) {
        this.lpp.setColorErrorsY(color);
    }

    public void setErrColorX(Color color) {
        this.lpp.setColorErrorsX(color);
    }

    public void setErrColor(Color color) {
        this.lpp.setColorErrorsX(color);
        this.lpp.setColorErrorsY(color);
    }

    public void setErrColor(Color color, double transperency) {
        this.lpp.setColorErrorsX(color);
        this.lpp.setColorErrorsY(color);
        this.lpp.setFillColorTransparency((float)transperency);
    }

    public void setSymbol(int shape) {
        this.lpp.setSymbol(shape);
        this.symbolshape = shape == 0 ? "Circle" : (shape == 1 ? "Square" : (shape == 2 ? "Diamond" : (shape == 12 ? "+" : (shape == 10 ? "*" : (shape == 9 ? "x" : (shape == 11 ? "Dot" : "Circle"))))));
    }

    public void setSymbol(String shape) {
        shape = shape.trim();
        this.symbolshape = shape = shape.toLowerCase();
        switch (shape) {
            case "+": {
                this.lpp.setSymbol(12);
                return;
            }
            case "Dot": {
                this.lpp.setSymbol(4);
                return;
            }
            case "Circle": {
                this.lpp.setSymbol(0);
                return;
            }
            case "o": {
                this.lpp.setSymbol(0);
                return;
            }
            case "t": {
                this.lpp.setSymbol(3);
                return;
            }
            case "*": {
                this.lpp.setSymbol(10);
                return;
            }
            case "x": {
                this.lpp.setSymbol(9);
                return;
            }
            case "square": {
                this.lpp.setSymbol(1);
                return;
            }
            case "s": {
                this.lpp.setSymbol(1);
                return;
            }
            case "dot": {
                this.lpp.setSymbol(11);
                return;
            }
            case "diamond": {
                this.lpp.setSymbol(2);
                return;
            }
            case "d": {
                this.lpp.setSymbol(2);
                return;
            }
        }
    }

    public String getSymbolShape() {
        return this.symbolshape;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
        if (style == 1) {
            this.lpp.setDashLength(10.0f);
        }
        if (style == 2) {
            this.lpp.setDashLength(5.0f);
        }
        if (style == 3) {
            this.lpp.setDashLength(3.0f);
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getSymbol() {
        return this.lpp.getSymbol();
    }

    public void setColor(Color color) {
        this.lpp.setColor(color);
    }

    public Color getColor() {
        return this.lpp.getColor();
    }

    public void setPenWidth(int w) {
        this.lpp.setPenWidth(w);
    }

    public float getPenWidth() {
        return this.lpp.getPenWidth();
    }

    public void setPenDash() {
        this.lpp.setDashLength(10.0f);
    }

    public void setPenDash(int lenght) {
        this.lpp.setDashLength(lenght);
    }

    public void setType(int type) {
        this.lpp.setType(type);
    }

    public int getType() {
        return this.lpp.getType();
    }

    public void setPenWidthErrSys(int w) {
        this.lpp.setPenWidthErrSys(w);
    }

    public void setPenWidthErr(int w) {
        this.lpp.setPenWidthErr(w);
    }

    public void setErrAll(boolean w) {
        this.lpp.errorsSysY(w);
        this.lpp.errorsSysX(w);
        this.lpp.errorsY(w);
        this.lpp.errorsX(w);
    }

    public void setErrFill(boolean w) {
        this.lpp.errorsFill(w);
    }

    public void setErrFillColor(Color c) {
        this.lpp.errorsFill(true);
        this.lpp.setErrorFillColorTransp(0.5f);
        this.lpp.setColorErrorsFill(c);
    }

    public void setErrFillColor(Color c, double transp) {
        this.lpp.errorsFill(true);
        this.lpp.setColorErrorsFill(c);
        if (transp >= 0.0 && transp <= 1.0) {
            this.lpp.setErrorFillColorTransp((float)transp);
        }
    }

    public void setErrSysFillColor(Color c) {
        this.lpp.errorsFillSys(true);
        this.lpp.setErrorFillColorTranspSys(0.5f);
        this.lpp.setColorErrorsFillSys(c);
    }

    public void setErrSysFillColor(Color c, double transp) {
        this.lpp.errorsFillSys(true);
        this.lpp.setColorErrorsFillSys(c);
        if (transp >= 0.0 && transp <= 1.0) {
            this.lpp.setErrorFillColorTranspSys((float)transp);
        }
    }

    public void setErrSysFill(boolean w) {
        this.lpp.errorsFillSys(w);
    }

    public void setErrTicSize(double w) {
        this.lpp.setErrTicSize((float)w);
    }

    public void setSymbolSize(int w) {
        this.lpp.setSymbolSize(w);
    }

    public double getSymbolSize() {
        return this.lpp.getSymbolSize();
    }

    public void setGraphStyle(int w) {
        this.lpp.setGraphStyle(w);
    }

    public void setDrawSymbol(boolean w) {
        this.lpp.setDrawSymbol(w);
    }

    public void setDrawLineKey(boolean w) {
        this.lpp.setDrawLine(w);
    }

    public void setDrawLine(boolean w) {
        this.lpp.setDrawLine(w);
    }

    public void setBinWidth(double w) {
        this.lpp.setWidthBin(w);
    }

    public double getBinWidth() {
        return this.lpp.getWidthBin();
    }

    public LinePars getLineParm() {
        return this.lpp;
    }

    public String getDrawOptions() {
        return this.lpp.getAttributes();
    }

    public void printDrawOptions() {
        this.lpp.print();
    }

    public void printDrawOptions(PrintStream out) {
        this.lpp.print(out);
    }
}

