/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.io.Serializable;
import java.util.Arrays;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.gui.HelpBrowser;

public class DProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private Double[] D1;
    private Double[][] D2;
    private String type = "p1d";
    private String[] names;

    public DProxy() {
        this.title = "";
        this.type = "p1d";
    }

    public DProxy(H1D h) {
        int ibins = h.getBins() + 2;
        this.D2 = new Double[ibins - 2][7];
        this.names = new String[]{"lowEdge", "upperEdge", "binHeight", "binError", "binEntries", "binMean", "binRms"};
        this.title = h.getTitle();
        this.type = "h1d";
        for (int i = 0; i < ibins - 2; ++i) {
            this.D2[i][0] = h.binLowerEdge(i);
            this.D2[i][1] = h.binUpperEdge(i);
            this.D2[i][2] = h.binHeight(i);
            this.D2[i][3] = h.binError(i);
            this.D2[i][4] = h.binEntries(i);
            this.D2[i][5] = h.binMean(i);
            this.D2[i][6] = h.binRms(i);
        }
        this.D1 = new Double[9];
        double xb = 1.0;
        if (!h.isFixedBinning()) {
            xb = 0.0;
        }
        this.D1[0] = xb;
        this.D1[1] = h.getBins();
        this.D1[2] = h.mean();
        this.D1[3] = h.rms();
        this.D1[4] = h.entries();
        this.D1[5] = h.getMin();
        this.D1[6] = h.getMax();
        this.D1[7] = h.getOverflowlowHeight();
        this.D1[8] = h.getUnderflowHeight();
    }

    public DProxy(P1D hh) {
        this.title = hh.getTitle();
        this.type = "p1d";
        this.D1 = new Double[2];
        this.D1[0] = hh.dimension();
        this.D1[1] = hh.size();
        if (hh.dimension() == 2) {
            this.names = new String[]{"x", "y"};
            this.D2 = new Double[hh.size()][hh.dimension()];
            int nrows = hh.size();
            int ncols = this.names.length;
            for (int i = 0; i < nrows; ++i) {
                this.D2[i][0] = hh.getX(i);
                this.D2[i][1] = hh.getY(i);
            }
            return;
        }
        if (hh.dimension() == 3) {
            this.D2 = new Double[hh.size()][hh.dimension()];
            this.names = new String[]{"x", "y", "errY"};
            int nrows = hh.size();
            int ncols = this.names.length;
            for (int i = 0; i < nrows; ++i) {
                this.D2[i][0] = hh.getX(i);
                this.D2[i][1] = hh.getY(i);
                this.D2[i][2] = hh.getYupper(i);
            }
            return;
        }
        if (hh.dimension() == 4) {
            this.D2 = new Double[hh.size()][hh.dimension()];
            this.names = new String[]{"x", "y", "errY Up", "errY Low"};
            int nrows = hh.size();
            int ncols = this.names.length;
            for (int i = 0; i < nrows; ++i) {
                this.D2[i][0] = hh.getX(i);
                this.D2[i][1] = hh.getY(i);
                this.D2[i][2] = hh.getYupper(i);
                this.D2[i][3] = hh.getYlower(i);
            }
            return;
        }
        if (hh.dimension() == 6) {
            this.D2 = new Double[hh.size()][hh.dimension()];
            this.names = new String[]{"x", "y", "errX Left", "errX right", "errY Up", "errY Low"};
            int nrows = hh.size();
            int ncols = this.names.length;
            for (int i = 0; i < nrows; ++i) {
                this.D2[i][0] = hh.getX(i);
                this.D2[i][1] = hh.getY(i);
                this.D2[i][2] = hh.getXleft(i);
                this.D2[i][3] = hh.getXright(i);
                this.D2[i][4] = hh.getYupper(i);
                this.D2[i][5] = hh.getYlower(i);
            }
            return;
        }
        if (hh.dimension() == 10) {
            this.D2 = new Double[hh.size()][hh.dimension()];
            this.names = new String[]{"x", "y", "errX Left", "errX right", "errY Up", "errY Low", "errX(sys) Left", "errX(sys) right", "errY(sys) Up", "errY(sys) Low"};
            int nrows = hh.size();
            int ncols = this.names.length;
            for (int i = 0; i < nrows; ++i) {
                this.D2[i][0] = hh.getX(i);
                this.D2[i][1] = hh.getY(i);
                this.D2[i][2] = hh.getXleft(i);
                this.D2[i][3] = hh.getXright(i);
                this.D2[i][4] = hh.getYupper(i);
                this.D2[i][5] = hh.getYlower(i);
                this.D2[i][6] = hh.getXleftSys(i);
                this.D2[i][7] = hh.getXrightSys(i);
                this.D2[i][8] = hh.getYupperSys(i);
                this.D2[i][9] = hh.getYlowerSys(i);
            }
            return;
        }
    }

    public DProxy(P2D hh) {
        this.title = hh.getTitle();
        this.type = "p2d";
        this.D1 = new Double[2];
        this.D1[0] = 3.0;
        this.D1[1] = hh.size();
        this.names = new String[]{"x", "y", "z"};
        this.D2 = new Double[hh.size()][3];
        int nrows = hh.size();
        int ncols = this.names.length;
        for (int i = 0; i < nrows; ++i) {
            this.D2[i][0] = hh.getX(i);
            this.D2[i][1] = hh.getY(i);
            this.D2[i][2] = hh.getZ(i);
        }
    }

    public DProxy(P0D hh) {
        this.title = hh.getTitle();
        this.type = "p0d";
        this.names = new String[]{"x"};
        this.D1 = new Double[hh.size()];
        int nrows = hh.size();
        for (int i = 0; i < nrows; ++i) {
            this.D1[i] = hh.get(i);
        }
    }

    public DProxy(P0I hh) {
        this.title = hh.getTitle();
        this.type = "p0i";
        this.names = new String[]{"x"};
        this.D1 = new Double[hh.size()];
        int nrows = hh.size();
        for (int i = 0; i < nrows; ++i) {
            this.D1[i] = hh.get(i);
        }
    }

    public Object get() {
        if (this.type.equals("p1d")) {
            int dim = this.D1[0].intValue();
            P1D p1 = new P1D(this.title, dim);
            for (int i = 0; i < this.D2.length; ++i) {
                if (dim == 2) {
                    p1.add(this.D2[i][0], this.D2[i][1]);
                    continue;
                }
                if (dim == 3) {
                    p1.add(this.D2[i][0], this.D2[i][1], this.D2[i][2]);
                    continue;
                }
                if (dim == 4) {
                    p1.add(this.D2[i][0], this.D2[i][1], this.D2[i][2], this.D2[i][3]);
                    continue;
                }
                if (dim == 6) {
                    p1.add(this.D2[i][0], this.D2[i][1], this.D2[i][2], this.D2[i][3], this.D2[i][4], this.D2[i][5]);
                    continue;
                }
                if (dim != 10) continue;
                p1.add(this.D2[i][0], this.D2[i][1], this.D2[i][2], this.D2[i][3], this.D2[i][4], this.D2[i][5], this.D2[i][6], this.D2[i][7], this.D2[i][8], this.D2[i][9]);
            }
            return p1;
        }
        if (this.type.equals("h1d")) {
            int i;
            int isFixedBin = this.D1[0].intValue();
            int ibins = this.D1[1].intValue() + 2;
            double Pmean = this.D1[2];
            double Prms = this.D1[3];
            int Pentries = this.D1[4].intValue();
            double Pmin = this.D1[5];
            double Pmax = this.D1[6];
            double OverflowlowHeight = this.D1[7];
            double UnderflowHeight = this.D1[8];
            double[] edges = new double[ibins - 1];
            double[] heights = new double[ibins];
            double[] errors = new double[ibins];
            double[] means = new double[ibins];
            double[] rms = new double[ibins];
            int[] entries = new int[ibins];
            H1D h1d = null;
            if (isFixedBin == 1) {
                h1d = new H1D(this.title, ibins - 2, Pmin, Pmax);
            } else {
                for (i = 0; i < ibins - 2; ++i) {
                    edges[i] = this.D2[i][0];
                }
                edges[ibins - 2] = this.D2[ibins - 3][1];
                for (i = 0; i < edges.length; ++i) {
                    System.out.println(edges[i]);
                }
                h1d = new H1D(this.title, edges);
            }
            heights[0] = UnderflowHeight;
            heights[ibins - 1] = OverflowlowHeight;
            h1d.setBins(ibins);
            h1d.setMin(Pmin);
            h1d.setMax(Pmax);
            h1d.setMeanAndRms(Pmean, Prms);
            for (i = 0; i < ibins - 2; ++i) {
                heights[i + 1] = this.D2[i][2];
                errors[i + 1] = this.D2[i][3];
                entries[i + 1] = this.D2[i][4].intValue();
                means[i + 1] = this.D2[i][5];
                rms[i + 1] = this.D2[i][6];
            }
            h1d.setContents(heights, errors, entries, means, rms);
            return h1d;
        }
        if (this.type.equals("p2d")) {
            P2D p1 = new P2D(this.title);
            for (int i = 0; i < this.D2.length; ++i) {
                p1.add(this.D2[i][0], this.D2[i][1], this.D2[i][2]);
            }
            return p1;
        }
        if (this.type.equals("p0d")) {
            P0D p1 = new P0D(this.title);
            for (int i = 0; i < this.D1.length; ++i) {
                p1.add(this.D1[i]);
            }
            return p1;
        }
        if (this.type.equals("p0i")) {
            P0I p1 = new P0I(this.title);
            for (int i = 0; i < this.D1.length; ++i) {
                p1.add(this.D1[i].intValue());
            }
            return p1;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double[][] getD2() {
        return this.D2;
    }

    public void setD1(Double[] D1) {
        this.D1 = D1;
    }

    public Double[] getD1() {
        return this.D1;
    }

    public void setD2(Double[][] D2) {
        this.D2 = D2;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public String toString() {
        String s = "title=" + this.title;
        s = s + " D2=" + Arrays.deepToString((Object[])this.D2);
        return s;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public String[] getNames() {
        return this.names;
    }
}

