/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

class RotateTextFilter
extends ImageFilter {
    private int angle = 0;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private int width;
    private int height;
    private double cos = 1.0;
    private double sin = 0.0;
    private int[] ipixels;
    private byte[] bpixels;
    private ColorModel colorModel;

    public RotateTextFilter(int angle) {
        this.angle = angle % 360 / 90 * 90;
        this.cos = Math.cos((double)angle * Math.PI / 180.0);
        this.sin = Math.sin((double)angle * Math.PI / 180.0);
    }

    public void setProperties(Hashtable props) {
        props = (Hashtable)props.clone();
        props.put("rotAngle", new Integer(this.angle));
        super.setProperties(props);
    }

    @Override
    public void setDimensions(int w, int h) {
        int[] x = new int[]{0, w - 1, w - 1, 0};
        int[] y = new int[]{0, 0, h - 1, h - 1};
        for (int i = 0; i < 4; ++i) {
            int xx = (int)Math.round((double)x[i] * this.cos + (double)y[i] * this.sin);
            int yy = (int)Math.round((double)(-x[i]) * this.sin + (double)y[i] * this.cos);
            this.xmin = Math.min(this.xmin, xx);
            this.xmax = Math.max(this.xmax, xx);
            this.ymin = Math.min(this.ymin, yy);
            this.ymax = Math.max(this.ymax, yy);
        }
        this.width = this.xmax - this.xmin + 1;
        this.height = this.ymax - this.ymin + 1;
        this.consumer.setDimensions(this.width, this.height);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scan) {
        if (this.bpixels == null) {
            this.colorModel = model;
            this.bpixels = new byte[this.width * this.height];
        }
        int j = y;
        int n = 0;
        while (n < h) {
            int i = x;
            int m = 0;
            while (m < w) {
                int ir = (int)Math.round((double)i * this.cos + (double)j * this.sin) - this.xmin;
                int jr = (int)Math.round((double)(-i) * this.sin + (double)j * this.cos) - this.ymin;
                int k = ir + jr * this.width;
                this.bpixels[k] = pixels[(j - y) * scan + (i - x) + off];
                ++m;
                ++i;
            }
            ++n;
            ++j;
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scan) {
        if (this.ipixels == null) {
            this.colorModel = model;
            this.ipixels = new int[this.width * this.height];
        }
        int j = y;
        int n = 0;
        while (n < h) {
            int i = x;
            int m = 0;
            while (m < w) {
                int ir = (int)Math.round((double)i * this.cos + (double)j * this.sin) - this.xmin;
                int jr = (int)Math.round((double)(-i) * this.sin + (double)j * this.cos) - this.ymin;
                int k = ir + jr * this.width;
                this.ipixels[k] = pixels[(j - y) * scan + (i - x) + off];
                ++m;
                ++i;
            }
            ++n;
            ++j;
        }
    }

    @Override
    public void imageComplete(int status) {
        if (status == 4 || status == 1) {
            this.consumer.imageComplete(status);
            this.ipixels = null;
            this.bpixels = null;
            return;
        }
        if (this.bpixels != null) {
            for (int j = 0; j < this.height; ++j) {
                this.consumer.setPixels(0, j, this.width, 1, this.colorModel, this.bpixels, j * this.width, this.width);
            }
            this.consumer.imageComplete(status);
        } else if (this.ipixels != null) {
            for (int j = 0; j < this.height; ++j) {
                this.consumer.setPixels(0, j, this.width, 1, this.colorModel, this.ipixels, j * this.width, this.width);
            }
            this.consumer.imageComplete(status);
        } else {
            this.consumer.imageComplete(4);
        }
        this.ipixels = null;
        this.bpixels = null;
    }
}

