/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntFunction;
import cern.jet.random.engine.MersenneTwister;

public abstract class RandomEngine
extends PersistentObject
implements DoubleFunction,
IntFunction {
    protected RandomEngine() {
    }

    @Override
    public double apply(double d) {
        return this.raw();
    }

    @Override
    public int apply(int n) {
        return this.nextInt();
    }

    public static RandomEngine makeDefault() {
        return new MersenneTwister((int)System.currentTimeMillis());
    }

    public double nextDouble() {
        double d;
        while (!((d = ((double)this.nextLong() - -9.223372036854776E18) * 5.421010862427522E-20) > 0.0) || !(d < 1.0)) {
        }
        return d;
    }

    public float nextFloat() {
        float f;
        while ((f = (float)this.raw()) >= 1.0f) {
        }
        return f;
    }

    public abstract int nextInt();

    public long nextLong() {
        return ((long)this.nextInt() & 0xFFFFFFFFL) << 32 | (long)this.nextInt() & 0xFFFFFFFFL;
    }

    public double raw() {
        int n;
        while ((n = this.nextInt()) == 0) {
        }
        return (double)((long)n & 0xFFFFFFFFL) * 2.3283064365386963E-10;
    }
}

