/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class ChiSquare
extends AbstractContinousDistribution {
    protected double freedom;
    private double freedom_in = -1.0;
    private double b;
    private double vm;
    private double vp;
    private double vd;
    protected static ChiSquare shared = new ChiSquare(1.0, ChiSquare.makeDefaultGenerator());

    public ChiSquare(double d, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d);
    }

    public double cdf(double d) {
        return Probability.chiSquare(this.freedom, d);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double d) {
        double d2;
        if (d == 1.0) {
            double d3;
            while (true) {
                double d4 = this.randomGenerator.raw();
                double d5 = this.randomGenerator.raw() * 0.857763884960707;
                d3 = d5 / d4;
                if (d3 < 0.0) continue;
                double d6 = d3 * d3;
                double d7 = 2.5 - d6;
                if (d3 < 0.0) {
                    d7 += d6 * d3 / (3.0 * d3);
                }
                if (d4 < d7 * 0.3894003915) {
                    return d3 * d3;
                }
                if (!(d6 > 1.036961043 / d4 + 1.4) && 2.0 * Math.log(d4) < -d6 * 0.5) break;
            }
            return d3 * d3;
        }
        if (d != this.freedom_in) {
            this.b = Math.sqrt(d - 1.0);
            this.vm = -0.6065306597 * (1.0 - 0.25 / (this.b * this.b + 1.0));
            this.vm = -this.b > this.vm ? -this.b : this.vm;
            this.vp = 0.6065306597 * (0.7071067812 + this.b) / (0.5 + this.b);
            this.vd = this.vp - this.vm;
            this.freedom_in = d;
        }
        while (true) {
            double d8 = this.randomGenerator.raw();
            double d9 = this.randomGenerator.raw() * this.vd + this.vm;
            d2 = d9 / d8;
            if (d2 < -this.b) continue;
            double d10 = d2 * d2;
            double d11 = 2.5 - d10;
            if (d2 < 0.0) {
                d11 += d10 * d2 / (3.0 * (d2 + this.b));
            }
            if (d8 < d11 * 0.3894003915) {
                return (d2 + this.b) * (d2 + this.b);
            }
            if (!(d10 > 1.036961043 / d8 + 1.4) && 2.0 * Math.log(d8) < Math.log(1.0 + d2 / this.b) * this.b * this.b - d10 * 0.5 - d2 * this.b) break;
        }
        return (d2 + this.b) * (d2 + this.b);
    }

    public double pdf(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d2 = Fun.logGamma(this.freedom / 2.0);
        return Math.exp((this.freedom / 2.0 - 1.0) * Math.log(d / 2.0) - d / 2.0 - d2) / 2.0;
    }

    public void setState(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            return shared.nextDouble(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.freedom + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

