/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.bin;

import cern.colt.matrix.impl.FormerFactory;
import cern.hep.aida.bin.BinFunction1D;
import cern.hep.aida.bin.DynamicBin1D;

public class BinFunctions1D {
    public static final BinFunctions1D functions = new BinFunctions1D();
    public static final BinFunction1D max = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.max();
        }

        @Override
        public final String name() {
            return "Max";
        }
    };
    public static final BinFunction1D mean = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.mean();
        }

        @Override
        public final String name() {
            return "Mean";
        }
    };
    public static final BinFunction1D median = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.median();
        }

        @Override
        public final String name() {
            return "Median";
        }
    };
    public static final BinFunction1D min = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.min();
        }

        @Override
        public final String name() {
            return "Min";
        }
    };
    public static final BinFunction1D rms = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.rms();
        }

        @Override
        public final String name() {
            return "RMS";
        }
    };
    public static final BinFunction1D size = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.size();
        }

        @Override
        public final String name() {
            return "Size";
        }
    };
    public static final BinFunction1D stdDev = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.standardDeviation();
        }

        @Override
        public final String name() {
            return "StdDev";
        }
    };
    public static final BinFunction1D sum = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.sum();
        }

        @Override
        public final String name() {
            return "Sum";
        }
    };
    public static final BinFunction1D sumLog = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.sumOfLogarithms();
        }

        @Override
        public final String name() {
            return "SumLog";
        }
    };
    public static final BinFunction1D geometricMean = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D dynamicBin1D) {
            return dynamicBin1D.geometricMean();
        }

        @Override
        public final String name() {
            return "GeomMean";
        }
    };

    protected BinFunctions1D() {
    }

    public static BinFunction1D quantile(final double d) {
        return new BinFunction1D(){

            @Override
            public final double apply(DynamicBin1D dynamicBin1D) {
                return dynamicBin1D.quantile(d);
            }

            @Override
            public final String name() {
                return new FormerFactory().create("%1.2G").form(d * 100.0) + "% Q.";
            }
        };
    }
}

