/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.Double27Function;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix3D;

public class DenseDoubleMatrix3D
extends DoubleMatrix3D {
    protected double[] elements;

    public DenseDoubleMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length));
        this.assign(dArray);
    }

    public DenseDoubleMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new double[n * n2 * n3];
    }

    protected DenseDoubleMatrix3D(int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = dArray;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix3D assign(double[][][] dArray) {
        if (this.isNoView) {
            if (dArray.length != this.slices) {
                throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
            }
            int n = this.slices * this.rows * this.columns - this.columns;
            int n2 = this.slices;
            while (--n2 >= 0) {
                double[][] dArray2 = dArray[n2];
                if (dArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                }
                int n3 = this.rows;
                while (--n3 >= 0) {
                    double[] dArray3 = dArray2[n3];
                    if (dArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(dArray3, 0, this.elements, n, this.columns);
                    n -= this.columns;
                }
            }
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            return super.assign(doubleMatrix3D);
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        if (denseDoubleMatrix3D == this) {
            return this;
        }
        this.checkShape(denseDoubleMatrix3D);
        if (this.haveSharedCells(denseDoubleMatrix3D)) {
            DoubleMatrix3D doubleMatrix3D2 = denseDoubleMatrix3D.copy();
            if (!(doubleMatrix3D2 instanceof DenseDoubleMatrix3D)) {
                return super.assign(doubleMatrix3D);
            }
            denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D2;
        }
        if (this.isNoView && denseDoubleMatrix3D.isNoView) {
            System.arraycopy(denseDoubleMatrix3D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(denseDoubleMatrix3D);
    }

    @Override
    public double getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D selectedDenseDoubleMatrix3D = (SelectedDenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == selectedDenseDoubleMatrix3D.elements;
        }
        if (doubleMatrix3D instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == denseDoubleMatrix3D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new DenseDoubleMatrix3D(n, n2, n3);
    }

    @Override
    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseDoubleMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    @Override
    public void setQuick(int n, int n2, int n3, double d) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = d;
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDoubleMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }

    @Override
    public void zAssign27Neighbors(DoubleMatrix3D doubleMatrix3D, Double27Function double27Function) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.zAssign27Neighbors(doubleMatrix3D, double27Function);
            return;
        }
        if (double27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix3D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        int n3 = this.sliceStride;
        int n4 = this.rowStride;
        int n5 = denseDoubleMatrix3D.rowStride;
        int n6 = this.columnStride;
        int n7 = denseDoubleMatrix3D.columnStride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix3D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        for (int i = 1; i < this.slices - 1; ++i) {
            int n8 = this.index(i, 1, 1);
            int n9 = denseDoubleMatrix3D.index(i, 1, 1);
            for (int j = 1; j < n; ++j) {
                int n10 = n8 - n3 - n4 - n6;
                int n11 = n10 + n4;
                int n12 = n11 + n4;
                int n13 = n10 + n3;
                int n14 = n13 + n4;
                int n15 = n14 + n4;
                int n16 = n13 + n3;
                int n17 = n16 + n4;
                int n18 = n17 + n4;
                double d = dArray[n10];
                double d2 = dArray[n10 += n6];
                double d3 = dArray[n11];
                double d4 = dArray[n11 += n6];
                double d5 = dArray[n12];
                double d6 = dArray[n12 += n6];
                double d7 = dArray[n13];
                double d8 = dArray[n13 += n6];
                double d9 = dArray[n14];
                double d10 = dArray[n14 += n6];
                double d11 = dArray[n15];
                double d12 = dArray[n15 += n6];
                double d13 = dArray[n16];
                double d14 = dArray[n16 += n6];
                double d15 = dArray[n17];
                double d16 = dArray[n17 += n6];
                double d17 = dArray[n18];
                double d18 = dArray[n18 += n6];
                int n19 = n9;
                for (int k = 1; k < n2; ++k) {
                    double d19 = dArray[n10 += n6];
                    double d20 = dArray[n11 += n6];
                    double d21 = dArray[n12 += n6];
                    double d22 = dArray[n13 += n6];
                    double d23 = dArray[n14 += n6];
                    double d24 = dArray[n15 += n6];
                    double d25 = dArray[n16 += n6];
                    double d26 = dArray[n17 += n6];
                    double d27 = dArray[n18 += n6];
                    dArray2[n19] = double27Function.apply(d, d2, d19, d3, d4, d20, d5, d6, d21, d7, d8, d22, d9, d10, d23, d11, d12, d24, d13, d14, d25, d15, d16, d26, d17, d18, d27);
                    n19 += n7;
                    d = d2;
                    d2 = d19;
                    d3 = d4;
                    d4 = d20;
                    d5 = d6;
                    d6 = d21;
                    d7 = d8;
                    d8 = d22;
                    d9 = d10;
                    d10 = d23;
                    d11 = d12;
                    d12 = d24;
                    d13 = d14;
                    d14 = d25;
                    d15 = d16;
                    d16 = d26;
                    d17 = d18;
                    d18 = d27;
                }
                n8 += n4;
                n9 += n5;
            }
        }
    }
}

