/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

public class Partitioning {
    protected Partitioning() {
    }

    public static void partition(DoubleMatrix2D doubleMatrix2D, int[] nArray, int n, int n2, int n3, final double[] dArray, int n4, int n5, int[] nArray2) {
        if (n < 0 || n2 >= doubleMatrix2D.rows() || n2 >= nArray.length) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 >= doubleMatrix2D.columns()) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n5 >= dArray.length) {
            throw new IllegalArgumentException();
        }
        if (nArray2.length < dArray.length) {
            throw new IllegalArgumentException();
        }
        final int[] nArray3 = nArray;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int n, int n2) {
                int n3 = nArray3[n];
                nArray3[n] = nArray3[n2];
                nArray3[n2] = n3;
            }
        };
        final DoubleMatrix1D doubleMatrix1D = doubleMatrix2D.viewColumn(n3);
        IntComparator intComparator = new IntComparator(){

            @Override
            public int compare(int n, int n2) {
                double d = dArray[n];
                double d2 = doubleMatrix1D.getQuick(nArray3[n2]);
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
        IntComparator intComparator2 = new IntComparator(){

            @Override
            public int compare(int n, int n2) {
                double d;
                double d2 = doubleMatrix1D.getQuick(nArray3[n]);
                return d2 < (d = doubleMatrix1D.getQuick(nArray3[n2])) ? -1 : (d2 == d ? 0 : 1);
            }
        };
        IntComparator intComparator3 = new IntComparator(){

            @Override
            public int compare(int n, int n2) {
                double d = dArray[n];
                double d2 = dArray[n2];
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        };
        cern.colt.Partitioning.genericPartition(n, n2, n4, n5, nArray2, intComparator, intComparator2, intComparator3, swapper);
    }

    public static DoubleMatrix2D partition(DoubleMatrix2D doubleMatrix2D, int n, double[] dArray, int[] nArray) {
        int n2 = 0;
        int n3 = doubleMatrix2D.rows() - 1;
        int n4 = 0;
        int n5 = dArray.length - 1;
        int[] nArray2 = new int[doubleMatrix2D.rows()];
        int n6 = nArray2.length;
        while (--n6 >= 0) {
            nArray2[n6] = n6;
        }
        Partitioning.partition(doubleMatrix2D, nArray2, n2, n3, n, dArray, n4, n5, nArray);
        int[] nArray3 = new int[doubleMatrix2D.columns()];
        int n7 = nArray3.length;
        while (--n7 >= 0) {
            nArray3[n7] = n7;
        }
        return doubleMatrix2D.viewSelection(nArray2, nArray3);
    }

    private static void xPartitionOld(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, int n, int n2, double[] dArray, int n3, int n4, int[] nArray) {
    }

    private static int xPartitionOld(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, int n, int n2, double d) {
        return 0;
    }
}

