/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.CharProcedure;
import cern.colt.list.AbstractCharList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class CharArrayList
extends AbstractCharList {
    protected char[] elements;

    public CharArrayList() {
        this(10);
    }

    public CharArrayList(char[] cArray) {
        this.elements(cArray);
    }

    public CharArrayList(int n) {
        this(new char[n]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(char c) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = c;
    }

    @Override
    public void beforeInsert(int n, char c) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = c;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(char c, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, c, n, n2);
    }

    @Override
    public Object clone() {
        CharArrayList charArrayList = new CharArrayList((char[])this.elements.clone());
        charArrayList.setSizeRaw(this.size);
        return charArrayList;
    }

    public CharArrayList copy() {
        return (CharArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, char c, char c2) {
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        int n3 = c2 - c + 1;
        int[] nArray = new int[n3];
        char[] cArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = cArray[n4++] - c;
            nArray[n5] = nArray[n5] + 1;
        }
        n4 = n;
        char c3 = c;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n6];
            if (n7 > 0) {
                if (n7 == 1) {
                    cArray[n4++] = c3;
                } else {
                    int n8 = n4 + n7 - 1;
                    this.fillFromToWith(n4, n8, c3);
                    n4 = n8 + 1;
                }
            }
            ++n6;
            c3 = (char)(c3 + '\u0001');
        }
    }

    @Override
    public char[] elements() {
        return this.elements;
    }

    @Override
    public AbstractCharList elements(char[] cArray) {
        this.elements = cArray;
        this.size = cArray.length;
        return this;
    }

    @Override
    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CharArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        CharArrayList charArrayList = (CharArrayList)object;
        if (this.size() != charArrayList.size()) {
            return false;
        }
        char[] cArray = this.elements();
        char[] cArray2 = charArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (cArray[n] == cArray2[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(CharProcedure charProcedure) {
        char[] cArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (charProcedure.apply(cArray[n2++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public char get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    @Override
    public char getQuick(int n) {
        return this.elements[n];
    }

    @Override
    public int indexOfFromTo(char c, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = this.elements;
        for (int i = n; i <= n2; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(char c, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = this.elements;
        for (int i = n2; i >= n; --i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractCharList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new CharArrayList(0);
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        char[] cArray = new char[n2 - n + 1];
        System.arraycopy(this.elements, n, cArray, 0, n2 - n + 1);
        return new CharArrayList(cArray);
    }

    @Override
    public boolean removeAll(AbstractCharList abstractCharList) {
        double d;
        if (!(abstractCharList instanceof CharArrayList)) {
            return super.removeAll(abstractCharList);
        }
        if (abstractCharList.size() == 0) {
            return false;
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        char[] cArray = this.elements;
        int n3 = this.size();
        double d2 = abstractCharList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            CharArrayList charArrayList = (CharArrayList)abstractCharList.clone();
            charArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (charArrayList.binarySearchFromTo(cArray[i], 0, n) >= 0) continue;
                cArray[n2++] = cArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractCharList.indexOfFromTo(cArray[i], 0, n) >= 0) continue;
                cArray[n2++] = cArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    @Override
    public void replaceFromToWithFrom(int n, int n2, AbstractCharList abstractCharList, int n3) {
        if (!(abstractCharList instanceof CharArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractCharList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            CharArrayList.checkRangeFromTo(n, n2, this.size());
            CharArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractCharList.size());
            System.arraycopy(((CharArrayList)abstractCharList).elements, n3, this.elements, n, n4);
        }
    }

    @Override
    public boolean retainAll(AbstractCharList abstractCharList) {
        double d;
        if (!(abstractCharList instanceof CharArrayList)) {
            return super.retainAll(abstractCharList);
        }
        int n = abstractCharList.size() - 1;
        int n2 = 0;
        char[] cArray = this.elements;
        int n3 = this.size();
        double d2 = abstractCharList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            CharArrayList charArrayList = (CharArrayList)abstractCharList.clone();
            charArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (charArrayList.binarySearchFromTo(cArray[i], 0, n) < 0) continue;
                cArray[n2++] = cArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractCharList.indexOfFromTo(cArray[i], 0, n) < 0) continue;
                cArray[n2++] = cArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    @Override
    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        char[] cArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            cArray[n3++] = cArray[n2];
            cArray[n2--] = c;
        }
    }

    @Override
    public void set(int n, char c) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = c;
    }

    @Override
    public void setQuick(int n, char c) {
        this.elements[n] = c;
    }

    @Override
    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        char[] cArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            char c = cArray[n3];
            cArray[n3] = cArray[i];
            cArray[i] = c;
        }
    }

    @Override
    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        CharArrayList.checkRangeFromTo(n, n2, this.size);
        char c = this.elements[n];
        char c2 = this.elements[n];
        char[] cArray = this.elements;
        int n3 = n + 1;
        while (n3 <= n2) {
            char c3;
            if ((c3 = cArray[n3++]) > c2) {
                c2 = c3;
                continue;
            }
            if (c3 >= c) continue;
            c = c3;
        }
        double d = (double)n2 - (double)n + 1.0;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = (double)c2 - (double)c + 1.0;
        double d4 = Math.max(d3, d);
        if (d3 < 10000.0 && d4 < d2) {
            this.countSortFromTo(n, n2, c, c2);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

