/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util.graph;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.encog.workbench.WorkBenchError;
import org.jfree.chart.JFreeChart;

public class DocumentPDF {
    public static void writeChartAsPDF(OutputStream out, JFreeChart chart, int width, int height, FontMapper mapper) throws IOException {
        Rectangle pagesize = new Rectangle((float)width, (float)height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.addAuthor("JFreeChart");
            document.addSubject("Demonstration");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, mapper);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    public static void savePDF(File filename, JFreeChart chart, int width, int height) {
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            document.open();
            PdfContentByte canvas = writer.getDirectContent();
            Graphics2D g2 = canvas.createGraphics((float)width, (float)height);
            Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)area);
            g2.dispose();
            document.close();
        }
        catch (DocumentException ex) {
            throw new WorkBenchError(ex);
        }
        catch (IOException ex) {
            throw new WorkBenchError(ex);
        }
    }
}

