/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.weights;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.AnalyzeNetwork;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.weights.WeightInfo;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class AnalyzeWeightsTab
extends EncogCommonTab
implements ActionListener {
    private static final long serialVersionUID = 4472644832610364833L;
    private JButton buttonClose;
    private JTabbedPane tabs;
    private WeightInfo weightInfo;
    private AnalyzeNetwork analyze;
    private BasicNetwork network;
    private HistogramDataset dataAll;
    private HistogramDataset dataWeights;
    private HistogramDataset dataBiases;

    public AnalyzeWeightsTab(ProjectEGFile encogObject) {
        super(encogObject);
        if (!(encogObject.getObject() instanceof BasicNetwork)) {
            throw new WorkBenchError("Can't visualize weights of " + encogObject.getObject().getClass().getSimpleName());
        }
        this.network = (BasicNetwork)encogObject.getObject();
        this.analyze = new AnalyzeNetwork(this.network);
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        this.buttonClose = new JButton("Close");
        buttonPanel.add(this.buttonClose);
        this.buttonClose.addActionListener(this);
        this.weightInfo = new WeightInfo(this);
        this.add((Component)this.weightInfo, "North");
        this.createAllDataset();
        ChartPanel allChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataAll));
        ChartPanel weightChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataWeights));
        ChartPanel biasesChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataBiases));
        this.tabs = new JTabbedPane();
        this.add((Component)this.tabs, "Center");
        this.tabs.addTab("Weights & Biases", (Component)allChart);
        this.tabs.addTab("Weights", (Component)weightChart);
        this.tabs.addTab("Biases", (Component)biasesChart);
    }

    private void createAllDataset() {
        this.dataAll = new HistogramDataset();
        double[] values = this.analyze.getAllValues();
        this.dataAll.addSeries((Comparable)((Object)"Weights & Biases"), values, 50);
        this.dataBiases = new HistogramDataset();
        double[] values2 = this.analyze.getWeightValues();
        this.dataBiases.addSeries((Comparable)((Object)"Biases"), values2, 50);
        this.dataWeights = new HistogramDataset();
        double[] values3 = this.analyze.getBiasValues();
        this.dataWeights.addSeries((Comparable)((Object)"Weights"), values3, 50);
    }

    private JFreeChart createChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        return chart;
    }

    public AnalyzeNetwork getAnalyze() {
        return this.analyze;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        }
    }

    @Override
    public String getName() {
        return "Visualize :" + this.getEncogObject().getName();
    }
}

