/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.epl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import org.encog.ml.prg.EncogProgram;
import org.encog.parse.expression.latex.RenderLatexExpression;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class EPLLatexTab
extends EncogCommonTab {
    private BufferedImage image;

    public EPLLatexTab(EncogProgram prg) {
        super((ProjectFile)null);
        try {
            RenderLatexExpression render = new RenderLatexExpression();
            String latex = render.render(prg);
            try {
                TeXFormula formula = new TeXFormula(latex);
                TeXIcon icon = formula.createTeXIcon(0, 20.0f);
                icon.setInsets(new Insets(5, 5, 5, 5));
                this.image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = this.image.createGraphics();
                g2.setColor(Color.white);
                g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
                JLabel jl = new JLabel();
                jl.setForeground(new Color(0, 0, 0));
                icon.paintIcon((Component)jl, (Graphics)g2, 0, 0);
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException("Can't parse LATEX: " + latex + "\nFrom: " + prg.toString(), ex);
            }
        }
        catch (Exception ex) {
            EncogWorkBench.displayError("Error", ex);
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.image, 0, 0, null);
    }

    @Override
    public String getName() {
        return "Structure: " + this.getEncogObject().getName();
    }
}

