/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.query.general;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.encog.EncogError;
import org.encog.ml.MLClassification;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.error.ErrorDialog;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.models.NetworkQueryModel;
import org.encog.workbench.tabs.EncogCommonTab;

public class ClassificationQueryTab
extends EncogCommonTab
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTable inputTable;
    private JTable outputTable;
    private int inputCount = this.getData().getInputCount();
    private int outputCount = this.getData().getOutputCount();
    private JButton calculateButton;

    public ClassificationQueryTab(ProjectEGFile data) {
        super(data);
        this.setSize(640, 480);
        this.setLayout(new BorderLayout());
        JPanel body = new JPanel();
        body.setLayout(new GridLayout(1, 2, 10, 10));
        this.add((Component)body, "Center");
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        body.add(left);
        body.add(right);
        left.setLayout(new BorderLayout());
        right.setLayout(new BorderLayout());
        left.add((Component)new JLabel("Input"), "North");
        right.add((Component)new JLabel("Output"), "North");
        this.inputTable = new JTable(new NetworkQueryModel(this.inputCount, 2));
        this.outputTable = new JTable(new NetworkQueryModel(1, 2));
        JScrollPane inputScroll = new JScrollPane(this.inputTable);
        JScrollPane outputScroll = new JScrollPane(this.outputTable);
        left.add((Component)inputScroll, "Center");
        right.add((Component)outputScroll, "Center");
        this.calculateButton = new JButton("Calculate");
        this.add((Component)this.calculateButton, "South");
        this.outputTable.setEnabled(false);
        int i = 1;
        while (i <= this.inputCount) {
            this.inputTable.setValueAt("Input " + i + ":", i - 1, 0);
            this.inputTable.setValueAt("0.0", i - 1, 1);
            ++i;
        }
        this.outputTable.setValueAt("Classification Output:", 0, 0);
        this.outputTable.setValueAt("0.0", 0, 1);
        this.calculateButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.calculateButton) {
            try {
                this.setDirty(true);
                BasicMLData input = new BasicMLData(this.inputCount);
                int i = 0;
                while (i < this.inputCount) {
                    double value = 0.0;
                    String str = (String)this.inputTable.getValueAt(i, 1);
                    try {
                        value = Double.parseDouble(str);
                    }
                    catch (NumberFormatException e2) {
                        EncogWorkBench.displayError("Data Error", "Please enter a valid input number.");
                    }
                    input.setData(i, value);
                    ++i;
                }
                int output = this.getData().classify(input);
                this.outputTable.setValueAt(output, 0, 1);
            }
            catch (EncogError ex) {
                EncogWorkBench.displayError("Query Error", ex.getMessage());
            }
            catch (Throwable t) {
                ErrorDialog.handleError(t, this.getEncogObject(), null);
            }
        }
    }

    public MLClassification getData() {
        return (MLClassification)((ProjectEGFile)this.getEncogObject()).getObject();
    }

    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public String getName() {
        return "Cls :" + this.getEncogObject().getName();
    }
}

