/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.proben;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.Format;
import org.encog.util.file.ResourceInputStream;
import org.encog.workbench.WorkBenchError;

public class ProBenData {
    private String sourceResource;
    private int boolIn = 0;
    private int realIn = 0;
    private int boolOut = 0;
    private int realOut = 0;
    private int trainingExamples = 0;
    private int validationExamples = 0;
    private int testExamples = 0;
    private MLDataSet trainingDataSet;
    private MLDataSet validationDataSet;
    private MLDataSet testDataSet;

    public ProBenData(String resource) {
        this.sourceResource = resource;
    }

    public void processHeaderLine(String line) {
        int index = line.indexOf(61);
        String name = line.substring(0, index).trim().toLowerCase();
        String value = line.substring(index + 1).trim();
        int valueInt = Integer.parseInt(value);
        if (name.equals("bool_in")) {
            this.boolIn = valueInt;
        } else if (name.equals("real_in")) {
            this.realIn = valueInt;
        } else if (name.equals("bool_out")) {
            this.boolOut = valueInt;
        } else if (name.equals("real_out")) {
            this.realOut = valueInt;
        } else if (name.equals("training_examples")) {
            this.trainingExamples = valueInt;
        } else if (name.equals("validation_examples")) {
            this.validationExamples = valueInt;
        } else if (name.equals("test_examples")) {
            this.testExamples = valueInt;
        } else {
            throw new WorkBenchError("Unknown header element: " + name);
        }
    }

    public int getInputCount() {
        return this.boolIn + this.realIn;
    }

    public int getIdealCount() {
        return this.boolOut + this.realOut;
    }

    public void processDataLine(String line) {
        BasicMLData inputData = new BasicMLData(this.getInputCount());
        BasicMLData idealData = new BasicMLData(this.getIdealCount());
        StringTokenizer tok = new StringTokenizer(line, " ");
        int i = 0;
        while (i < inputData.size()) {
            inputData.setData(i, Double.parseDouble(tok.nextToken()));
            ++i;
        }
        i = 0;
        while (i < idealData.size()) {
            idealData.setData(i, Double.parseDouble(tok.nextToken()));
            ++i;
        }
        if (this.trainingDataSet.getRecordCount() < (long)this.trainingExamples) {
            this.trainingDataSet.add(inputData, idealData);
        } else if (this.validationDataSet.getRecordCount() < (long)this.validationExamples) {
            this.validationDataSet.add(inputData, idealData);
        } else if (this.testDataSet.getRecordCount() < (long)this.testExamples) {
            this.testDataSet.add(inputData, idealData);
        }
    }

    public void load() {
        this.trainingDataSet = new BasicMLDataSet();
        this.validationDataSet = new BasicMLDataSet();
        this.testDataSet = new BasicMLDataSet();
        try {
            String str;
            InputStream is = ResourceInputStream.openResourceInputStream("org/encog/workbench/proben1/" + this.sourceResource);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((str = in.readLine()) != null) {
                if (str.indexOf(61) != -1) {
                    this.processHeaderLine(str);
                    continue;
                }
                this.processDataLine(str);
            }
            in.close();
        }
        catch (IOException ex) {
            throw new WorkBenchError(ex);
        }
    }

    public int getTrainingExamples() {
        return this.trainingExamples;
    }

    public MLDataSet getTrainingDataSet() {
        return this.trainingDataSet;
    }

    public MLDataSet getValidationDataSet() {
        return this.validationDataSet;
    }

    public MLDataSet getTestDataSet() {
        return this.testDataSet;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("bool_in = " + this.boolIn + "\n");
        result.append("real_in = " + this.realIn + "\n");
        result.append("bool_out = " + this.boolOut + "\n");
        result.append("real_out = " + this.realOut + "\n");
        result.append("training examples: " + Format.formatInteger((int)this.trainingDataSet.getRecordCount()) + "\n");
        result.append("validation examples: " + Format.formatInteger((int)this.validationDataSet.getRecordCount()) + "\n");
        result.append("test examples: " + Format.formatInteger((int)this.testDataSet.getRecordCount()) + "\n");
        return result.toString();
    }

    public String getName() {
        return this.sourceResource;
    }
}

