/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.mlmethod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.mathutil.randomize.ConsistentRandomizer;
import org.encog.mathutil.randomize.ConstRandomizer;
import org.encog.mathutil.randomize.Distort;
import org.encog.mathutil.randomize.FanInRandomizer;
import org.encog.mathutil.randomize.GaussianRandomizer;
import org.encog.mathutil.randomize.NguyenWidrowRandomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.ml.MLClassification;
import org.encog.ml.MLContext;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLFactory;
import org.encog.ml.MLInput;
import org.encog.ml.MLMethod;
import org.encog.ml.MLOutput;
import org.encog.ml.MLProperties;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.neural.cpn.CPN;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.neural.pattern.HopfieldPattern;
import org.encog.neural.prune.PruneSelective;
import org.encog.neural.rbf.RBFNetwork;
import org.encog.neural.thermal.HopfieldNetwork;
import org.encog.neural.thermal.ThermalNetwork;
import org.encog.util.Format;
import org.encog.util.HTMLReport;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.dialogs.RandomizeNetworkDialog;
import org.encog.workbench.dialogs.createnetwork.CreateFeedforward;
import org.encog.workbench.dialogs.createnetwork.CreateHopfieldDialog;
import org.encog.workbench.dialogs.select.SelectDialog;
import org.encog.workbench.dialogs.select.SelectItem;
import org.encog.workbench.dialogs.training.NetworkDialog;
import org.encog.workbench.frames.MapDataFrame;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.process.TrainBasicNetwork;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.mlmethod.WeightsTab;
import org.encog.workbench.tabs.query.general.ClassificationQueryTab;
import org.encog.workbench.tabs.query.general.RegressionQueryTab;
import org.encog.workbench.tabs.query.ocr.OCRQueryTab;
import org.encog.workbench.tabs.query.thermal.QueryThermalTab;
import org.encog.workbench.tabs.visualize.ThermalGrid.ThermalGridTab;
import org.encog.workbench.tabs.visualize.compare.NetCompareTab;
import org.encog.workbench.tabs.visualize.structure.StructureTab;
import org.encog.workbench.tabs.visualize.weights.AnalyzeWeightsTab;

public class MLMethodTab
extends EncogCommonTab
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private JButton buttonRandomize;
    private JButton buttonQuery;
    private JButton buttonTrain;
    private JButton buttonRestructure;
    private JButton buttonProperties;
    private JButton buttonVisualize;
    private JButton buttonWeights;
    private final JScrollPane scroll;
    private final JEditorPane editor;
    private MLMethod method;

    public MLMethodTab(ProjectEGFile data) {
        super(data);
        this.method = (MLMethod)data.getObject();
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.buttonRandomize = new JButton("Randomize/Reset");
        this.toolbar.add(this.buttonRandomize);
        this.buttonQuery = new JButton("Query");
        this.toolbar.add(this.buttonQuery);
        this.buttonTrain = new JButton("Train");
        this.toolbar.add(this.buttonTrain);
        this.buttonRestructure = new JButton("Restructure");
        this.toolbar.add(this.buttonRestructure);
        if (this.method instanceof BasicNetwork) {
            this.buttonWeights = new JButton("Weights");
            this.toolbar.add(this.buttonWeights);
            this.buttonWeights.addActionListener(this);
        }
        this.buttonProperties = new JButton("Properties");
        this.toolbar.add(this.buttonProperties);
        this.buttonVisualize = new JButton("Visualize");
        this.toolbar.add(this.buttonVisualize);
        this.buttonRandomize.addActionListener(this);
        this.buttonQuery.addActionListener(this);
        this.buttonTrain.addActionListener(this);
        this.buttonRestructure.addActionListener(this);
        this.buttonProperties.addActionListener(this);
        this.buttonVisualize.addActionListener(this);
        this.add((Component)this.toolbar, "First");
        this.editor = new JEditorPane("text/html", "");
        this.editor.setEditable(false);
        this.scroll = new JScrollPane(this.editor);
        this.add((Component)this.scroll, "Center");
        this.produceReport();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        try {
            if (action.getSource() == this.buttonQuery) {
                this.performQuery();
            } else if (action.getSource() == this.buttonRandomize) {
                this.performRandomize();
            } else if (action.getSource() == this.buttonTrain) {
                this.performTrain();
            } else if (action.getSource() == this.buttonRestructure) {
                this.performRestructure();
            } else if (action.getSource() == this.buttonProperties) {
                this.performProperties();
            } else if (action.getSource() == this.buttonVisualize) {
                this.handleVisualize();
            } else if (action.getSource() == this.buttonWeights) {
                this.performWeights();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    private void performTrain() {
        TrainBasicNetwork t = new TrainBasicNetwork((ProjectEGFile)this.getEncogObject(), this);
        t.performTrain();
    }

    private void randomizeBasicNetwork() {
        RandomizeNetworkDialog dialog = new RandomizeNetworkDialog(EncogWorkBench.getInstance().getMainWindow());
        dialog.getHigh().setValue(1.0);
        dialog.getConstHigh().setValue(1.0);
        dialog.getLow().setValue(-1.0);
        dialog.getConstLow().setValue(-1.0);
        dialog.getSeedValue().setValue(1000);
        dialog.getConstantValue().setValue(0.0);
        dialog.getPerturbPercent().setValue(0.01);
        if (dialog.process()) {
            switch (dialog.getCurrentTab()) {
                case 0: {
                    this.optionRandomize(dialog);
                    break;
                }
                case 1: {
                    this.optionPerturb(dialog);
                    break;
                }
                case 2: {
                    this.optionGaussian(dialog);
                    break;
                }
                case 3: {
                    this.optionConsistent(dialog);
                    break;
                }
                case 4: {
                    this.optionConstant(dialog);
                }
            }
        }
    }

    private void performRandomize() {
        if (EncogWorkBench.askQuestion("Are you sure?", "Randomize/reset network weights and lose all training?")) {
            if (this.method instanceof BasicNetwork) {
                this.randomizeBasicNetwork();
            } else if (this.method instanceof MLResettable) {
                ((MLResettable)this.method).reset();
            }
        }
    }

    private void optionConstant(RandomizeNetworkDialog dialog) {
        double value = dialog.getConstantValue().getValue();
        ConstRandomizer r = new ConstRandomizer(value);
        r.randomize((BasicNetwork)this.method);
        this.setDirty(true);
    }

    private void optionConsistent(RandomizeNetworkDialog dialog) {
        int seed = dialog.getSeedValue().getValue();
        double min = dialog.getConstLow().getValue();
        double max = dialog.getConstHigh().getValue();
        ConsistentRandomizer c = new ConsistentRandomizer(min, max, seed);
        c.randomize(this.method);
        this.setDirty(true);
    }

    private void optionPerturb(RandomizeNetworkDialog dialog) {
        double percent = dialog.getPerturbPercent().getValue();
        Distort distort = new Distort(percent);
        distort.randomize((BasicNetwork)this.method);
        this.setDirty(true);
    }

    private void optionGaussian(RandomizeNetworkDialog dialog) {
        double mean = dialog.getMean().getValue();
        double dev = dialog.getDeviation().getValue();
        GaussianRandomizer g = new GaussianRandomizer(mean, dev);
        g.randomize((BasicNetwork)this.method);
        this.setDirty(true);
    }

    private void optionRandomize(RandomizeNetworkDialog dialog) {
        BasicRandomizer r = null;
        switch (dialog.getTheType().getSelectedIndex()) {
            case 0: {
                r = new RangeRandomizer(dialog.getLow().getValue(), dialog.getHigh().getValue());
                break;
            }
            case 1: {
                r = new NguyenWidrowRandomizer();
                break;
            }
            case 2: {
                r = new FanInRandomizer(dialog.getLow().getValue(), dialog.getHigh().getValue(), false);
            }
        }
        if (r != null) {
            r.randomize((BasicNetwork)this.method);
            this.setDirty(true);
        }
    }

    private void performQuery() {
        try {
            if (this.method instanceof ThermalNetwork) {
                QueryThermalTab tab = new QueryThermalTab((ProjectEGFile)this.getEncogObject());
                EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Thermal Query");
            } else {
                SelectItem selectClassification = null;
                SelectItem selectRegression = null;
                ArrayList<SelectItem> list = new ArrayList<SelectItem>();
                if (this.method instanceof MLClassification) {
                    selectClassification = new SelectItem("Query Classification", "Machine Learning output is a class.");
                    list.add(selectClassification);
                }
                if (this.method instanceof MLRegression) {
                    selectRegression = new SelectItem("Query Regression", "Machine Learning output is a number(s).");
                    list.add(selectRegression);
                }
                SelectItem selectOCR = new SelectItem("Query OCR", "Query using drawn chars.  Supports regression or classification.");
                list.add(selectOCR);
                SelectDialog sel = new SelectDialog(EncogWorkBench.getInstance().getMainWindow(), list);
                sel.setVisible(true);
                if (sel.getSelected() == selectClassification) {
                    ClassificationQueryTab tab = new ClassificationQueryTab((ProjectEGFile)this.getEncogObject());
                    EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Query Classification");
                } else if (sel.getSelected() == selectRegression) {
                    RegressionQueryTab tab = new RegressionQueryTab((MLRegression)((ProjectEGFile)this.getEncogObject()).getObject());
                    EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Query Regression");
                } else if (sel.getSelected() == selectOCR) {
                    OCRQueryTab tab = new OCRQueryTab((ProjectEGFile)this.getEncogObject());
                    EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Query OCR");
                }
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    public BasicNetwork getData() {
        return (BasicNetwork)this.method;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void performProperties() {
        if (this.method instanceof MLProperties) {
            MapDataFrame frame = new MapDataFrame(((MLProperties)this.method).getProperties(), "Properties");
            frame.setVisible(true);
            this.setDirty(true);
        } else {
            EncogWorkBench.displayError("Error", "This Machine Learning Method type does not support properties.");
        }
    }

    public void handleVisualize() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        SelectItem selectWeights = new SelectItem("Weights Histogram", "A histogram of the weights.");
        list.add(selectWeights);
        SelectItem selectStructure = new SelectItem("Network Structure", "The structure of the neural network.");
        list.add(selectStructure);
        SelectItem selectThermal = new SelectItem("Thermal Matrix", "Shows the matrix of a Hopfield or Boltzmann Machine.");
        list.add(selectThermal);
        SelectItem selectCompare = new SelectItem("Compare Network", "Compare this neural network to another neural network with the same weight count.");
        list.add(selectCompare);
        SelectDialog sel = new SelectDialog(EncogWorkBench.getInstance().getMainWindow(), list);
        sel.setVisible(true);
        if (sel.getSelected() == selectWeights) {
            this.analyzeWeights();
        } else if (sel.getSelected() == selectStructure) {
            this.analyzeStructure();
        } else if (sel.getSelected() == selectThermal) {
            this.analyzeThermal();
        } else if (sel.getSelected() == selectCompare) {
            this.compareNetworks();
        }
    }

    private void analyzeThermal() {
        ThermalGridTab tab = new ThermalGridTab((ProjectEGFile)this.getEncogObject());
        EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Thermal Grid");
    }

    private void analyzeStructure() {
        if (!(this.method instanceof MLMethod)) {
            throw new WorkBenchError("No analysis available for: " + this.method.getClass().getSimpleName());
        }
        StructureTab tab = new StructureTab(this.method);
        EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Network Structure");
    }

    public void analyzeWeights() {
        AnalyzeWeightsTab tab = new AnalyzeWeightsTab((ProjectEGFile)this.getEncogObject());
        EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Analyze Weights");
    }

    public void produceReport() {
        MLMethod reg;
        HTMLReport report = new HTMLReport();
        report.beginHTML();
        report.title("MLMethod");
        report.beginBody();
        report.h1(this.method.getClass().getSimpleName());
        report.beginTable();
        if (this.method instanceof MLInput) {
            reg = (MLInput)this.method;
            report.tablePair("Input Count", Format.formatInteger(reg.getInputCount()));
        }
        if (this.method instanceof MLOutput) {
            reg = (MLOutput)this.method;
            report.tablePair("Output Count", Format.formatInteger(reg.getOutputCount()));
        }
        if (this.method instanceof MLEncodable) {
            MLEncodable encode = (MLEncodable)this.method;
            report.tablePair("Encoded Length", Format.formatInteger(encode.encodedArrayLength()));
        }
        report.tablePair("Resettable", this.method instanceof MLResettable ? "true" : "false");
        report.tablePair("Context", this.method instanceof MLContext ? "true" : "false");
        if (this.method instanceof CPN) {
            CPN cpn = (CPN)this.method;
            report.tablePair("Instar Count", Format.formatInteger(cpn.getInstarCount()));
            report.tablePair("Outstar Count", Format.formatInteger(cpn.getOutstarCount()));
        }
        report.endTable();
        if (this.method instanceof MLFactory) {
            MLFactory factory = (MLFactory)((Object)this.method);
            String factoryType = factory.getFactoryType();
            String factoryArchitecture = factory.getFactoryArchitecture();
            if (factoryType != null) {
                report.h3("Encog Factory Code");
                report.beginTable();
                report.tablePair("Type", factoryType);
                report.tablePair("Architecture", factoryArchitecture);
                report.endTable();
            }
        }
        if (this.method instanceof RBFNetwork) {
            RBFNetwork rbfNetwork = (RBFNetwork)this.method;
            report.h3("RBF Centers");
            report.beginTable();
            report.beginRow();
            report.header("RBF");
            report.header("Peak");
            report.header("Width");
            int i = 1;
            while (i <= rbfNetwork.getInputCount()) {
                report.header("Center " + i);
                ++i;
            }
            report.endRow();
            RadialBasisFunction[] radialBasisFunctionArray = rbfNetwork.getRBF();
            int n = radialBasisFunctionArray.length;
            int factoryArchitecture = 0;
            while (factoryArchitecture < n) {
                RadialBasisFunction rbf = radialBasisFunctionArray[factoryArchitecture];
                report.beginRow();
                report.cell(rbf.getClass().getSimpleName());
                report.cell(Format.formatDouble(rbf.getPeak(), 5));
                report.cell(Format.formatDouble(rbf.getWidth(), 5));
                int i2 = 0;
                while (i2 < rbfNetwork.getInputCount()) {
                    report.cell(Format.formatDouble(rbf.getCenter(i2), 5));
                    ++i2;
                }
                report.endRow();
                ++factoryArchitecture;
            }
        }
        if (this.method instanceof BasicNetwork) {
            report.h3("Layers");
            report.beginTable();
            report.beginRow();
            report.header("Layer #");
            report.header("Total Count");
            report.header("Neuron Count");
            report.header("Activation Function");
            report.header("Bias");
            report.header("Context Target Size");
            report.header("Context Target Offset");
            report.header("Context Count");
            report.endRow();
            BasicNetwork network = (BasicNetwork)this.method;
            FlatNetwork flat = network.getStructure().getFlat();
            int layerCount = network.getLayerCount();
            int l = 0;
            while (l < layerCount) {
                report.beginRow();
                StringBuilder str = new StringBuilder();
                str.append(Format.formatInteger(l + 1));
                if (l == 0) {
                    str.append(" (Output)");
                } else if (l == network.getLayerCount() - 1) {
                    str.append(" (Input)");
                }
                report.cell(str.toString());
                report.cell(Format.formatInteger(flat.getLayerCounts()[l]));
                report.cell(Format.formatInteger(flat.getLayerFeedCounts()[l]));
                report.cell(flat.getActivationFunctions()[l].getClass().getSimpleName());
                report.cell(Format.formatDouble(flat.getBiasActivation()[l], 4));
                report.cell(Format.formatInteger(flat.getContextTargetSize()[l]));
                report.cell(Format.formatInteger(flat.getContextTargetOffset()[l]));
                report.cell(Format.formatInteger(flat.getLayerContextCount()[l]));
                report.endRow();
                ++l;
            }
            report.endTable();
        }
        report.endBody();
        report.endHTML();
        this.editor.setText(report.toString());
    }

    private void restructureHopfield() {
        HopfieldNetwork hopfield = (HopfieldNetwork)this.method;
        CreateHopfieldDialog dialog = new CreateHopfieldDialog(EncogWorkBench.getInstance().getMainWindow());
        dialog.getNeuronCount().setValue(hopfield.getNeuronCount());
        if (dialog.process() && hopfield.getNeuronCount() != dialog.getNeuronCount().getValue()) {
            HopfieldPattern pattern = new HopfieldPattern();
            pattern.setInputNeurons(dialog.getNeuronCount().getValue());
            this.setDirty(true);
            this.produceReport();
        }
    }

    private void restructureFeedforward() {
        String str;
        CreateFeedforward dialog = new CreateFeedforward(EncogWorkBench.getInstance().getMainWindow());
        BasicNetwork network = (BasicNetwork)this.method;
        int hiddenLayerCount = network.getLayerCount() - 2;
        ActivationFunction oldActivationOutput = network.getActivation(network.getLayerCount() - 1);
        ActivationFunction oldActivationHidden = hiddenLayerCount > 0 ? network.getActivation(1) : new ActivationTANH();
        dialog.setActivationFunctionOutput(oldActivationOutput);
        dialog.setActivationFunctionHidden(oldActivationHidden);
        dialog.getInputCount().setValue(network.getInputCount());
        dialog.getOutputCount().setValue(network.getOutputCount());
        int i = 0;
        while (i < hiddenLayerCount) {
            int num = network.getLayerNeuronCount(i + 1);
            str = "Hidden Layer " + (i + 1) + ": " + num + " neurons";
            dialog.getHidden().getModel().addElement(str);
            ++i;
        }
        if (dialog.process()) {
            if (dialog.getActivationFunctionHidden() != oldActivationHidden || dialog.getActivationFunctionOutput() != oldActivationOutput || dialog.getHidden().getModel().size() != network.getLayerCount() - 2) {
                FeedForwardPattern feedforward = new FeedForwardPattern();
                feedforward.setActivationFunction(dialog.getActivationFunctionHidden());
                feedforward.setActivationOutput(dialog.getActivationFunctionOutput());
                feedforward.setInputNeurons(dialog.getInputCount().getValue());
                int i2 = 0;
                while (i2 < dialog.getHidden().getModel().size()) {
                    str = (String)dialog.getHidden().getModel().getElementAt(i2);
                    int i1 = str.indexOf(58);
                    int i22 = str.indexOf("neur");
                    if (i1 != -1 && i22 != -1) {
                        str = str.substring(i1 + 1, i22).trim();
                        int neuronCount = Integer.parseInt(str);
                        feedforward.addHiddenLayer(neuronCount);
                    }
                    ++i2;
                }
                feedforward.setInputNeurons(dialog.getInputCount().getValue());
                feedforward.setOutputNeurons(dialog.getOutputCount().getValue());
                this.method = (BasicNetwork)feedforward.generate();
                ((ProjectEGFile)this.getEncogObject()).setObject(this.method);
                this.produceReport();
            } else {
                PruneSelective prune = new PruneSelective(network);
                int newInputCount = dialog.getInputCount().getValue();
                int newOutputCount = dialog.getOutputCount().getValue();
                if (newInputCount != network.getInputCount()) {
                    prune.changeNeuronCount(0, newInputCount);
                }
                if (newOutputCount != network.getOutputCount()) {
                    prune.changeNeuronCount(0, newOutputCount);
                }
                int i3 = 0;
                while (i3 < network.getLayerCount() - 2) {
                    int newHiddenCount = 1;
                    String str2 = (String)dialog.getHidden().getModel().getElementAt(i3);
                    int i1 = str2.indexOf(58);
                    int i2 = str2.indexOf("neur");
                    if (i1 != -1 && i2 != -1) {
                        str2 = str2.substring(i1 + 1, i2).trim();
                        newHiddenCount = Integer.parseInt(str2);
                    }
                    if (network.getLayerNeuronCount(i3) != newHiddenCount) {
                        prune.changeNeuronCount(i3 + 1, newHiddenCount);
                    }
                    ++i3;
                }
            }
            this.setDirty(true);
            this.produceReport();
        }
    }

    private void performRestructure() {
        if (this.method instanceof HopfieldNetwork) {
            this.restructureHopfield();
        } else if (this.method instanceof BasicNetwork) {
            this.restructureFeedforward();
        } else {
            EncogWorkBench.displayError("Error", "This Machine Learning Method cannot be restructured.");
        }
    }

    public void compareNetworks() {
        NetworkDialog dialog = new NetworkDialog(false);
        if (dialog.process()) {
            NetCompareTab tab = new NetCompareTab(this.method, (MLMethod)dialog.getMethodOrPopulation());
            EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Compare");
        }
    }

    @Override
    public String getName() {
        return this.getEncogObject().getName();
    }

    public void performWeights() {
        WeightsTab tab = new WeightsTab(this, (BasicNetwork)this.method);
        EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
    }
}

