/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.analyst;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.wizard.AnalystWizard;
import org.encog.util.file.FileUtil;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.dialogs.select.SelectDialog;
import org.encog.workbench.dialogs.select.SelectItem;
import org.encog.workbench.dialogs.visualize.scatter.ScatterChooseClass;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.analyst.AnalystProgressTab;
import org.encog.workbench.tabs.analyst.TasksModel;
import org.encog.workbench.tabs.files.text.BasicTextTab;
import org.encog.workbench.tabs.visualize.datareport.DataReportTab;
import org.encog.workbench.tabs.visualize.scatter.ScatterPlotTab;

public class EncogAnalystTab
extends BasicTextTab
implements ActionListener {
    private final JButton buttonExecute;
    private final JButton buttonAnalyzeData;
    private final JButton buttonVisualize;
    private final EncogAnalyst analyst = new EncogAnalyst();
    private final JComboBox tasks;
    private final TasksModel model;

    public EncogAnalystTab(ProjectFile file) {
        super(file);
        this.loadFromFile();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        this.buttonExecute = new JButton("Execute");
        this.buttonAnalyzeData = new JButton("Analyze Ranges");
        this.buttonAnalyzeData.addActionListener(this);
        this.buttonVisualize = new JButton("Visualize");
        this.buttonVisualize.addActionListener(this);
        this.buttonExecute.addActionListener(this);
        this.model = new TasksModel(this.analyst);
        this.tasks = new JComboBox(this.model);
        buttonPanel.add(this.tasks);
        buttonPanel.add(this.buttonExecute);
        buttonPanel.add(this.buttonAnalyzeData);
        buttonPanel.add(this.buttonVisualize);
        this.add((Component)buttonPanel, "North");
        this.compile();
    }

    public boolean compile() {
        try {
            int selected = this.tasks.getSelectedIndex();
            byte[] b = this.getText().getBytes();
            ByteArrayInputStream ms = new ByteArrayInputStream(b);
            this.analyst.getScript().setBasePath(EncogWorkBench.getInstance().getProjectDirectory().toString());
            this.analyst.load(ms);
            ms.close();
            this.model.refresh();
            if (this.analyst.getScript().getTask("task-full") != null) {
                this.tasks.setSelectedItem("task-full");
            } else if (this.model.getSize() > 0) {
                this.tasks.setSelectedIndex(0);
            }
            if (selected != -1) {
                this.tasks.setSelectedIndex(selected);
            }
            return true;
        }
        catch (AnalystError ex) {
            EncogWorkBench.getInstance().clearOutput();
            EncogWorkBench.getInstance().outputLine("**Compile Error");
            EncogWorkBench.getInstance().outputLine(ex.getMessage());
            EncogWorkBench.displayError("Error", "This Analyst Script has compile errors.");
            return false;
        }
        catch (IOException ex) {
            throw new WorkBenchError(ex);
        }
    }

    private void loadFromFile() {
        try {
            this.setText(FileUtil.readFileAsString(this.getEncogObject().getFile()));
        }
        catch (IOException e) {
            throw new WorkBenchError(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.buttonExecute) {
                this.execute();
            } else if (e.getSource() == this.buttonAnalyzeData) {
                this.analyzeData();
            } else if (e.getSource() == this.buttonVisualize) {
                this.visualizeData();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    private void visualizeData() {
        if (this.compile()) {
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            SelectItem dataReport = new SelectItem("Range Report", "See a report about the ranges adn columns.");
            list.add(dataReport);
            SelectItem scatterPlot = new SelectItem("Scatter Plot", "See basic relationships amoung the columns.");
            list.add(scatterPlot);
            SelectDialog sel = new SelectDialog(EncogWorkBench.getInstance().getMainWindow(), list);
            sel.setVisible(true);
            if (sel.getSelected() == dataReport) {
                this.analyzeRanges();
            } else if (sel.getSelected() == scatterPlot) {
                this.analyzeScatterPlot();
            }
        }
    }

    private void analyzeScatterPlot() {
        if (this.analyst.isTimeSeries()) {
            EncogWorkBench.displayError("Error", "Can't use scatter plot for time-series.");
            return;
        }
        ScatterChooseClass dialog = new ScatterChooseClass(this.analyst);
        if (dialog.process()) {
            if (dialog.getAxis().size() < 2) {
                EncogWorkBench.displayError("Error", "Must select at least two axes.");
                return;
            }
            try {
                EncogWorkBench.getInstance().getMainWindow().beginWait();
                ScatterPlotTab tab = new ScatterPlotTab(this.analyst, dialog.getClassName(), dialog.getAxis());
                EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
            }
            finally {
                EncogWorkBench.getInstance().getMainWindow().endWait();
            }
        }
    }

    private void analyzeRanges() {
        try {
            EncogWorkBench.getInstance().getMainWindow().beginWait();
            DataReportTab tab = new DataReportTab(this.analyst);
            EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
        }
        finally {
            EncogWorkBench.getInstance().getMainWindow().endWait();
        }
    }

    private boolean forceSave() {
        if (this.isDirty()) {
            if (EncogWorkBench.askQuestion("Save", "To perform this operation, you must save your script.\nWould you like to save this script?")) {
                this.save();
                return true;
            }
            return false;
        }
        return true;
    }

    private void execute() {
        if (this.forceSave() && this.compile()) {
            if (this.tasks.getSelectedIndex() == -1) {
                EncogWorkBench.displayError("Error", "No tasks to execute.");
                return;
            }
            EncogWorkBench.getInstance().clearOutput();
            String name = (String)this.tasks.getSelectedItem();
            AnalystProgressTab tab = new AnalystProgressTab(this.analyst, name);
            EncogWorkBench.getInstance().getMainWindow().getTabManager().openModalTab(tab, "Analyst");
        }
    }

    private void analyzeData() {
        block9: {
            try {
                if (this.isDirty()) {
                    EncogWorkBench.displayError("Unsaved File", "Please save your script before analyzing ranges.");
                    return;
                }
                if (!EncogWorkBench.askQuestion("Analyze", "Do you want to analyze the raw file and update ranges?\nThis can be useful when the contents of the raw file have changed.")) break block9;
                if (!this.compile()) {
                    return;
                }
                try {
                    EncogWorkBench.getInstance().getMainWindow().beginWait();
                    AnalystWizard wizard = new AnalystWizard(this.analyst);
                    wizard.reanalyze();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    this.analyst.save(os);
                    os.close();
                    this.setText(os.toString());
                    EncogWorkBench.displayMessage("Complete", "Ranges have been updated, save your file if changes are acceptable.");
                }
                catch (IOException ex) {
                    throw new WorkBenchError(ex);
                }
            }
            finally {
                EncogWorkBench.getInstance().getMainWindow().endWait();
            }
        }
    }
}

