/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs;

import java.io.IOException;
import javax.swing.JPanel;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;

public abstract class EncogCommonTab
extends JPanel {
    private ProjectFile encogObject;
    private EncogDocumentFrame owner;
    private boolean modal;
    private boolean dirty = false;
    private EncogCommonTab parentTab;

    public EncogCommonTab(ProjectFile encogObject) {
        this.encogObject = encogObject;
    }

    public ProjectFile getEncogObject() {
        return this.encogObject;
    }

    public boolean close() throws IOException {
        if (this.getEncogObject() != null && this.dirty) {
            if (EncogWorkBench.askQuestion("Save", "Would you like to save your changes?")) {
                if (this.parentTab != null) {
                    this.parentTab.setEncogObject(this.encogObject);
                    this.getEncogObject().save();
                } else {
                    this.getEncogObject().save();
                }
            } else {
                ((ProjectEGFile)this.getEncogObject()).revert();
            }
        }
        return true;
    }

    public void dispose() {
        try {
            this.owner.getTabManager().closeTab(this);
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    public void setParent(EncogDocumentFrame owner) {
        this.owner = owner;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setEncogObject(ProjectFile encogObject) {
        this.encogObject = encogObject;
    }

    @Override
    public abstract String getName();

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean needUpdate = this.dirty ^ dirty;
        this.dirty = dirty;
        if (needUpdate) {
            this.updateTitle();
        }
    }

    public EncogCommonTab getParentTab() {
        return this.parentTab;
    }

    public void setParentTab(EncogCommonTab parentTab) {
        this.parentTab = parentTab;
    }

    public void save() {
        if (this.getEncogObject() != null) {
            this.getEncogObject().save();
        }
        this.setDirty(false);
    }

    public void refresh() {
    }

    public void updateTitle() {
        StringBuilder t = new StringBuilder();
        if (this.isDirty()) {
            t.append("* ");
        }
        t.append(this.getName());
        EncogWorkBench.getInstance().getMainWindow().getTabManager().renameTab(this, t.toString());
    }
}

