/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.encog.bot.browse.Browser;
import org.encog.bot.browse.WebPage;
import org.encog.bot.browse.range.DocumentRange;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;

public class BrowserFrame
extends EncogCommonTab
implements TreeSelectionListener,
ActionListener {
    private JPanel contentsPanel;
    private JScrollPane dataPanel;
    private JButton goButton;
    private JTextField address;
    private JPanel addressPanel;
    private JPanel bodyPanel;
    private JTree tree;
    private DefaultTreeModel model;
    private DefaultMutableTreeNode root;
    private Browser browser;
    private WebPage page;
    private JScrollPane scroll;
    private JTextArea dataText;

    public BrowserFrame() {
        super((ProjectFile)null);
        this.setLayout(new GridLayout(2, 1));
        this.contentsPanel = new JPanel();
        this.add(this.contentsPanel);
        this.contentsPanel.setLayout(new BorderLayout());
        this.addressPanel = new JPanel();
        this.bodyPanel = new JPanel();
        this.addressPanel.setLayout(new BorderLayout());
        this.bodyPanel.setLayout(new BorderLayout());
        this.contentsPanel.add((Component)this.addressPanel, "North");
        this.contentsPanel.add((Component)this.bodyPanel, "Center");
        this.address = new JTextField();
        this.addressPanel.add((Component)this.address, "Center");
        this.goButton = new JButton("Go");
        this.addressPanel.add((Component)this.goButton, "East");
        this.address.setText("http://www.heatonresearch.com/");
        this.goButton.addActionListener(this);
        this.root = new DefaultMutableTreeNode("Page");
        this.model = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.model);
        this.scroll = new JScrollPane(this.tree);
        this.bodyPanel.add((Component)this.scroll, "Center");
        this.dataText = new JTextArea();
        this.dataPanel = new JScrollPane(this.dataText);
        this.dataText.setEditable(false);
        this.add(this.dataPanel);
        this.tree.addTreeSelectionListener(this);
        this.browser = new Browser();
        this.page = this.browser.getCurrentPage();
    }

    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.goButton) {
            this.browser = new Browser();
            this.browser.navigate(this.address.getText());
            this.page = this.browser.getCurrentPage();
            this.root.setUserObject(this.address.getText());
            this.root.removeAllChildren();
            this.generateTree(this.page.getContents(), this.root);
            this.model.reload();
            this.tree.invalidate();
        }
    }

    private void generateTree(List<DocumentRange> list, DefaultMutableTreeNode node) {
        for (DocumentRange data : list) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(data);
            node.add(n);
            this.generateTree(data.getElements(), n);
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node;
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null && node.getUserObject() instanceof DocumentRange) {
            DocumentRange range = (DocumentRange)node.getUserObject();
            this.dataText.setText(range.getTextOnly());
        }
    }

    @Override
    public String getName() {
        return "Browse";
    }
}

