/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.process.validate;

public class ResourceNameValidate {
    public static final String VALID_SYMBOL = "-_";

    public static boolean hasInvalidChars(String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch) && VALID_SYMBOL.indexOf(ch) == -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String validateResourceName(String name) {
        if (ResourceNameValidate.hasInvalidChars(name)) {
            return "That name has invalid chars, only use alphanumeric, dash or underbar.";
        }
        if (name.length() > 64) {
            return "Name must be at most 64 characters.";
        }
        if (name.length() < 2) {
            return "Name must be at least 2 characters.";
        }
        return null;
    }
}

