/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models.population.neat;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.species.Species;
import org.encog.util.Format;

public class SpeciesModel
implements TableModel {
    private Population population;
    public static String[] COLUMNS = new String[]{"Name", "Age", "Best Score", "Stagnant", "Members"};

    public SpeciesModel(Population population) {
        this.population = population;
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.population.getSpecies().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Species species = this.population.getSpecies().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return "Species #" + (rowIndex + 1);
            }
            case 1: {
                return Format.formatInteger(species.getAge());
            }
            case 2: {
                return Format.formatDouble(species.getBestScore(), 4);
            }
            case 3: {
                return Format.formatInteger(species.getGensNoImprovement());
            }
            case 4: {
                return Format.formatInteger(species.getMembers().size());
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

