/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.ml.data.buffer.EncogEGBFile;
import org.encog.workbench.EncogWorkBench;

public class BufferedDataSetTableModel
implements TableModel {
    private final BufferedMLDataSet data;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private EncogEGBFile egb;

    public BufferedDataSetTableModel(BufferedMLDataSet data) {
        this.data = data;
        this.egb = data.getEGB();
    }

    public void addIdealColumn() {
        this.egb.addColumn(this.egb.getRecordCount() - 1, false);
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void addInputColumn() {
        this.egb.addColumn(this.egb.getInputCount() - 1, true);
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void addRow(int row) {
        if (row < 0) {
            this.egb.addRow(0);
        } else {
            this.egb.addRow(row);
        }
        TableModelEvent tce = new TableModelEvent(this);
        this.notifyListeners(tce);
    }

    @Override
    public void addTableModelListener(TableModelListener listner) {
        this.listeners.add(listner);
    }

    public void delColumn(int col) {
        if (col == this.getColumnCount() - 1) {
            EncogWorkBench.displayError("Error", "You can't delete the significance column.");
            return;
        }
        if (col == 0 && this.egb.getInputCount() == 1) {
            EncogWorkBench.displayError("Error", "You can't delete the last input column.  There must be at least one input.");
            return;
        }
        if (this.egb.getRecordCount() < 2) {
            EncogWorkBench.displayError("Error", "There must be at least one column.");
            return;
        }
        this.egb.deleteCol(col);
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void delRow(int row) {
        this.egb.deleteRow(row);
        TableModelEvent tce = new TableModelEvent(this);
        this.notifyListeners(tce);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return this.egb.getRecordCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.data.getInputSize()) {
            return "Input " + (columnIndex + 1);
        }
        if (columnIndex < this.data.getInputSize() + this.data.getIdealSize()) {
            return "Ideal " + (columnIndex + 1 - this.data.getInputSize());
        }
        return "Significance";
    }

    @Override
    public int getRowCount() {
        return this.egb.getNumberOfRecords();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    private void notifyListeners(TableModelEvent tce) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tce);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.egb.read(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object rawValue, int rowIndex, int columnIndex) {
        double d = 0.0;
        d = rawValue instanceof Double ? (Double)rawValue : Double.parseDouble(rawValue.toString());
        this.egb.write(rowIndex, columnIndex, d);
    }
}

