/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class EditorCellEditor
implements TableCellEditor {
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private JTextField editorText = new JTextField();
    private JComboBox editorBoolean = new JComboBox<String>(BOOLEAN_VALUES);
    private Class currentClass;
    private Object value;
    private int row;
    private int column;
    private JTable table;
    public static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.table = table;
        this.currentClass = value.getClass();
        this.value = value;
        if (this.currentClass == Boolean.class) {
            this.editorBoolean.setVisible(true);
            if (((Boolean)value).booleanValue()) {
                this.editorBoolean.setSelectedIndex(0);
            } else {
                this.editorBoolean.setSelectedIndex(1);
            }
            return this.editorBoolean;
        }
        this.editorText.setVisible(true);
        this.editorText.setText(value.toString());
        return this.editorText;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        if (this.currentClass == Boolean.class) {
            this.editorBoolean.setVisible(false);
            this.editorBoolean.setSelectedIndex(0);
        } else {
            this.editorText.setVisible(false);
            this.editorText.setText("");
        }
    }

    @Override
    public Object getCellEditorValue() {
        this.stopCellEditing();
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.currentClass == Boolean.class) {
            this.value = this.editorBoolean.getSelectedIndex() == 0;
            System.out.println(this.value);
            this.editorBoolean.setVisible(false);
        } else {
            this.editorText.setVisible(false);
            this.value = this.editorText.getText();
        }
        if (this.table != null) {
            this.table.setValueAt(this.value, this.row, this.column);
        }
        return true;
    }

    public void clearSelection() {
        this.editorBoolean.setVisible(false);
        this.editorText.setVisible(false);
    }
}

