/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.visualize.scatter;

import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.CheckListener;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.frames.document.tree.ProjectTraining;

public class ScatterChooseClass
extends EncogPropertiesDialog
implements CheckListener {
    private ComboBoxField comboClass;
    private List<CheckField> fields = new ArrayList<CheckField>();
    private static final long serialVersionUID = 3506669325409959724L;
    private List<ProjectTraining> trainingSets;
    private List<String> classNames = new ArrayList<String>();
    private CheckField selectAllField;

    public ScatterChooseClass(EncogAnalyst analyst) {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.setTitle("Create Scatter Plot");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        for (AnalystField field : analyst.getScript().getNormalize().getNormalizedFields()) {
            if (field.isIgnored() || !field.isOutput()) continue;
            this.classNames.add(field.getName());
        }
        this.comboClass = new ComboBoxField("training set", "Training Set", true, this.classNames);
        this.addProperty(this.comboClass);
        for (AnalystField field : analyst.getScript().getNormalize().getNormalizedFields()) {
            if (field.isIgnored() || !field.isInput()) continue;
            CheckField cf = new CheckField(field.getName(), field.getName());
            this.addProperty(cf);
            this.fields.add(cf);
            cf.setListener(this);
        }
        this.selectAllField = new CheckField("all", "Select All");
        this.addProperty(this.selectAllField);
        this.selectAllField.setListener(this);
        this.render();
    }

    public String getClassName() {
        return (String)this.comboClass.getSelectedValue();
    }

    public List<String> getAxis() {
        ArrayList<String> result = new ArrayList<String>();
        for (CheckField check : this.fields) {
            if (!check.getValue()) continue;
            result.add(check.getName());
        }
        return result;
    }

    @Override
    public void check(CheckField check) {
        if (check == this.selectAllField) {
            boolean v = this.selectAllField.getValue();
            for (CheckField field : this.fields) {
                field.setValue(v);
            }
        } else {
            boolean v = true;
            for (CheckField field : this.fields) {
                if (field.getValue()) continue;
                v = false;
                break;
            }
            this.selectAllField.setValue(v);
        }
    }
}

