/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.training.methods;

import java.util.ArrayList;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodBubble;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodFunction;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodRBF;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodRBF1D;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodSingle;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.DoubleField;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.training.DialogMaxError;

public class InputSOM
extends DialogMaxError {
    private static final long serialVersionUID = 1L;
    private final DoubleField learningRate;
    private final ComboBoxField neighborhoodType;
    private final DoubleField rbfWidth;
    private final IntegerField rows;
    private final IntegerField cols;
    private final CheckField forceWinner;

    public InputSOM() {
        super(false);
        ArrayList<String> list = new ArrayList<String>();
        list.add("1D RBF - Gaussian");
        list.add("1D RBF - MexicanHat");
        list.add("1D RBF - Multiquadric");
        list.add("1D RBF - InverseMultiquadric");
        list.add("1D - Bubble");
        list.add("1D - Single");
        list.add("2D RBF - Gaussian");
        list.add("2D RBF - MexicanHat");
        list.add("2D RBF - Multiquadric");
        list.add("2D RBF - InverseMultiquadric");
        this.setTitle("Train SOM Network");
        this.learningRate = new DoubleField("learning rate", "Learning Rate", true, 0, -1);
        this.addProperty(this.learningRate);
        this.neighborhoodType = new ComboBoxField("neighborhood", "Neighborhood Type", true, list);
        this.addProperty(this.neighborhoodType);
        this.rbfWidth = new DoubleField("rbf width", "RBF Width", true, 0, 1000);
        this.addProperty(this.rbfWidth);
        this.cols = new IntegerField("cols", "2D RBF Columns", true, 0, 1000000);
        this.addProperty(this.cols);
        this.rows = new IntegerField("rows", "2D RBF Rows", true, 0, 1000000);
        this.addProperty(this.rows);
        this.forceWinner = new CheckField("force winner", "Force Winner");
        this.addProperty(this.forceWinner);
        this.render();
        this.learningRate.setValue(0.25);
        this.getRBFWidth().setValue(2.0);
        this.getCols().setValue(1);
        this.getRows().setValue(1);
        this.getForceWinner().setValue(true);
    }

    public DoubleField getLearningRate() {
        return this.learningRate;
    }

    public NeighborhoodFunction getNeighborhoodFunction() {
        switch (this.neighborhoodType.getSelectedIndex()) {
            case 0: {
                return new NeighborhoodRBF1D(new GaussianFunction(0.0, 1.0, this.rbfWidth.getValue()));
            }
            case 1: {
                return new NeighborhoodRBF1D(new MexicanHatFunction(0.0, 1.0, this.rbfWidth.getValue()));
            }
            case 2: {
                return new NeighborhoodRBF1D(new MultiquadricFunction(0.0, 1.0, this.rbfWidth.getValue()));
            }
            case 3: {
                return new NeighborhoodRBF1D(new InverseMultiquadricFunction(0.0, 1.0, this.rbfWidth.getValue()));
            }
            case 4: {
                return new NeighborhoodBubble((int)this.rbfWidth.getValue());
            }
            case 5: {
                return new NeighborhoodSingle();
            }
            case 6: {
                return new NeighborhoodRBF(RBFEnum.Gaussian, this.cols.getValue(), this.rows.getValue());
            }
            case 7: {
                return new NeighborhoodRBF(RBFEnum.MexicanHat, this.cols.getValue(), this.rows.getValue());
            }
            case 8: {
                return new NeighborhoodRBF(RBFEnum.Multiquadric, this.cols.getValue(), this.rows.getValue());
            }
            case 9: {
                return new NeighborhoodRBF(RBFEnum.InverseMultiquadric, this.cols.getValue(), this.rows.getValue());
            }
        }
        return null;
    }

    public DoubleField getRBFWidth() {
        return this.rbfWidth;
    }

    public IntegerField getRows() {
        return this.rows;
    }

    public IntegerField getCols() {
        return this.cols;
    }

    public CheckField getForceWinner() {
        return this.forceWinner;
    }
}

