/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.training;

import java.util.List;
import javax.swing.JComboBox;
import org.encog.ml.MLMethod;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;

public class NetworkDialog
extends EncogPropertiesDialog {
    private ComboBoxField comboNetwork;
    private List<ProjectEGFile> networks;

    public NetworkDialog(boolean includePop) {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.findData(includePop);
        this.setTitle("Choose a Neural Network");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        this.comboNetwork = new ComboBoxField("network", "Neural Network", true, this.networks);
        this.addProperty(this.comboNetwork);
        this.render();
    }

    private void findData(boolean includePop) {
        this.networks = EncogWorkBench.getInstance().getMLMethods(includePop);
    }

    public Object getMethodOrPopulation() {
        if (this.comboNetwork.getSelectedValue() == null) {
            return null;
        }
        return ((ProjectEGFile)this.comboNetwork.getSelectedValue()).getObject();
    }

    public MLMethod getNetwork() {
        Object obj = this.getMethodOrPopulation();
        if (!(obj instanceof MLMethod)) {
            throw new WorkBenchError("This operation requires a MLMethod, not a \n" + obj.getClass().getName());
        }
        return (MLMethod)obj;
    }

    public void setMethod(ProjectFile method) {
        ((JComboBox)this.comboNetwork.getField()).setSelectedItem(method);
    }

    public ComboBoxField getComboNetwork() {
        return this.comboNetwork;
    }
}

